/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.tileentities.console.misc;

import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.INBTSerializable;
import net.tardis.mod.client.animation.ExteriorAnimationEntry;
import net.tardis.mod.misc.Disguise;
import net.tardis.mod.registries.DisguiseRegistry;
import net.tardis.mod.registries.ExteriorAnimationRegistry;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.tileentities.exteriors.ExteriorTile;

public class ExteriorPropertyManager
implements INBTSerializable<CompoundNBT> {
    public static final ResourceLocation NAME = new ResourceLocation("tardis", "exterior_manager");
    protected ConsoleTile console;
    private ResourceLocation exteriorAnimation = new ResourceLocation("tardis", "classic");
    private int variantIndex = 0;
    private Disguise disguise;

    public ExteriorPropertyManager(ConsoleTile tile) {
        this.console = tile;
        tile.registerDataHandler(NAME, this);
    }

    public void setExteriorAnimation(ResourceLocation loc) {
        this.exteriorAnimation = loc;
        if (this.console != null && !this.console.func_145831_w().field_72995_K) {
            this.console.getExteriorType().getExteriorTile(this.console).setExteriorAnimation((ExteriorAnimationEntry)ExteriorAnimationRegistry.EXTERIOR_ANIMATION_REGISTRY.get().getValue(loc));
        }
    }

    public ResourceLocation getExteriorAnimation() {
        return this.exteriorAnimation;
    }

    public int getExteriorVariant() {
        return this.variantIndex;
    }

    public void setExteriorVariant(int i) {
        if (this.console.getExteriorType().getVariants() != null && this.console.getExteriorType().getVariants().length > i) {
            ExteriorTile tile;
            this.variantIndex = i;
            if (!this.console.func_145831_w().field_72995_K && (tile = this.console.getExteriorType().getExteriorTile(this.console)) != null) {
                tile.setVariant(i);
            }
            return;
        }
        this.variantIndex = 0;
    }

    public void setDisguise(Disguise dis) {
        this.disguise = dis;
    }

    public Disguise getDisguise() {
        return this.disguise;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a("exterior_animation", this.exteriorAnimation.toString());
        tag.func_74768_a("variant", this.variantIndex);
        if (this.disguise != null) {
            tag.func_74778_a("disguise", this.disguise.getRegistryName().toString());
        }
        return tag;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        if (nbt.isEmpty()) {
            return;
        }
        if (nbt.func_74764_b("exterior_animation")) {
            this.exteriorAnimation = new ResourceLocation(nbt.func_74779_i("exterior_animation"));
        }
        if (nbt.func_74764_b("disguise")) {
            this.disguise = (Disguise)DisguiseRegistry.DISGUISE_REGISTRY.get().getValue(new ResourceLocation(nbt.func_74779_i("disguise")));
        }
        this.variantIndex = nbt.func_74762_e("variant");
    }
}

