/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.tileentities.console.misc;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.INBTSerializable;
import net.tardis.mod.config.TConfig;
import net.tardis.mod.controls.HandbrakeControl;
import net.tardis.mod.controls.ThrottleControl;
import net.tardis.mod.misc.ITickable;
import net.tardis.mod.registries.TraitRegistry;
import net.tardis.mod.subsystem.StabilizerSubsystem;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.tileentities.console.misc.PlayerTelepathicConnection;
import net.tardis.mod.traits.TardisTrait;
import net.tardis.mod.traits.TardisTraitType;

public class EmotionHandler
implements ITickable,
INBTSerializable<CompoundNBT> {
    private static final ResourceLocation SAVE_KEY = new ResourceLocation("tardis", "emotion");
    private TardisTrait[] traits = new TardisTrait[5];
    private ConsoleTile tile;
    private HashMap<UUID, Integer> loyalties = Maps.newHashMap();
    private double mood;
    private long lastTimePlayerInTardis;
    private boolean hasGeneratedTraits;
    private Map<UUID, PlayerTelepathicConnection> connectedPlayers;

    public EmotionHandler(ConsoleTile console) {
        this.mood = EnumHappyState.CONTENT.threshold;
        this.lastTimePlayerInTardis = 0L;
        this.hasGeneratedTraits = false;
        this.connectedPlayers = Maps.newHashMap();
        console.registerDataHandler(SAVE_KEY, this);
        console.registerTicker(this);
        this.tile = console;
    }

    public void deserializeNBT(CompoundNBT tag) {
        ListNBT loyaltyList = tag.func_150295_c("loyalties", 10);
        for (INBT l : loyaltyList) {
            CompoundNBT loyaltyTag = (CompoundNBT)l;
            this.loyalties.put(UUID.fromString(loyaltyTag.func_74779_i("id")), loyaltyTag.func_74762_e("loyalty"));
        }
        this.mood = tag.func_74762_e("mood");
        this.hasGeneratedTraits = tag.func_74767_n("has_generated_traits");
        this.traits = new TardisTrait[5];
        if (tag.func_74764_b("trait_list")) {
            ListNBT list = tag.func_150295_c("trait_list", 10);
            int i = 0;
            for (INBT base : list) {
                CompoundNBT nbt = (CompoundNBT)base;
                TardisTrait trait = ((TardisTraitType)TraitRegistry.TRAIT_REGISTRY.get().getValue(new ResourceLocation(nbt.func_74779_i("registry_name")))).create();
                trait.setWeight(nbt.func_74769_h("weight"));
                this.traits[i] = trait;
                ++i;
            }
        }
        ListNBT connectedList = tag.func_150295_c("connectedPlayers", 10);
        this.connectedPlayers.clear();
        for (INBT con : connectedList) {
            CompoundNBT conTag = (CompoundNBT)con;
            UUID id = conTag.func_186857_a("id");
            CompoundNBT connectionInfo = (CompoundNBT)conTag.func_74781_a("connection_info");
            this.connectedPlayers.put(id, new PlayerTelepathicConnection(this.tile, connectionInfo));
        }
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT tag = new CompoundNBT();
        ListNBT loyaltyList = new ListNBT();
        for (Map.Entry<UUID, Integer> entry : this.loyalties.entrySet()) {
            CompoundNBT loyTag = new CompoundNBT();
            loyTag.func_74778_a("id", entry.getKey().toString());
            loyTag.func_74768_a("loyalty", entry.getValue().intValue());
            loyaltyList.add((Object)loyTag);
        }
        tag.func_218657_a("loyalties", (INBT)loyaltyList);
        tag.func_74780_a("mood", this.mood);
        tag.func_74757_a("has_generated_traits", this.hasGeneratedTraits);
        ListNBT traits = new ListNBT();
        for (TardisTrait trait : this.traits) {
            if (trait == null) continue;
            CompoundNBT traitTag = new CompoundNBT();
            traitTag.func_74778_a("registry_name", trait.getType().getRegistryName().toString());
            traitTag.func_74780_a("weight", trait.getWeight());
            traits.add((Object)traitTag);
        }
        tag.func_218657_a("trait_list", (INBT)traits);
        ListNBT listNBT = new ListNBT();
        for (Map.Entry<UUID, PlayerTelepathicConnection> con : this.connectedPlayers.entrySet()) {
            CompoundNBT connectionTag = new CompoundNBT();
            connectionTag.func_186854_a("id", con.getKey());
            connectionTag.func_218657_a("connection_info", (INBT)con.getValue().serializeNBT());
            listNBT.add((Object)connectionTag);
        }
        tag.func_218657_a("connectedPlayers", (INBT)listNBT);
        return tag;
    }

    @Override
    public void tick(ConsoleTile console) {
        if (!console.func_145831_w().func_201670_d()) {
            this.fixOldData();
        }
        if (console.func_145831_w().func_82737_E() % 80L == 0L) {
            double prevMood = this.mood;
            if (console.isInFlight() && this.mood < (double)EnumHappyState.ECSTATIC.getTreshold() * 1.5) {
                console.getSubsystem(StabilizerSubsystem.class).ifPresent(sys -> this.mood += (double)(sys.isControlActivated() ? 1 : 2));
            }
            if (!console.func_145831_w().func_201670_d()) {
                if (((ServerWorld)console.func_145831_w()).func_217369_A().isEmpty() && this.mood > (double)EnumHappyState.SAD.getTreshold() * 1.75) {
                    int n;
                    long abandonedTime;
                    if (console.getPilot() != null && (abandonedTime = console.func_145831_w().func_82737_E() - this.lastTimePlayerInTardis) > (long)(n = (Integer)TConfig.SERVER.tardisAbandonmentTimer.get() * 24000)) {
                        this.mood -= 0.5;
                    }
                } else {
                    this.lastTimePlayerInTardis = console.func_145831_w().func_82737_E();
                }
                for (Map.Entry<UUID, Integer> entry : this.loyalties.entrySet()) {
                    if (entry.getValue() > -50 || !(this.mood < (double)EnumHappyState.DISCONTENT.threshold) || console.getPilot() != null || console.isInFlight() || !(ConsoleTile.rand.nextDouble() < 0.01)) continue;
                    this.getPissyAndLeave(console);
                }
                if (this.tile.func_145830_o() && !this.tile.func_145831_w().field_72995_K) {
                    HashMap connectionsToRemove = Maps.newHashMap();
                    for (Map.Entry<UUID, PlayerTelepathicConnection> entry : this.getConnectedPlayers().entrySet()) {
                        if (!entry.getValue().decrementAndCheckRemove(this.tile.func_145831_w().func_73046_m())) continue;
                        connectionsToRemove.put(entry.getKey(), entry.getValue());
                    }
                    for (Map.Entry entry : connectionsToRemove.entrySet()) {
                        this.connectedPlayers.remove(entry.getKey());
                    }
                }
            }
            if (prevMood > this.mood) {
                console.func_145831_w().func_195594_a((IParticleData)ParticleTypes.field_197609_b, (double)console.func_174877_v().func_177958_n() + 0.5, (double)(console.func_174877_v().func_177956_o() + 2), (double)console.func_174877_v().func_177952_p() + 0.5, 0.0, 0.5, 0.0);
            } else if (prevMood < this.mood) {
                console.func_145831_w().func_195594_a((IParticleData)ParticleTypes.field_197633_z, (double)console.func_174877_v().func_177958_n() + 0.5, (double)(console.func_174877_v().func_177956_o() + 2), (double)console.func_174877_v().func_177952_p() + 0.5, 0.0, 0.5, 0.0);
            }
        }
        for (TardisTrait tardisTrait : this.traits) {
            if (console.func_145831_w().func_201670_d() || tardisTrait == null) continue;
            tardisTrait.tick(console);
        }
    }

    private void getPissyAndLeave(ConsoleTile console) {
        if (!console.isInFlight()) {
            console.getControl(HandbrakeControl.class).ifPresent(handBrake -> {
                if (handBrake.isFree()) {
                    console.getControl(ThrottleControl.class).ifPresent(throt -> throt.setAmount(1.0f));
                    console.getSubsystem(StabilizerSubsystem.class).ifPresent(sys -> sys.setControlActivated(true));
                    console.setDestination(console.getCurrentDimension(), console.randomizeCoords(console.getCurrentLocation(), 150));
                    console.takeoff();
                }
            });
        }
    }

    public void fixOldData() {
        if (!this.hasGeneratedTraits) {
            this.onInitialSpawn();
        }
    }

    public void setLoyalty(UUID id, int loyalty) {
        this.loyalties.put(id, loyalty);
    }

    public int getLoyalty(UUID playerUUID) {
        return this.loyalties.getOrDefault(playerUUID, 0);
    }

    public Set<UUID> getLoyaltyTrackingCrew() {
        return this.loyalties.keySet();
    }

    public double getMood() {
        return this.mood;
    }

    public EnumHappyState getMoodState() {
        for (EnumHappyState state : EnumHappyState.values()) {
            if (!(this.mood >= (double)state.getTreshold())) continue;
            return state;
        }
        return EnumHappyState.SAD;
    }

    public void setMood(double mood) {
        this.mood = mood;
    }

    public void addMood(double mood) {
        this.mood += mood;
    }

    public void addLoyalty(UUID playerUUID, int loyalty) {
        int current = this.getLoyalty(playerUUID);
        this.loyalties.put(playerUUID, current + loyalty);
    }

    public TardisTrait[] getTraits() {
        return this.traits;
    }

    public void regenerateTraits() {
        this.traits = null;
        this.generateTardisTraits();
    }

    public void onInitialSpawn() {
        this.generateTardisTraits();
    }

    private void generateTardisTraits() {
        this.traits = new TardisTrait[5];
        int i = 0;
        ArrayList possibleTraits = Lists.newArrayList((Iterable)TraitRegistry.TRAIT_REGISTRY.get().getValues());
        for (int x = 0; x < 25 && !possibleTraits.isEmpty() && x < 3; ++x) {
            TardisTraitType type = (TardisTraitType)((Object)possibleTraits.get(ConsoleTile.rand.nextInt(possibleTraits.size())));
            if (this.hasIncompatibleTrait(type)) continue;
            this.traits[i] = type.create().setWeight(ConsoleTile.rand.nextDouble());
            possibleTraits.remove((Object)type);
            ++i;
        }
        this.hasGeneratedTraits = true;
    }

    private boolean hasIncompatibleTrait(TardisTraitType type) {
        for (int y = 0; y < this.traits.length; ++y) {
            TardisTrait old = this.traits[y];
            if (old == null || old.getType().isCompatible(type)) continue;
            return true;
        }
        return false;
    }

    public void addLoyalty(@Nullable PlayerEntity player, int loyalty) {
        if (player != null) {
            this.addLoyalty(player.func_110124_au(), loyalty);
        }
    }

    public Map<UUID, PlayerTelepathicConnection> getConnectedPlayers() {
        return this.connectedPlayers;
    }

    public void addConnectedPlayer(PlayerTelepathicConnection connection) {
        this.connectedPlayers.put(connection.getPlayerId(), connection);
    }

    public void removeConnectedPlayer(PlayerTelepathicConnection connection) {
        this.connectedPlayers.remove(connection.getPlayerId());
    }

    public static enum EnumHappyState {
        ECSTATIC(100, "ecstatic"),
        HAPPY(90, "happy"),
        CONTENT(50, "content"),
        APATHETIC(0, "apathetic"),
        DISCONTENT(-20, "discontent"),
        SAD(-100, "sad");

        int threshold = 0;
        TranslationTextComponent trans;

        private EnumHappyState(int threshold, String key) {
            this.threshold = threshold;
            this.trans = new TranslationTextComponent("mood.tardis." + key);
        }

        public int getTreshold() {
            return this.threshold;
        }

        public TranslationTextComponent getTranslationComponent() {
            return this.trans;
        }
    }
}

