/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.tileentities.console.misc;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.tardis.mod.misc.SpaceTimeCoord;
import net.tardis.mod.missions.MiniMissionType;
import net.tardis.mod.registries.MissionRegistry;

public class DistressSignal {
    public static final int STRING_SIZE = 16;
    SpaceTimeCoord coord;
    String message;
    private MiniMissionType mission;

    public DistressSignal(String message, SpaceTimeCoord coord) {
        this.coord = coord;
        this.message = message;
    }

    public DistressSignal(String message, SpaceTimeCoord coord, MiniMissionType type) {
        this(message, coord);
        this.mission = type;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_218657_a("coord", (INBT)this.coord.serialize());
        tag.func_74778_a("message", this.message);
        if (this.mission != null) {
            tag.func_74778_a("mission", this.mission.getRegistryName().toString());
        }
        return tag;
    }

    public SpaceTimeCoord getSpaceTimeCoord() {
        return this.coord;
    }

    public String getMessage() {
        return this.message;
    }

    @Nullable
    public MiniMissionType getMission() {
        return this.mission;
    }

    public static DistressSignal deserializeNBT(CompoundNBT tag) {
        String message = tag.func_74779_i("message");
        SpaceTimeCoord coord = SpaceTimeCoord.deserialize(tag.func_74775_l("coord"));
        if (tag.func_74764_b("mission")) {
            ResourceLocation key = new ResourceLocation(tag.func_74779_i("mission"));
            MiniMissionType mission = (MiniMissionType)MissionRegistry.MISSION_REGISTRY.get().getValue(key);
            if (mission != null) {
                return new DistressSignal(message, coord, mission);
            }
        }
        return new DistressSignal(message, coord);
    }

    public void encode(PacketBuffer buf) {
        buf.func_150786_a(this.coord.serialize());
        buf.writeInt(this.message.length());
        buf.func_211400_a(this.message, this.message.length());
        boolean hasMission = this.mission != null;
        buf.writeBoolean(hasMission);
        if (hasMission) {
            buf.func_192572_a(this.mission.getRegistryName());
        }
    }

    public static DistressSignal decode(PacketBuffer buf) {
        SpaceTimeCoord coord = SpaceTimeCoord.deserialize(buf.func_150793_b());
        int stringSize = buf.readInt();
        String message = buf.func_150789_c(stringSize);
        boolean hasMission = buf.readBoolean();
        if (hasMission) {
            ResourceLocation key = buf.func_192575_l();
            MiniMissionType mission = (MiniMissionType)MissionRegistry.MISSION_REGISTRY.get().getValue(key);
            if (mission != null) {
                return new DistressSignal(message, coord, mission);
            }
        }
        return new DistressSignal(message, coord);
    }
}

