/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.tileentities.console.misc;

import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.TranslationTextComponent;
import net.tardis.mod.tileentities.ConsoleTile;

public class ArtronUse {
    private IArtronType type;
    private float usePerTick = 0.0f;
    private int ticksToDrain = 0;

    protected ArtronUse() {
    }

    public ArtronUse(IArtronType type) {
        this.type = type;
        this.usePerTick = type.getUse();
    }

    public void setArtronUsePerTick(float usePerTick) {
        this.usePerTick = usePerTick;
    }

    public float getArtronUsePerTick() {
        return this.usePerTick;
    }

    public boolean isActive() {
        return this.ticksToDrain > -1;
    }

    public void setTicksToDrain(int time) {
        this.ticksToDrain = time;
    }

    public void tick(ConsoleTile tile) {
        if (this.ticksToDrain >= 0) {
            if (this.ticksToDrain > 0) {
                tile.setArtron(tile.getArtron() - this.getArtronUsePerTick());
            }
            --this.ticksToDrain;
        }
    }

    public IArtronType getType() {
        return this.type;
    }

    public CompoundNBT serialiseNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("id", this.type.getId());
        nbt.func_74776_a("use_per_tick", this.usePerTick);
        nbt.func_74768_a("ticks", this.ticksToDrain);
        return nbt;
    }

    public static ArtronUse deserialiseNBT(CompoundNBT nbt) {
        ArtronType type = ArtronType.valueOf(nbt.func_74779_i("id").toUpperCase());
        float artronPerTick = nbt.func_74760_g("use_per_tick");
        int ticks = nbt.func_74762_e("ticks");
        if (type == null) {
            type = ArtronType.DUMMY;
        }
        ArtronUse use = new ArtronUse(type);
        use.setArtronUsePerTick(artronPerTick);
        use.setTicksToDrain(ticks);
        return use;
    }

    public static enum ArtronType implements IArtronType
    {
        FLIGHT(0.0f, "flight"),
        FORCEFIELD(1.0f, "forcefield"),
        CONVERTER(1.0f, "converter"),
        ANTIGRAVS(1.0f, "antigravs"),
        INTERIOR_CHANGE(1.0f, "interior_change"),
        DUMMY(1.0f, "dummy");

        float use;
        TranslationTextComponent trans;
        String id;

        private ArtronType(float use, String name) {
            this.use = use;
            this.trans = new TranslationTextComponent("artronuse.tardis." + name);
            this.id = name;
        }

        @Override
        public float getUse() {
            return this.use;
        }

        @Override
        public TranslationTextComponent getTranslation() {
            return this.trans;
        }

        @Override
        public String getId() {
            return this.id;
        }
    }

    public static interface IArtronType {
        public float getUse();

        public TranslationTextComponent getTranslation();

        public String getId();
    }
}

