/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.tileentities;

import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.ItemStackHandler;
import net.tardis.mod.misc.SpaceTimeCoord;
import net.tardis.mod.network.Network;
import net.tardis.mod.tileentities.MultiblockMasterTile;
import net.tardis.mod.tileentities.TTiles;

public class WaypointBankTile
extends MultiblockMasterTile {
    private NonNullList<SpaceTimeCoord> waypoints = NonNullList.func_191197_a((int)5, (Object)SpaceTimeCoord.UNIVERAL_CENTER);
    private ItemStackHandler itemHandler = new ItemStackHandler(1);

    public WaypointBankTile(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public WaypointBankTile() {
        super((TileEntityType)TTiles.WAYPOINT_BANK.get());
    }

    public void setWaypoint(int index, SpaceTimeCoord coord) {
        this.waypoints.set(index, (Object)coord.toImmutable());
        this.func_70296_d();
    }

    public boolean addWaypoint(SpaceTimeCoord coord) {
        for (int i = 0; i < this.waypoints.size(); ++i) {
            if (!((SpaceTimeCoord)this.waypoints.get(i)).equals(SpaceTimeCoord.UNIVERAL_CENTER)) continue;
            this.setWaypoint(i, coord);
            this.update();
            return true;
        }
        return false;
    }

    public List<SpaceTimeCoord> getWaypoints() {
        return this.waypoints;
    }

    public SpaceTimeCoord getWaypoint(int index) {
        return (SpaceTimeCoord)this.waypoints.get(index);
    }

    public void clearWaypoints() {
        for (int i = 0; i < this.waypoints.size(); ++i) {
            this.waypoints.set(i, (Object)SpaceTimeCoord.UNIVERAL_CENTER);
        }
        this.func_70296_d();
        this.update();
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        if (compound.func_74764_b("waypoints")) {
            ListNBT list = compound.func_150295_c("waypoints", 10);
            int i = 0;
            for (INBT nbt : list) {
                this.waypoints.set(i, (Object)SpaceTimeCoord.deserialize((CompoundNBT)nbt));
                ++i;
            }
        }
        this.itemHandler.deserializeNBT(compound.func_74775_l("inventory"));
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        ListNBT list = new ListNBT();
        for (SpaceTimeCoord coord : this.waypoints) {
            list.add((Object)coord.serialize());
        }
        compound.func_218657_a("waypoints", (INBT)list);
        compound.func_218657_a("inventory", (INBT)this.itemHandler.serializeNBT());
        return super.func_189515_b(compound);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.deserializeNBT(pkt.func_148857_g());
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return Network.createTEUpdatePacket(this);
    }

    public CompoundNBT func_189517_E_() {
        return this.serializeNBT();
    }

    public void deleteWaypoint(int index) {
        this.waypoints.set(index, (Object)SpaceTimeCoord.UNIVERAL_CENTER);
        this.func_70296_d();
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    public void update() {
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
        }
    }
}

