/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.tileentities;

import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.sounds.TSounds;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.tileentities.MultiblockMasterTile;
import net.tardis.mod.tileentities.TTiles;

public class ToyotaSpinnyTile
extends MultiblockMasterTile
implements ITickableTileEntity {
    public static final int TAKE_OFF_TIME = 120;
    private ConsoleTile tile;
    public float rotation = 0.0f;
    public float prevRotation = 0.0f;
    private AxisAlignedBB renderBox;

    public ToyotaSpinnyTile(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public ToyotaSpinnyTile() {
        super((TileEntityType)TTiles.TOYOTA_SPIN.get());
    }

    public void func_73660_a() {
        if (this.tile == null || this.tile.func_145837_r()) {
            TardisHelper.getConsoleInWorld(this.field_145850_b).ifPresent(con -> {
                this.tile = con;
            });
        }
        this.prevRotation = this.rotation;
        if (this.tile != null && this.tile.isInFlight()) {
            this.playFlightStartSound(this.tile);
            this.playFlyLoop(this.tile, 41);
            this.playLandSound(this.tile);
            this.rotation = (this.rotation + 1.0f) % 360.0f;
        }
        if (this.renderBox == null) {
            this.renderBox = new AxisAlignedBB(this.func_174877_v()).func_186662_g(5.0);
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return this.renderBox == null ? new AxisAlignedBB(this.func_174877_v()) : this.renderBox;
    }

    public void playFlightStartSound(ConsoleTile console) {
        if (!console.func_145831_w().field_72995_K && console.flightTicks == 2) {
            console.func_145831_w().func_184133_a(null, console.func_174877_v(), (SoundEvent)TSounds.ROTOR_START.get(), SoundCategory.BLOCKS, 0.175f, 1.0f);
        }
    }

    public void playFlyLoop(ConsoleTile console, int loopTime) {
        if (!console.func_145831_w().func_201670_d()) {
            boolean isPlayingLand;
            boolean isPlayingTakeoff;
            boolean bl = isPlayingTakeoff = console.flightTicks < 120;
            boolean bl2 = console.getLandTime() == 0 ? false : (isPlayingLand = console.getLandTime() - console.flightTicks < 120);
            if (console.flightTicks % loopTime == 0 && !isPlayingTakeoff && !isPlayingLand) {
                console.func_145831_w().func_184133_a(null, this.tile.func_174877_v(), (SoundEvent)TSounds.ROTOR_TICK.get(), SoundCategory.BLOCKS, 0.175f, 1.0f);
            }
        }
    }

    public void playLandSound(ConsoleTile console) {
        if (!console.func_145831_w().field_72995_K && console.getLandTime() > 0 && console.getLandTime() - console.flightTicks == 120) {
            console.func_145831_w().func_184133_a(null, this.tile.func_174877_v(), (SoundEvent)TSounds.ROTOR_END.get(), SoundCategory.BLOCKS, 0.175f, 1.0f);
        }
    }
}

