/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.tileentities;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.tardis.mod.schematics.Schematic;
import net.tardis.mod.schematics.Schematics;
import net.tardis.mod.tileentities.TTiles;

public class ShipComputerTile
extends TileEntity {
    private ResourceLocation schematic;
    private ItemStackHandler handler = new ItemStackHandler(27);
    private LazyOptional<ItemStackHandler> itemHolder = LazyOptional.of(() -> this.handler);
    private ResourceLocation lootTable;
    private boolean isBeingUsedByCrew = false;

    public ShipComputerTile() {
        super((TileEntityType)TTiles.SHIP_COMPUTER.get());
    }

    public Schematic getSchematic() {
        return this.schematic == null ? null : Schematics.SCHEMATIC_REGISTRY.get(this.schematic);
    }

    public void setSchematic(ResourceLocation loc) {
        this.schematic = loc;
        this.func_70296_d();
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.handler.deserializeNBT(compound.func_74775_l("inv"));
        if (compound.func_74764_b("schematic")) {
            this.schematic = new ResourceLocation(compound.func_74779_i("schematic"));
        }
        if (compound.func_74764_b("loot_table")) {
            this.lootTable = new ResourceLocation(compound.func_74779_i("loot_table"));
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        if (this.schematic != null) {
            compound.func_74778_a("schematic", this.schematic.toString());
        }
        compound.func_218657_a("inv", (INBT)this.handler.serializeNBT());
        if (this.lootTable != null) {
            compound.func_74778_a("loot_table", this.lootTable.toString());
        }
        return super.func_189515_b(compound);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), -1, this.func_189515_b(new CompoundNBT()));
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
    }

    public CompoundNBT func_189517_E_() {
        return this.serializeNBT();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        return cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this.itemHolder.cast() : super.getCapability(cap, side);
    }

    public void setLootTable(ResourceLocation lootTable) {
        this.lootTable = lootTable;
        this.func_70296_d();
    }

    public ResourceLocation getLootTable() {
        return this.lootTable;
    }

    public void fillWithLoot(PlayerEntity player) {
        if (!this.field_145850_b.field_72995_K && this.lootTable != null) {
            LootTable table = this.field_145850_b.func_73046_m().func_200249_aQ().func_186521_a(this.lootTable);
            if (table == LootTable.field_186464_a) {
                return;
            }
            List list = table.func_216113_a(new LootContext.Builder((ServerWorld)this.field_145850_b).func_216015_a(LootParameters.field_237457_g_, (Object)Vector3d.func_237489_a_((Vector3i)this.field_174879_c)).func_216015_a(LootParameters.field_216281_a, (Object)player).func_216022_a(LootParameterSets.field_216261_b));
            ArrayList usedSlots = Lists.newArrayList();
            for (ItemStack stack : list) {
                int newSlot = this.field_145850_b.field_73012_v.nextInt(this.handler.getSlots());
                for (int i = 0; i < 8 && usedSlots.contains(newSlot); ++i) {
                    newSlot = this.field_145850_b.field_73012_v.nextInt(this.handler.getSlots());
                }
                this.handler.insertItem(newSlot, stack, false);
                usedSlots.add(newSlot);
            }
            this.lootTable = null;
            this.func_70296_d();
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.itemHolder.invalidate();
    }

    public void setIsBeingUsed(boolean used) {
        this.isBeingUsedByCrew = used;
    }

    public boolean isBeingUsed() {
        return this.isBeingUsedByCrew;
    }
}

