/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.tileentities;

import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.network.Network;
import net.tardis.mod.tileentities.TTiles;

public class PlaqueTile
extends TileEntity {
    private String[] text = null;
    private String tardisName = "";

    public PlaqueTile(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public PlaqueTile() {
        this((TileEntityType)TTiles.PLAQUE.get());
    }

    public String[] getText() {
        if (this.text == null || this.text.length <= 0 && this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            this.text = new String[]{new TranslationTextComponent("text.tardis.plaque.line1").getString(), new TranslationTextComponent("text.tardis.plaque.line2").getString(), new TranslationTextComponent("text.tardis.plaque.line3").getString() + this.getTardisName()};
        }
        return this.text;
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.tardisName = pkt.func_148857_g().func_74779_i("tardis_name");
        this.text = null;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.func_230337_a_(state, tag);
        this.text = null;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return Network.createTEUpdatePacket(this);
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT tag = this.serializeNBT();
        return this.func_189515_b(tag);
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.tardisName = nbt.func_74779_i("tardis_name");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74778_a("tardis_name", this.getTardisName());
        return super.func_189515_b(compound);
    }

    public String getTardisName() {
        if ((this.tardisName.isEmpty() || this.tardisName == null) && this.field_145850_b != null && this.field_145850_b instanceof ServerWorld) {
            ServerWorld serverWorld = this.field_145850_b.func_73046_m().func_71218_a(this.field_145850_b.func_234923_W_());
            serverWorld.getCapability(Capabilities.TARDIS_DATA).ifPresent(data -> {
                this.tardisName = data.getTARDISName() != null ? data.getTARDISName() : "Empty Name";
            });
        }
        return this.tardisName;
    }
}

