/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.tileentities;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.concurrent.TickDelayedTask;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.tardis.mod.ars.ARSHelper;
import net.tardis.mod.blocks.TBlocks;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.tileentities.TTiles;

public class CorridorKillTile
extends TileEntity
implements ITickableTileEntity {
    private BlockPos start;
    private BlockPos end;
    private BlockPos restorePos;
    private Direction dir;
    private int ticksTillDeath = 0;

    public CorridorKillTile(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public CorridorKillTile() {
        super((TileEntityType)TTiles.CORRIDOR_KILL.get());
        this.dir = Direction.NORTH;
        this.start = new BlockPos(0, 0, 0);
        this.end = new BlockPos(0, 0, 0);
        this.restorePos = new BlockPos(0, 0, 0);
    }

    public void setStart(BlockPos pos) {
        this.start = pos;
        this.func_70296_d();
    }

    public void setEnd(BlockPos pos) {
        this.end = pos;
        this.func_70296_d();
    }

    public void setRestorePos(BlockPos pos, Direction dir) {
        this.restorePos = pos;
        this.dir = dir;
        this.func_70296_d();
    }

    private void deleteRoom() {
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_73046_m().func_212871_a_((Runnable)new TickDelayedTask(1, () -> {
                List<ItemStack> allInvs = ARSHelper.fillReclamationUnitAndRemove(this.field_145850_b, this.start, this.end, true);
                for (BlockPos pos : BlockPos.func_218278_a((BlockPos)this.start, (BlockPos)this.end)) {
                    this.field_145850_b.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                }
                for (int x = -1; x <= 1; ++x) {
                    for (int y = -1; y < 3; ++y) {
                        if (this.dir == Direction.SOUTH || this.dir == Direction.NORTH) {
                            this.field_145850_b.func_175656_a(this.restorePos.func_177982_a(x, y, 0), ((Block)TBlocks.tungsten.get()).func_176223_P());
                            continue;
                        }
                        this.field_145850_b.func_175656_a(this.restorePos.func_177982_a(0, y, x), ((Block)TBlocks.tungsten.get()).func_176223_P());
                    }
                }
                this.field_145850_b.func_175656_a(this.restorePos, ((Block)TBlocks.corridor_spawn.get()).func_176223_P());
                this.field_145850_b.func_184133_a(null, this.restorePos, SoundEvents.field_206940_M, SoundCategory.BLOCKS, 1.0f, 1.0f);
                ARSHelper.spawnReclamationUnit(this.field_145850_b, TardisHelper.TARDIS_POS.func_177970_e(2), allInvs);
                for (ServerPlayerEntity player : this.field_145850_b.func_217357_a(ServerPlayerEntity.class, new AxisAlignedBB(this.start, this.end))) {
                    player.field_71135_a.func_147364_a(0.0, 129.0, 2.0, player.field_70177_z, player.field_70125_A);
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("message.tardis.ars.room.deleted"), false);
                    player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187791_eX, SoundCategory.PLAYERS, 1.0f, 1.0f);
                }
            }));
        }
    }

    public void startDeletion(@Nullable PlayerEntity player) {
        int n = this.ticksTillDeath = player.field_71075_bZ.field_75098_d ? 80 : 220;
        if (player != null && !this.field_145850_b.field_72995_K) {
            player.getCapability(Capabilities.PLAYER_DATA).ifPresent(cap -> {
                cap.startCountdown(this.ticksTillDeath);
                cap.update();
            });
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.dir = Direction.values()[compound.func_74762_e("direction")];
        this.start = BlockPos.func_218283_e((long)compound.func_74763_f("start"));
        this.end = BlockPos.func_218283_e((long)compound.func_74763_f("end"));
        this.restorePos = BlockPos.func_218283_e((long)compound.func_74763_f("restore"));
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a("direction", this.dir.ordinal());
        compound.func_74772_a("start", this.start.func_218275_a());
        compound.func_74772_a("end", this.end.func_218275_a());
        compound.func_74772_a("restore", this.restorePos.func_218275_a());
        return super.func_189515_b(compound);
    }

    public void func_73660_a() {
        if (this.ticksTillDeath > 0) {
            --this.ticksTillDeath;
            if (this.ticksTillDeath == 0) {
                this.deleteRoom();
            }
            if (this.ticksTillDeath % 20 == 0) {
                this.field_145850_b.func_184133_a(null, this.func_174877_v(), SoundEvents.field_187734_u, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            if (!this.field_145850_b.field_72995_K) {
                for (PlayerEntity player : this.field_145850_b.func_217357_a(PlayerEntity.class, new AxisAlignedBB(this.start, this.end))) {
                    player.getCapability(Capabilities.PLAYER_DATA).ifPresent(cap -> {
                        cap.setShaking(5);
                        cap.update();
                    });
                }
            }
        }
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.deserializeNBT(state, tag);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.deserializeNBT(pkt.func_148857_g());
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), -1, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.serializeNBT();
    }
}

