/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.tileentities;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.concurrent.TickDelayedTask;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.tardis.api.events.TardisEvent;
import net.tardis.mod.Tardis;
import net.tardis.mod.ars.ConsoleRoom;
import net.tardis.mod.blocks.TBlocks;
import net.tardis.mod.blocks.exteriors.ExteriorBlock;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.client.ClientHelper;
import net.tardis.mod.config.TConfig;
import net.tardis.mod.constants.TardisConstants;
import net.tardis.mod.controls.AbstractControl;
import net.tardis.mod.controls.LandingTypeControl;
import net.tardis.mod.controls.RefuelerControl;
import net.tardis.mod.controls.ThrottleControl;
import net.tardis.mod.entity.ControlEntity;
import net.tardis.mod.entity.DoorEntity;
import net.tardis.mod.entity.TEntities;
import net.tardis.mod.entity.TardisEntity;
import net.tardis.mod.enums.EnumDoorState;
import net.tardis.mod.exterior.AbstractExterior;
import net.tardis.mod.flight.FlightEvent;
import net.tardis.mod.flight.FlightEventFactory;
import net.tardis.mod.flight.TardisCollideInstigate;
import net.tardis.mod.flight.TardisCollideRecieve;
import net.tardis.mod.helper.BlockPosHelper;
import net.tardis.mod.helper.Helper;
import net.tardis.mod.helper.LandingSystem;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.helper.TextHelper;
import net.tardis.mod.helper.WorldHelper;
import net.tardis.mod.items.ArtronCapacitorItem;
import net.tardis.mod.misc.CrashType;
import net.tardis.mod.misc.CrashTypes;
import net.tardis.mod.misc.ITickable;
import net.tardis.mod.misc.ObjectWrapper;
import net.tardis.mod.misc.SpaceTimeCoord;
import net.tardis.mod.misc.TexVariant;
import net.tardis.mod.missions.MiniMissionType;
import net.tardis.mod.network.Network;
import net.tardis.mod.network.packets.ConsoleUpdateMessage;
import net.tardis.mod.network.packets.MissControlMessage;
import net.tardis.mod.network.packets.console.ConsoleData;
import net.tardis.mod.network.packets.console.CrashData;
import net.tardis.mod.network.packets.console.DataTypes;
import net.tardis.mod.network.packets.console.Fuel;
import net.tardis.mod.network.packets.console.NavComData;
import net.tardis.mod.network.packets.exterior.DoorData;
import net.tardis.mod.registries.ControlRegistry;
import net.tardis.mod.registries.ExteriorRegistry;
import net.tardis.mod.registries.FlightEventRegistry;
import net.tardis.mod.registries.MissionRegistry;
import net.tardis.mod.registries.SoundSchemeRegistry;
import net.tardis.mod.registries.SubsystemRegistry;
import net.tardis.mod.registries.TardisStatistics;
import net.tardis.mod.registries.UpgradeRegistry;
import net.tardis.mod.sounds.AbstractSoundScheme;
import net.tardis.mod.sounds.TSounds;
import net.tardis.mod.subsystem.AntennaSubsystem;
import net.tardis.mod.subsystem.FluidLinksSubsystem;
import net.tardis.mod.subsystem.NavComSubsystem;
import net.tardis.mod.subsystem.ShieldGeneratorSubsystem;
import net.tardis.mod.subsystem.StabilizerSubsystem;
import net.tardis.mod.subsystem.Subsystem;
import net.tardis.mod.tags.TardisBlockTags;
import net.tardis.mod.tileentities.console.misc.AlarmType;
import net.tardis.mod.tileentities.console.misc.ArtronUse;
import net.tardis.mod.tileentities.console.misc.ControlOverride;
import net.tardis.mod.tileentities.console.misc.DistressSignal;
import net.tardis.mod.tileentities.console.misc.EmotionHandler;
import net.tardis.mod.tileentities.console.misc.ExteriorPropertyManager;
import net.tardis.mod.tileentities.console.misc.InteriorManager;
import net.tardis.mod.tileentities.console.misc.SparkingLevel;
import net.tardis.mod.tileentities.console.misc.UnlockManager;
import net.tardis.mod.tileentities.exteriors.ExteriorTile;
import net.tardis.mod.tileentities.inventory.PanelInventory;
import net.tardis.mod.traits.IAffectLandingTrait;
import net.tardis.mod.traits.TardisTrait;
import net.tardis.mod.upgrades.Upgrade;
import net.tardis.mod.world.dimensions.TDimensions;

public class ConsoleTile
extends TileEntity
implements ITickableTileEntity {
    private static final AxisAlignedBB CONRTROL_HITBOX = new AxisAlignedBB(-1.0, 0.0, -1.0, 2.0, 2.0, 2.0);
    public static final int TARDIS_MAX_SPEED = 10;
    public static final float BASIC_FUEL_USEAGE = 1.0f;
    public static Random rand = new Random();
    public int prevFlightTicks = 0;
    public int flightTicks = 0;
    private int reachDestinationTick = 0;
    private EmotionHandler emotionHandler;
    private InteriorManager interiorManager;
    private List<ITickable> tickers = new ArrayList<ITickable>();
    private HashMap<ResourceLocation, INBTSerializable<CompoundNBT>> dataHandlers = new HashMap();
    private ArrayList<ControlEntity> controls = new ArrayList();
    private ArrayList<ControlRegistry.ControlEntry> controlEntries = new ArrayList();
    private AbstractExterior exterior;
    private AbstractSoundScheme scheme;
    private BlockPos location = BlockPos.field_177992_a;
    private BlockPos destination = BlockPos.field_177992_a;
    private RegistryKey<World> dimension;
    private RegistryKey<World> destinationDimension;
    private Direction facing = Direction.NORTH;
    public int coordIncr = 10;
    private float max_artron = 0.0f;
    private float artron = 0.0f;
    private float rechargeMod = 1.0f;
    private ConsoleRoom consoleRoom = ConsoleRoom.STEAM;
    private List<Subsystem> subsystems = new ArrayList<Subsystem>();
    private List<Upgrade> upgrades = new ArrayList<Upgrade>();
    private String customName = "";
    private ExteriorPropertyManager exteriorProps;
    private SpaceTimeCoord returnLocation = SpaceTimeCoord.UNIVERAL_CENTER;
    private FlightEvent currentEvent = null;
    private List<DistressSignal> distressSignal = new ArrayList<DistressSignal>();
    private ItemStack sonic = ItemStack.field_190927_a;
    protected TexVariant[] variants = new TexVariant[0];
    private int variant = 0;
    private boolean antiGravs = false;
    private UUID tardisEntityID = null;
    private TardisEntity tardisEntity = null;
    private SparkingLevel sparkLevel = SparkingLevel.NONE;
    private String landingCode = "";
    private int landTime = 0;
    private HashMap<ArtronUse.IArtronType, ArtronUse> artronUses = Maps.newHashMap();
    private LazyOptional<ExteriorTile> exteriorHolder = LazyOptional.empty();
    private boolean isCrashing = false;
    private UnlockManager unlockManager;
    protected HashMap<Class<?>, ControlOverride> controlOverrides = Maps.newHashMap();
    private boolean hasPoweredDown = false;
    private boolean hasNavCom = false;
    private boolean isBeingTowed = false;
    private BlockPos takeoffLocation = BlockPos.field_177992_a;
    private boolean hasForcedChunksToRemove = false;
    private boolean shouldStartChangingInterior = false;
    private ConsoleRoom nextRoomToChange = ConsoleRoom.STEAM;
    private int timeUntilControlSpawn = 10;
    private PlayerEntity pilot;
    private Runnable onLoadAction;

    public ConsoleTile(TileEntityType<?> type) {
        super(type);
        this.emotionHandler = new EmotionHandler(this);
        this.interiorManager = new InteriorManager(this);
        this.exteriorProps = new ExteriorPropertyManager(this);
        this.exterior = (AbstractExterior)ExteriorRegistry.STEAMPUNK.get();
        this.dimension = World.field_234918_g_;
        this.destinationDimension = World.field_234918_g_;
        this.unlockManager = new UnlockManager(this);
        this.scheme = (AbstractSoundScheme)SoundSchemeRegistry.BASIC.get();
        this.registerControlEntry((ControlRegistry.ControlEntry)ControlRegistry.HANDBRAKE.get());
        this.registerControlEntry((ControlRegistry.ControlEntry)ControlRegistry.THROTTLE.get());
        this.registerControlEntry((ControlRegistry.ControlEntry)ControlRegistry.RANDOM.get());
        this.registerControlEntry((ControlRegistry.ControlEntry)ControlRegistry.DIMENSION.get());
        this.registerControlEntry((ControlRegistry.ControlEntry)ControlRegistry.FACING.get());
        this.registerControlEntry((ControlRegistry.ControlEntry)ControlRegistry.X.get());
        this.registerControlEntry((ControlRegistry.ControlEntry)ControlRegistry.Y.get());
        this.registerControlEntry((ControlRegistry.ControlEntry)ControlRegistry.Z.get());
        this.registerControlEntry((ControlRegistry.ControlEntry)ControlRegistry.INC_MOD.get());
        this.registerControlEntry((ControlRegistry.ControlEntry)ControlRegistry.LAND_TYPE.get());
        this.registerControlEntry((ControlRegistry.ControlEntry)ControlRegistry.REFUELER.get());
        this.registerControlEntry((ControlRegistry.ControlEntry)ControlRegistry.FAST_RETURN.get());
        this.registerControlEntry((ControlRegistry.ControlEntry)ControlRegistry.TELEPATHIC.get());
        this.registerControlEntry((ControlRegistry.ControlEntry)ControlRegistry.STABILIZERS.get());
        this.registerControlEntry((ControlRegistry.ControlEntry)ControlRegistry.SONIC_PORT.get());
        this.registerControlEntry((ControlRegistry.ControlEntry)ControlRegistry.COMMUNICATOR.get());
        this.registerControlEntry((ControlRegistry.ControlEntry)ControlRegistry.DOOR.get());
        for (ForgeRegistryEntry entry : SubsystemRegistry.SUBSYSTEM_REGISTRY.get().getValues()) {
            this.subsystems.add(entry.create(this));
        }
        for (ForgeRegistryEntry entry : UpgradeRegistry.UPGRADE_REGISTRY.get().getValues()) {
            this.upgrades.add(entry.create(this));
        }
        this.registerControlOverrides();
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        ConsoleRoom consoleRoom;
        ConsoleRoom consoleRoom2;
        super.func_230337_a_(state, compound);
        for (Map.Entry<ResourceLocation, INBTSerializable<CompoundNBT>> entry : this.dataHandlers.entrySet()) {
            entry.getValue().deserializeNBT((INBT)compound.func_74775_l(entry.getKey().toString()));
        }
        ListNBT subsystemList = compound.func_150295_c("subsystems", 10);
        for (Object base : subsystemList) {
            CompoundNBT nbt = (CompoundNBT)base;
            ResourceLocation key = new ResourceLocation(nbt.func_74779_i("name"));
            this.getSubsystem(key).ifPresent(sys -> sys.deserializeNBT(nbt));
        }
        if (compound.func_74764_b("unlock_manager")) {
            this.unlockManager.deserializeNBT(compound.func_74775_l("unlock_manager"));
        }
        this.location = BlockPos.func_218283_e((long)compound.func_74763_f("location"));
        this.destination = BlockPos.func_218283_e((long)compound.func_74763_f("destination"));
        this.dimension = WorldHelper.getWorldKeyFromRL(new ResourceLocation(compound.func_74779_i("dimension")));
        this.destinationDimension = WorldHelper.getWorldKeyFromRL(new ResourceLocation(compound.func_74779_i("dest_dim")));
        this.flightTicks = compound.func_74762_e("flight_ticks");
        this.reachDestinationTick = compound.func_74762_e("max_flight_ticks");
        this.exterior = ExteriorRegistry.getExterior(new ResourceLocation(compound.func_74779_i("exterior")));
        this.artron = compound.func_74760_g("artron");
        if (compound.func_74764_b("console_room") && (consoleRoom2 = ConsoleRoom.getRegistry().get(new ResourceLocation(compound.func_74779_i("console_room")))) != null) {
            this.consoleRoom = consoleRoom2;
        }
        if (compound.func_74764_b("next_console_room") && (consoleRoom = ConsoleRoom.getRegistry().get(new ResourceLocation(compound.func_74779_i("next_console_room")))) != null) {
            this.nextRoomToChange = consoleRoom;
        }
        this.customName = compound.func_74779_i("custom_name");
        this.returnLocation = SpaceTimeCoord.deserialize(compound.func_74775_l("return_pos"));
        this.facing = Direction.values()[compound.func_74762_e("facing")];
        this.sonic = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("sonic_item"));
        ListNBT listNBT = compound.func_150295_c("distress_list_initial", 10);
        this.distressSignal.clear();
        for (INBT dis : listNBT) {
            this.distressSignal.add(DistressSignal.deserializeNBT((CompoundNBT)dis));
        }
        this.max_artron = compound.func_74760_g("max_artron");
        this.rechargeMod = compound.func_74760_g("recharge_modifier");
        this.variant = compound.func_74762_e("texture_variant");
        this.antiGravs = compound.func_74767_n("anti_gravs");
        this.hasForcedChunksToRemove = compound.func_74767_n("has_forced_chunks");
        this.hasNavCom = compound.func_74767_n("nav_com");
        this.shouldStartChangingInterior = compound.func_74767_n("start_changing_interior");
        ListNBT artronUsesList = compound.func_150295_c("artron_uses", 10);
        for (INBT base : artronUsesList) {
            CompoundNBT nbt = (CompoundNBT)base;
            ArtronUse use = ArtronUse.deserialiseNBT(nbt);
            ArtronUse.IArtronType type = use.getType();
            if (type == null) continue;
            this.artronUses.put(type, use);
        }
        if (compound.func_74764_b("tardis_entity_id")) {
            this.tardisEntityID = compound.func_186857_a("tardis_entity_id");
        }
        this.sparkLevel = SparkingLevel.getFromIndex(compound.func_74762_e("spark_level"));
        this.landingCode = compound.func_74779_i("landing_code");
        this.landTime = compound.func_74762_e("landing_time");
        this.takeoffLocation = BlockPos.func_218283_e((long)compound.func_74763_f("takeoff_location"));
        if (compound.func_74764_b("sound_scheme")) {
            this.scheme = (AbstractSoundScheme)SoundSchemeRegistry.SOUND_SCHEME_REGISTRY.get().getValue(new ResourceLocation(compound.func_74779_i("sound_scheme")));
        }
        this.onLoadAction = () -> {
            for (Map.Entry<ResourceLocation, INBTSerializable<CompoundNBT>> saved : this.dataHandlers.entrySet()) {
                saved.getValue().deserializeNBT((INBT)compound.func_74775_l(saved.getKey().toString()));
            }
        };
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        for (Map.Entry<ResourceLocation, INBTSerializable<CompoundNBT>> entry : this.dataHandlers.entrySet()) {
            compound.func_218657_a(entry.getKey().toString(), entry.getValue().serializeNBT());
        }
        ListNBT subsystemList = new ListNBT();
        for (Subsystem subsystem : this.subsystems) {
            CompoundNBT nbt = subsystem.serializeNBT();
            nbt.func_74778_a("name", subsystem.getEntry().getRegistryName().toString());
            subsystemList.add((Object)nbt);
        }
        compound.func_218657_a("subsystems", (INBT)subsystemList);
        compound.func_218657_a("unlock_manager", (INBT)this.unlockManager.serializeNBT());
        compound.func_74772_a("location", this.location.func_218275_a());
        compound.func_74772_a("destination", this.destination.func_218275_a());
        compound.func_74768_a("flight_ticks", this.flightTicks);
        compound.func_74768_a("max_flight_ticks", this.reachDestinationTick);
        compound.func_74778_a("exterior", this.exterior.getRegistryName().toString());
        compound.func_74778_a("dimension", this.dimension.func_240901_a_().toString());
        compound.func_74778_a("dest_dim", this.destinationDimension.func_240901_a_().toString());
        compound.func_74776_a("artron", this.artron);
        compound.func_74778_a("console_room", this.consoleRoom.getRegistryName().toString());
        compound.func_74778_a("next_console_room", this.nextRoomToChange.getRegistryName().toString());
        compound.func_74778_a("custom_name", this.customName);
        compound.func_218657_a("return_pos", (INBT)this.returnLocation.serialize());
        compound.func_74768_a("facing", this.facing.ordinal());
        compound.func_74772_a("takeoff_location", this.takeoffLocation.func_218275_a());
        compound.func_218657_a("sonic_item", (INBT)this.sonic.serializeNBT());
        ListNBT listNBT = new ListNBT();
        for (DistressSignal dis : this.distressSignal) {
            listNBT.add((Object)dis.serializeNBT());
        }
        compound.func_218657_a("distress_list_initial", (INBT)listNBT);
        compound.func_74776_a("max_artron", this.max_artron);
        compound.func_74776_a("recharge_modifier", this.rechargeMod);
        compound.func_74768_a("texture_variant", this.variant);
        compound.func_74757_a("anti_gravs", this.antiGravs);
        if (this.tardisEntityID != null) {
            compound.func_186854_a("tardis_entity_id", this.tardisEntityID);
        }
        compound.func_74768_a("spark_level", this.sparkLevel.ordinal());
        compound.func_74778_a("landing_code", this.landingCode);
        compound.func_74768_a("landing_time", this.landTime);
        compound.func_74778_a("sound_scheme", this.scheme.getRegistryName().toString());
        compound.func_74757_a("nav_com", this.hasNavCom);
        compound.func_74757_a("has_forced_chunks", this.hasForcedChunksToRemove);
        compound.func_74757_a("start_changing_interior", this.shouldStartChangingInterior);
        ListNBT listNBT2 = new ListNBT();
        for (Map.Entry<ArtronUse.IArtronType, ArtronUse> entry : this.artronUses.entrySet()) {
            CompoundNBT nbt = entry.getValue().serialiseNBT();
            listNBT2.add((Object)nbt);
        }
        compound.func_218657_a("artron_uses", (INBT)listNBT2);
        return super.func_189515_b(compound);
    }

    public void func_73660_a() {
        for (ITickable iTickable : this.tickers) {
            iTickable.tick(this);
        }
        this.prevFlightTicks = this.flightTicks;
        if (this.isInFlight()) {
            this.fly();
        }
        this.playAmbientNoises();
        this.handleRefueling();
        if (this.field_145850_b.func_82737_E() % 200L == 0L && (this.field_145850_b.field_72995_K || this.controls.isEmpty())) {
            this.getOrCreateControls();
        }
        if (this.timeUntilControlSpawn > 0) {
            --this.timeUntilControlSpawn;
            if (this.timeUntilControlSpawn == 0) {
                this.getOrCreateControls();
                if (this.onLoadAction != null) {
                    this.onLoadAction.run();
                }
            }
        }
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 40L == 0L) {
            this.updateArtronValues();
            SparkingLevel spark = SparkingLevel.NONE;
            for (Subsystem s : this.subsystems) {
                if (s.getSparkState().ordinal() <= spark.ordinal()) continue;
                spark = s.getSparkState();
            }
            if (this.sparkLevel != spark) {
                this.sparkLevel = spark;
                this.updateClient();
            }
            this.getSubsystem(ShieldGeneratorSubsystem.class).ifPresent(shield -> {
                if (shield.canBeUsed() && shield.isActivated() && shield.isForceFieldActivated() && this.artron > 1.0f) {
                    ArtronUse use = this.getOrCreateArtronUse(ArtronUse.ArtronType.FORCEFIELD);
                    use.setArtronUsePerTick(0.05f);
                    use.setTicksToDrain(42);
                    shield.damage((ServerPlayerEntity)this.getPilot(), 1);
                } else {
                    shield.setForceFieldActivated(false);
                }
            });
            if (this.getAntiGrav()) {
                ArtronUse artronUse = this.getOrCreateArtronUse(ArtronUse.ArtronType.ANTIGRAVS);
                artronUse.setArtronUsePerTick(0.03f);
                artronUse.setTicksToDrain(42);
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_73046_m().func_212871_a_((Runnable)new TickDelayedTask(0, () -> {
                float oldArtron = this.artron;
                for (ArtronUse use : this.artronUses.values()) {
                    use.tick(this);
                }
                if (oldArtron != this.artron && this.field_145850_b.func_82737_E() + 4L == 0L) {
                    if ((double)this.artron <= 0.0 && !this.hasPoweredDown) {
                        this.onPowerDown(true);
                    } else if (this.artron > 0.0f) {
                        this.hasPoweredDown = false;
                    }
                }
            }));
        }
        if (this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 5L == 0L && this.sparkLevel != SparkingLevel.NONE) {
            if (this.sparkLevel != SparkingLevel.NONE) {
                for (int i = 0; i < 30; ++i) {
                    float f = (float)Math.toRadians(rand.nextFloat() * 360.0f);
                    this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)this.field_174879_c.func_177958_n() + 0.5 + Math.sin(f), (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p() + 0.5 + Math.cos(f), 0.0, 0.0, 0.0);
                }
            }
            if (this.sparkLevel == SparkingLevel.SPARKS) {
                this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197595_F, (double)this.field_174879_c.func_177958_n() + 0.5, (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p() + 0.5, 0.0, 1.0, 0.0);
            }
        }
        if (!this.field_145850_b.field_72995_K && !this.isInFlight()) {
            this.getSubsystem(AntennaSubsystem.class).ifPresent(sys -> {
                if (sys.canBeUsed() && this.field_145850_b.func_82737_E() % 2880L == 0L) {
                    this.findNewMission();
                }
            });
        }
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 20L == 0L) {
            this.getSubsystem(NavComSubsystem.class).ifPresent(sys -> {
                boolean oldVal = this.hasNavCom;
                this.hasNavCom = sys.canBeUsed();
                if (oldVal != this.hasNavCom) {
                    Network.sendToAllInWorld(new ConsoleUpdateMessage(DataTypes.NAV_COM, new NavComData(this.hasNavCom)), (ServerWorld)this.field_145850_b);
                }
            });
        }
        this.handleAutoLoadOrUnloadChunks();
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.func_230337_a_(this.field_145850_b.func_180495_p(this.func_174877_v()), pkt.func_148857_g());
        this.currentEvent = pkt.func_148857_g().func_74764_b("current_event") ? ((FlightEventFactory)FlightEventRegistry.FLIGHT_EVENT_REGISTRY.get().getValue(new ResourceLocation(pkt.func_148857_g().func_74779_i("current_event")))).create(this) : null;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 99, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT tag = this.func_189515_b(new CompoundNBT());
        if (this.currentEvent != null && !this.currentEvent.isComplete()) {
            tag.func_74778_a("current_event", this.currentEvent.getEntry().getRegistryName().toString());
        } else {
            tag.func_82580_o("current_event");
        }
        return tag;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.func_230337_a_(state, tag);
    }

    public void onLoad() {
        super.onLoad();
        this.timeUntilControlSpawn = 10;
    }

    public void onInitialSpawn() {
        this.getEmotionHandler().onInitialSpawn();
    }

    public void updateClient() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        BlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        this.field_145850_b.markAndNotifyBlock(this.func_174877_v(), this.field_145850_b.func_175726_f(this.func_174877_v()), state, state, 2, 512);
    }

    public void registerTicker(ITickable ticker) {
        this.tickers.add(ticker);
    }

    public void registerDataHandler(ResourceLocation loc, INBTSerializable<CompoundNBT> handler) {
        this.dataHandlers.put(loc, handler);
    }

    public void registerControlEntry(ControlRegistry.ControlEntry entry) {
        this.controlEntries.add(entry);
    }

    public void getOrCreateControls() {
        this.gatherOldControls();
        if (!this.field_145850_b.field_72995_K && this.controls.size() < this.controlEntries.size()) {
            this.removeControls();
            for (ControlRegistry.ControlEntry controlEntry : this.controlEntries) {
                ControlEntity entity = (ControlEntity)((EntityType)TEntities.CONTROL.get()).func_200721_a(this.field_145850_b);
                AbstractControl control = controlEntry.spawn(this, entity);
                Vector3d offset = null;
                offset = this.controlOverrides.containsKey(control.getClass()) ? this.controlOverrides.get(control.getClass()).getPosition() : control.getPos();
                entity.func_70107_b((double)this.func_174877_v().func_177958_n() + 0.5 + offset.field_72450_a, (double)this.func_174877_v().func_177956_o() + 0.5 + offset.field_72448_b, (double)this.func_174877_v().func_177952_p() + 0.5 + offset.field_72449_c);
                entity.setControl(control);
                entity.setConsole(this);
                ((ServerWorld)this.field_145850_b).func_217440_f((Entity)entity);
                this.controls.add(entity);
            }
        }
        this.updateClient();
    }

    private void gatherOldControls() {
        this.controls.clear();
        for (ControlEntity control : this.field_145850_b.func_217357_a(ControlEntity.class, CONRTROL_HITBOX.func_186670_a(this.func_174877_v()).func_186662_g(2.0))) {
            if (!control.func_70089_S()) continue;
            control.setConsole(this);
            this.controls.add(control);
        }
    }

    public void removeControls() {
        for (ControlEntity control : this.field_145850_b.func_217357_a(ControlEntity.class, CONRTROL_HITBOX.func_186670_a(this.func_174877_v()).func_186662_g(5.0))) {
            control.func_70106_y();
        }
        this.controls.clear();
    }

    public HashMap<Class<?>, ControlOverride> getControlOverrides() {
        return this.controlOverrides;
    }

    public void registerControlOverrides() {
    }

    public void addControlOverride(Class<?> controlClazz, ControlOverride override) {
        this.controlOverrides.put(controlClazz, override);
    }

    public boolean takeoff() {
        return this.takeoff(false);
    }

    public boolean takeoff(boolean towed) {
        if (this.isInFlight() || this.field_145850_b.field_72995_K) {
            return false;
        }
        if (!this.canFly() && !towed) {
            this.field_145850_b.func_184133_a(null, this.func_174877_v(), (SoundEvent)TSounds.CANT_START.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
            return false;
        }
        this.forceLoadInteriorChunk(true, false);
        this.isCrashing = false;
        this.isBeingTowed = towed;
        this.takeoffLocation = this.location;
        if (this.getEntity() != null) {
            this.getEntity().func_70106_y();
        }
        this.currentEvent = null;
        this.returnLocation = new SpaceTimeCoord(this.getCurrentDimension(), this.getCurrentLocation(), this.getTrueExteriorFacingDirection());
        this.getEmotionHandler().addMood(10.0);
        this.getEmotionHandler().addLoyalty(this.getPilot(), 1);
        ServerWorld otherWorld = this.field_145850_b.func_73046_m().func_71218_a(this.dimension);
        BlockPos extPos = this.location.func_177984_a();
        ChunkPos chunkPos = new ChunkPos(extPos);
        WorldHelper.forceChunkIfNotLoaded(otherWorld, chunkPos, extPos);
        this.field_145850_b.func_73046_m().func_212871_a_((Runnable)new TickDelayedTask(1, () -> {
            this.landTime = 0;
            this.reachDestinationTick = this.calcFlightTicks(false) + this.getSoundScheme().getTakeoffTime();
            this.flightTicks = 1;
            this.exterior.demat(this);
            this.scheme.playTakeoffSounds(this);
            this.getControl(RefuelerControl.class).ifPresent(refuel -> refuel.setRefueling(false));
            MinecraftForge.EVENT_BUS.post((Event)new TardisEvent.Takeoff(this));
            WorldHelper.unForceChunkIfLoaded(otherWorld, chunkPos, this.location);
        }));
        this.updateClient();
        if (!this.isBeingTowed) {
            for (Subsystem sub : this.getSubSystems()) {
                sub.onTakeoff();
            }
            for (Upgrade up : this.getUpgrades()) {
                up.onTakeoff();
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            for (PlayerEntity player : this.field_145850_b.func_217369_A()) {
                player.getCapability(Capabilities.PLAYER_DATA).ifPresent(cap -> {
                    cap.setShaking(this.getSoundScheme().getTakeoffTime());
                    cap.update();
                });
            }
        }
        return true;
    }

    public boolean takeoffTowed() {
        boolean takeoff = this.takeoff(true);
        return takeoff;
    }

    public void initLand() {
        this.scaleDestination();
        this.land();
        this.updateClient();
    }

    public void land() {
        if (!this.field_145850_b.field_72995_K) {
            ServerWorld destWorld = this.field_145850_b.func_73046_m().func_71218_a(this.destinationDimension);
            BlockPos likelyLandingPos = this.destination.func_177984_a();
            ChunkPos likelyLandingChunkPos = new ChunkPos(likelyLandingPos);
            WorldHelper.forceChunkIfNotLoaded(destWorld, likelyLandingChunkPos, likelyLandingPos);
            this.landTime = this.prevFlightTicks = this.flightTicks + this.getSoundScheme().getLandTime();
            this.field_145850_b.func_73046_m().func_212871_a_((Runnable)new TickDelayedTask(1, () -> {
                SpaceTimeCoord interference;
                ServerWorld ws = destWorld;
                this.dimension = this.destinationDimension;
                this.playLandSound();
                this.currentEvent = null;
                if (this.getEmotionHandler() != null && this.getEmotionHandler().getMood() < (double)EmotionHandler.EnumHappyState.APATHETIC.getTreshold()) {
                    this.destination = this.randomizeCoords(this.destination, 100);
                }
                this.destination = LandingSystem.validateBlockPos(this.destination, (World)ws, this, this.exterior);
                this.destination = LandingSystem.redirectBehindBorder(ws, this.destination, this);
                ObjectWrapper<LandingTypeControl.EnumLandType> landTypeWrapper = new ObjectWrapper<LandingTypeControl.EnumLandType>(LandingTypeControl.EnumLandType.DOWN);
                this.getControl(LandingTypeControl.class).ifPresent(landControl -> landTypeWrapper.setValue(landControl.getLandType()));
                LandingTypeControl.EnumLandType landType = landTypeWrapper.getValue();
                BlockPos landSpot = LandingSystem.getLand((World)ws, this.destination, landType, this);
                for (TardisTrait trait : this.getEmotionHandler().getTraits()) {
                    if (!(trait instanceof IAffectLandingTrait)) continue;
                    landSpot = ((IAffectLandingTrait)((Object)trait)).redirect((World)ws, landSpot);
                }
                SpaceTimeCoord otherTardisCoord = LandingSystem.handleTardisInTardis(ws, landSpot, this);
                if (otherTardisCoord == null) {
                    if (landSpot.equals((Object)BlockPos.field_177992_a) || ws.func_180495_p(landSpot.func_177977_b()).func_235714_a_(TardisBlockTags.BLOCKED)) {
                        for (int i = 0; i < 30 && (landSpot.equals((Object)BlockPos.field_177992_a) || ws.func_180495_p(landSpot.func_177977_b()).func_235714_a_(TardisBlockTags.BLOCKED) || !ws.isAreaLoaded(landSpot, 3)); ++i) {
                            landSpot = LandingSystem.getLand((World)ws, this.randomizeCoords(this.destination, 30), landType, this);
                        }
                    }
                } else {
                    this.destinationDimension = otherTardisCoord.getDim();
                    landSpot = otherTardisCoord.getPos();
                }
                if ((interference = LandingSystem.affectFromWorldBlocks(ws, landSpot, landType, this)) != null) {
                    landSpot = interference.getPos();
                    this.facing = interference.getFacing();
                }
                if (this.getEmotionHandler().getMood() < (double)EmotionHandler.EnumHappyState.DISCONTENT.getTreshold()) {
                    for (PlayerEntity occupant : this.func_145831_w().func_217369_A()) {
                        if (this.getEmotionHandler().getLoyalty(occupant.func_110124_au()) >= -10) continue;
                        landSpot = LandingSystem.tryToKill((World)ws, landSpot, this.facing, 30);
                        break;
                    }
                }
                if (landSpot.equals((Object)BlockPos.field_177992_a)) {
                    landSpot = this.destination;
                }
                Helper.addTardisDistanceTravelledStat(this.pilot, this.location, landSpot);
                this.location = this.destination = landSpot.func_185334_h();
                if (this.isCrashing && this.field_145850_b.func_73046_m().func_200252_aR().func_223586_b(GameRules.field_223599_b)) {
                    destWorld.func_217385_a(null, (double)landSpot.func_177958_n() + 0.5, (double)landSpot.func_177956_o(), (double)landSpot.func_177952_p() + 0.5, 3.0f, Explosion.Mode.BREAK);
                }
                this.exterior.remat(this);
                this.getSoundScheme().playExteriorLand(this);
                this.getControl(ThrottleControl.class).ifPresent(throttle -> throttle.setAmount(0.0f));
                this.updateClient();
                MinecraftForge.EVENT_BUS.post((Event)new TardisEvent.Land(this));
                BlockPos extPos = landSpot.func_177984_a();
                ChunkPos finalChunkPos = new ChunkPos(extPos);
                if (!likelyLandingChunkPos.equals((Object)finalChunkPos) || !likelyLandingPos.equals((Object)extPos)) {
                    WorldHelper.unForceChunkIfLoaded(destWorld, likelyLandingChunkPos, likelyLandingPos);
                }
            }));
            if (!this.isBeingTowed) {
                for (Subsystem sub : this.getSubSystems()) {
                    sub.onLand();
                }
                for (Upgrade up : this.getUpgrades()) {
                    up.onLand();
                }
            }
        }
    }

    public void crash(CrashType type) {
        if (this.field_145850_b.field_72995_K || this.isCrashing || this.isBeingTowed) {
            return;
        }
        Network.sendToAllInWorld(new ConsoleUpdateMessage(DataTypes.CRASH, new CrashData()), (ServerWorld)this.field_145850_b);
        this.field_145850_b.func_184133_a(null, this.func_174877_v(), SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 1.0f, 0.25f);
        this.isCrashing = true;
        this.getInteriorManager().soundAlarm(AlarmType.LOW);
        this.scaleDestination();
        this.destination = this.randomizeCoords(this.destination, type.getInaccuracy());
        this.land();
        this.field_145850_b.func_73046_m().func_212871_a_((Runnable)new TickDelayedTask(1, () -> {
            this.reachDestinationTick = 0;
            this.flightTicks = 0;
            this.landTime = 0;
        }));
        for (LivingEntity ent : this.field_145850_b.func_217357_a(LivingEntity.class, new AxisAlignedBB(this.func_174877_v()).func_186662_g(20.0))) {
            ent.func_213317_d(ent.func_213322_ci().func_72441_c(rand.nextDouble() - 0.5, rand.nextDouble(), rand.nextDouble() - 0.5));
            if (!(ent instanceof ServerPlayerEntity)) continue;
            Network.sendTo(new MissControlMessage(), (ServerPlayerEntity)ent);
        }
        if (type.shouldDoExteriorEffects()) {
            this.field_145850_b.func_73046_m().func_212871_a_((Runnable)new TickDelayedTask(20, () -> {
                if (!this.field_145850_b.field_72995_K) {
                    this.field_145850_b.func_73046_m().func_212871_a_((Runnable)new TickDelayedTask(1, () -> {
                        ExteriorTile ext = this.getExteriorType().getExteriorTile(this);
                        if (ext != null) {
                            ext.setCrashed(true);
                        }
                    }));
                }
            }));
        }
        Helper.addTardisStatistic(this.pilot, TardisStatistics.TARDIS_CRASH_COUNT);
    }

    public void playCrashEffects() {
        if (this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 40L == 0L) {
            this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197627_t, (double)this.func_174877_v().func_177958_n() + 0.5, (double)(this.func_174877_v().func_177956_o() + 1), (double)this.func_174877_v().func_177952_p(), 0.0, 0.0, 0.0);
        }
    }

    public void damage(float damage) {
        ArrayList activeSys = Lists.newArrayList();
        for (Subsystem sys : this.subsystems) {
            if (!sys.canBeUsed() || !sys.isActivated()) continue;
            activeSys.add(sys);
        }
        int dam = (int)Math.ceil(damage / (float)activeSys.size());
        for (Subsystem sub : activeSys) {
            sub.damage(null, dam);
        }
    }

    protected void handleRefueling() {
        if (!this.field_145850_b.field_72995_K && !this.isInFlight() && this.artron < this.max_artron) {
            this.getControl(RefuelerControl.class).ifPresent(refuel -> {
                if (refuel.isRefueling()) {
                    this.getSubsystem(FluidLinksSubsystem.class).ifPresent(link -> {
                        if (link.canBeUsed()) {
                            this.artron += 0.025f * this.rechargeMod;
                            if (this.artron > this.max_artron) {
                                this.artron = this.max_artron;
                            }
                            if (this.artron < 0.0f) {
                                this.artron = 0.0f;
                            }
                            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                                Network.sendToAllAround(new ConsoleUpdateMessage(DataTypes.FUEL, new Fuel(this.artron, this.max_artron)), (RegistryKey<World>)this.field_145850_b.func_234923_W_(), this.func_174877_v(), 20);
                            }
                        }
                    });
                }
            });
        }
    }

    public void fly() {
        if (this.isInFlight()) {
            this.prevFlightTicks = this.flightTicks++;
            if (this.isLanding()) {
                this.location = this.getPositionInFlight().getPos();
            }
            if (this.isCrashing) {
                this.playCrashEffects();
            }
            if (!this.field_145850_b.field_72995_K && this.flightTicks >= this.reachDestinationTick && this.landTime <= 0) {
                if (this.isBeingTowed) {
                    this.initLand();
                }
                this.getSubsystem(StabilizerSubsystem.class).ifPresent(sys -> {
                    if (sys.isControlActivated() && !this.isBeingTowed) {
                        this.initLand();
                    }
                });
            }
            if (!this.field_145850_b.field_72995_K && this.flightTicks > this.landTime && this.landTime > 0) {
                this.landTime = 0;
                this.reachDestinationTick = 0;
                this.flightTicks = 0;
                this.updateClient();
            }
            if (!this.field_145850_b.field_72995_K && !this.canFly()) {
                this.crash(CrashTypes.DEFAULT);
                return;
            }
            if (!this.field_145850_b.field_72995_K) {
                ArtronUse use = this.getOrCreateArtronUse(ArtronUse.ArtronType.FLIGHT);
                use.setArtronUsePerTick(this.calcFuelUse());
                use.setTicksToDrain(1);
                if (this.flightTicks % 20 == 0) {
                    for (Subsystem sub : this.getSubSystems()) {
                        sub.onFlightSecond();
                    }
                    for (Upgrade up : this.getUpgrades()) {
                        up.onFlightSecond();
                    }
                }
                if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                    Network.sendToAllAround(new ConsoleUpdateMessage(DataTypes.FUEL, new Fuel(this.artron, this.max_artron)), (RegistryKey<World>)this.field_145850_b.func_234923_W_(), this.func_174877_v(), 20);
                }
            }
            if (!this.field_145850_b.field_72995_K) {
                if (!this.isBeingTowed && this.currentEvent != null && this.currentEvent.getMissedTime() < this.flightTicks) {
                    this.currentEvent.onComplete(this);
                    this.currentEvent = null;
                    if (this.landTime <= 0) {
                        ObjectWrapper<Boolean> collided = new ObjectWrapper<Boolean>(false);
                        for (ServerWorld world : this.field_145850_b.func_73046_m().func_212370_w()) {
                            if (collided.getValue().booleanValue()) break;
                            TardisHelper.getConsoleInWorld((World)world).ifPresent(tile -> this.getSubsystem(StabilizerSubsystem.class).ifPresent(sys -> {
                                if (tile != this && tile.isInFlight() && !sys.isControlActivated() && tile.getLandTime() == 0 && !(tile.getFlightEvent() instanceof TardisCollideInstigate) && !(tile.getFlightEvent() instanceof TardisCollideRecieve) && tile.getPositionInFlight().getPos().func_218141_a((Vector3i)this.getPositionInFlight().getPos(), (double)((Integer)TConfig.SERVER.collisionRange.get()).intValue())) {
                                    this.setFlightEvent(((TardisCollideInstigate)((FlightEventFactory)FlightEventRegistry.COLLIDE_INSTIGATE.get()).create(this)).setOtherTARDIS((ConsoleTile)((Object)tile)));
                                    collided.setValue(true);
                                }
                            }));
                        }
                    }
                    if (this.canGiveNewEvent() && this.currentEvent == null) {
                        this.setFlightEvent(FlightEventRegistry.getRandomEvent(rand).create(this));
                    }
                } else if (this.currentEvent == null && this.canGiveNewEvent()) {
                    this.setFlightEvent(FlightEventRegistry.getRandomEvent(rand).create(this));
                }
            }
            if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 3L == 0L && this.currentEvent != null && !this.currentEvent.getControls().isEmpty()) {
                for (PlayerEntity player : this.field_145850_b.func_217369_A()) {
                    player.getCapability(Capabilities.PLAYER_DATA).ifPresent(cap -> {
                        cap.setShaking(5);
                        cap.update();
                    });
                }
            }
        }
        this.playFlightLoop();
        if (!this.field_145850_b.field_72995_K && this.sparkLevel != SparkingLevel.NONE && this.field_145850_b.func_82737_E() % 60L == 0L && this.getEmotionHandler().getMood() > (double)EmotionHandler.EnumHappyState.DISCONTENT.getTreshold()) {
            this.getEmotionHandler().addMood(-1.0);
        }
    }

    public boolean isInFlight() {
        return this.flightTicks > 0;
    }

    public boolean isLanding() {
        return this.isInFlight() && this.landTime > 0;
    }

    public boolean hasReachedDestination() {
        return this.flightTicks >= this.reachDestinationTick;
    }

    public int getTimeInFlight() {
        return this.flightTicks;
    }

    public int getLandTime() {
        return this.landTime;
    }

    public void setDestinationReachedTick(int max) {
        this.reachDestinationTick = max;
        if (!this.field_145850_b.field_72995_K) {
            this.updateClient();
        }
    }

    public void setDestination(RegistryKey<World> worldKey, BlockPos pos) {
        this.destination = pos.func_185334_h();
        this.destinationDimension = worldKey;
        this.func_70296_d();
        if (this.isInFlight()) {
            this.updateFlightTime();
        }
        this.updateClient();
    }

    public void setDestination(SpaceTimeCoord coord) {
        this.setDestination(coord.getDim(), coord.getPos());
    }

    public boolean isCrashing() {
        return this.isCrashing;
    }

    public void setCrashing(boolean crash) {
        this.isCrashing = crash;
    }

    public void setConsoleRoom(ConsoleRoom room) {
        this.consoleRoom = room;
        if (room == null) {
            throw new NullPointerException();
        }
        this.func_70296_d();
        this.updateClient();
    }

    public void playFlightLoop() {
        if (!this.field_145850_b.field_72995_K && this.flightTicks % this.scheme.getLoopTime() == 0 && this.flightTicks > this.scheme.getTakeoffTime() && this.landTime <= 0) {
            this.scheme.playFlightLoop(this);
        }
    }

    private void playLandSound() {
        if (!this.field_145850_b.field_72995_K) {
            this.scheme.playInteriorLand(this);
            this.scheme.playExteriorLand(this);
            for (PlayerEntity player : this.field_145850_b.func_217369_A()) {
                player.getCapability(Capabilities.PLAYER_DATA).ifPresent(cap -> {
                    cap.setShaking(this.getSoundScheme().getLandTime());
                    cap.update();
                });
            }
        }
    }

    private void playAmbientNoises() {
        if (this.field_145850_b.field_72995_K) {
            PlayerEntity player = ClientHelper.getClientPlayer();
            if (player.field_70173_aa % 2400 == 0) {
                ClientHelper.playMovingSound((Entity)player, (SoundEvent)TSounds.AMBIENT_CREAKS.get(), SoundCategory.AMBIENT, 0.5f, false);
            }
            if (this.consoleRoom == ConsoleRoom.NAUTILUS && player.field_70173_aa % 600 == 0) {
                ClientHelper.playMovingSound((Entity)player, SoundEvents.field_204410_e, SoundCategory.AMBIENT, 1.0f, false);
            }
            if (this.sparkLevel == SparkingLevel.SPARKS && this.field_145850_b.func_82737_E() % 60L == 0L) {
                this.field_145850_b.func_184133_a(ClientHelper.getClientPlayer(), this.func_174877_v(), (SoundEvent)TSounds.ELECTRIC_SPARK.get(), SoundCategory.BLOCKS, 0.3f, 1.0f);
            }
        }
    }

    public void playSoundAtExterior(SoundEvent sound, SoundCategory cat, float vol, float pitch) {
        ExteriorTile tile = this.exterior.getExteriorTile(this);
        if (tile != null) {
            tile.func_145831_w().func_184133_a(null, tile.func_174877_v(), sound, cat, vol, pitch);
        }
    }

    public AbstractExterior getExteriorType() {
        return this.exterior;
    }

    public void setExteriorType(AbstractExterior ext) {
        this.exterior = ext;
        this.func_70296_d();
        this.updateClient();
    }

    public <T extends AbstractControl> Optional<T> getControl(Class<T> clazz) {
        for (ControlEntity control : this.controls) {
            if (control.getControl() == null) {
                control.func_70106_y();
                continue;
            }
            if (control.getControl().getClass() != clazz) continue;
            return Optional.of(control.getControl());
        }
        return Optional.empty();
    }

    public ArrayList<ControlEntity> getControlList() {
        return this.controls;
    }

    public EmotionHandler getEmotionHandler() {
        return this.emotionHandler;
    }

    public InteriorManager getInteriorManager() {
        return this.interiorManager;
    }

    public ExteriorPropertyManager getExteriorManager() {
        return this.exteriorProps;
    }

    public UnlockManager getUnlockManager() {
        return this.unlockManager;
    }

    public LazyOptional<DoorEntity> getDoor() {
        if (this.field_145850_b instanceof ServerWorld) {
            Iterator it = ((ServerWorld)this.field_145850_b).getEntities().iterator();
            while (it.hasNext()) {
                Entity e = (Entity)it.next();
                if (!(e instanceof DoorEntity)) continue;
                return LazyOptional.of(() -> (DoorEntity)e);
            }
        } else {
            Iterator iterator = this.field_145850_b.func_217357_a(DoorEntity.class, new AxisAlignedBB(this.func_174877_v()).func_186662_g(30.0)).iterator();
            if (iterator.hasNext()) {
                DoorEntity ent = (DoorEntity)((Object)iterator.next());
                return LazyOptional.of(() -> ent);
            }
        }
        return LazyOptional.empty();
    }

    public LazyOptional<ExteriorTile> getOrFindExteriorTile() {
        if (this.exteriorHolder.isPresent()) {
            return this.exteriorHolder;
        }
        this.exteriorHolder.invalidate();
        ExteriorTile tile = this.getExteriorType().getExteriorTile(this);
        if (tile != null) {
            this.exteriorHolder = LazyOptional.of(() -> tile);
            return this.exteriorHolder;
        }
        this.exteriorHolder = LazyOptional.empty();
        return this.exteriorHolder;
    }

    public Direction getTrueExteriorFacingDirection() {
        BlockState state;
        ExteriorTile ext;
        ServerWorld other;
        if (!this.field_145850_b.field_72995_K && (other = this.field_145850_b.func_73046_m().func_71218_a(this.dimension)).isAreaLoaded(this.getCurrentLocation(), 1) && (ext = this.getExteriorType().getExteriorTile(this)) != null && (state = ext.func_195044_w()).func_235901_b_((Property)BlockStateProperties.field_208157_J)) {
            return (Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J);
        }
        return this.facing;
    }

    public ConsoleRoom getConsoleRoom() {
        return this.consoleRoom;
    }

    public int getReachDestinationTick() {
        return this.reachDestinationTick;
    }

    public BlockPos getCurrentLocation() {
        return this.location;
    }

    public BlockPos getDestinationPosition() {
        return this.destination;
    }

    public RegistryKey<World> getCurrentDimension() {
        return this.dimension;
    }

    public RegistryKey<World> getDestinationDimension() {
        return this.destinationDimension;
    }

    public Direction getExteriorFacingDirection() {
        return this.facing == Direction.DOWN || this.facing == Direction.UP ? (this.facing = Direction.NORTH) : this.facing;
    }

    public SpaceTimeCoord getPositionInFlight() {
        BlockPos diff = WorldHelper.scaleBlockPos(this.destination.func_177973_b((Vector3i)this.takeoffLocation), this.getPercentageJourney());
        return new SpaceTimeCoord(this.getPercentageJourney() < 0.5 ? this.dimension : this.destinationDimension, this.takeoffLocation.func_177971_a((Vector3i)diff), this.facing);
    }

    public boolean canFly() {
        if (this.isBeingTowed) {
            return true;
        }
        for (Subsystem s : this.subsystems) {
            if (!s.stopsFlight()) continue;
            return false;
        }
        if (this.shouldStartChangingInterior && this.interiorManager.isInteriorStillRegenerating()) {
            return false;
        }
        return this.artron > 0.0f;
    }

    public boolean canGiveNewEvent() {
        if (this.isBeingTowed) {
            return false;
        }
        StabilizerSubsystem sys = (StabilizerSubsystem)this.getSubsystem(StabilizerSubsystem.class).orElse(null);
        if (sys == null || sys.isControlActivated()) {
            return false;
        }
        return this.landTime <= 0 && this.flightTicks < this.reachDestinationTick;
    }

    public void setExteriorFacingDirection(Direction dir) {
        if (dir != Direction.DOWN && dir != Direction.UP) {
            this.facing = dir;
            this.func_70296_d();
            this.updateClient();
        }
    }

    public void setCurrentLocation(RegistryKey<World> worldKey, BlockPos location) {
        this.dimension = worldKey;
        this.location = location.func_185334_h();
        this.func_70296_d();
        this.updateClient();
    }

    public double getPercentageJourney() {
        return this.reachDestinationTick == 0 ? 0.0 : MathHelper.func_151237_a((double)((double)this.flightTicks / (double)this.reachDestinationTick), (double)0.0, (double)1.0);
    }

    public void setFlightTicks(int ticks) {
        this.flightTicks = ticks;
        this.updateClient();
    }

    public AbstractSoundScheme getSoundScheme() {
        return this.scheme;
    }

    public void setSonicItem(ItemStack sonic) {
        this.sonic = sonic;
        this.func_70296_d();
        this.updateClient();
    }

    public ItemStack getSonicItem() {
        return this.sonic;
    }

    public void setCoordIncr(int incr) {
        this.coordIncr = incr;
        this.func_70296_d();
        this.updateClient();
    }

    public int getCoordIncr() {
        return this.coordIncr;
    }

    public float getArtron() {
        return this.artron;
    }

    public float getMaxArtron() {
        return this.max_artron;
    }

    public void setArtron(float artron) {
        this.artron = artron < this.max_artron ? (artron > 0.0f ? artron : 0.0f) : this.max_artron;
        this.func_70296_d();
        this.updateClient();
    }

    public void setMaxArtron(float maxArtron) {
        this.max_artron = maxArtron;
    }

    public BlockPos randomizeCoords(BlockPos pos, int radius) {
        int x = -radius + rand.nextInt(radius * 2);
        int y = -radius + rand.nextInt(radius * 2);
        int z = -radius + rand.nextInt(radius * 2);
        return pos.func_177982_a(x, y < 0 ? 5 : y, z).func_185334_h();
    }

    public void scaleDestination() {
        double per;
        ExteriorTile ext;
        if (this.isInFlight() && this.landTime > 0 && (ext = this.exterior.getExteriorTile(this)) != null) {
            ext.demat(this.getSoundScheme().getTakeoffTime());
        }
        if ((per = this.getPercentageJourney()) < 0.0) {
            this.destination = this.getCurrentLocation();
        }
        if (per < 0.5) {
            this.destinationDimension = this.dimension;
        }
        BlockPos diff = this.destination.func_177973_b((Vector3i)this.getCurrentLocation());
        this.destination = this.getCurrentLocation().func_177971_a((Vector3i)new BlockPos((double)diff.func_177958_n() * per, (double)diff.func_177956_o() * per, (double)diff.func_177952_p() * per)).func_185334_h();
    }

    public Map<ArtronUse.IArtronType, ArtronUse> getArtronUses() {
        return this.artronUses;
    }

    public void setSoundScheme(AbstractSoundScheme scheme) {
        this.scheme = scheme;
    }

    public ArtronUse getOrCreateArtronUse(ArtronUse.IArtronType type) {
        if (this.artronUses.containsKey(type)) {
            return this.artronUses.get(type);
        }
        ArtronUse use = new ArtronUse(type);
        this.artronUses.put(type, use);
        return use;
    }

    public float calcFuelUse() {
        StabilizerSubsystem sys;
        float use = 1.0f;
        ThrottleControl throttle = this.getControl(ThrottleControl.class).orElse(null);
        if (throttle != null) {
            use *= throttle.getAmount() * 0.025f;
        }
        if ((sys = (StabilizerSubsystem)this.getSubsystem(StabilizerSubsystem.class).orElse(null)) != null) {
            use *= sys.isControlActivated() ? 1.0f : 0.5f;
        }
        return use;
    }

    public float calcSpeed() {
        ObjectWrapper<Float> throttle = new ObjectWrapper<Float>(Float.valueOf(0.0f));
        this.getControl(ThrottleControl.class).ifPresent(throt -> throttle.setValue(Float.valueOf(throt.getAmount())));
        return 10.0f * MathHelper.func_76131_a((float)throttle.getValue().floatValue(), (float)0.1f, (float)1.0f);
    }

    public void updateArtronValues() {
        this.field_145850_b.getCapability(Capabilities.TARDIS_DATA).ifPresent(cap -> {
            float newMax = 0.0f;
            float rate = 0.0f;
            int numCap = 0;
            PanelInventory inv = cap.getEngineInventoryForSide(Direction.WEST);
            for (int i = 0; i < inv.getSlots(); ++i) {
                ItemStack stack = inv.getStackInSlot(i);
                if (!(stack.func_77973_b() instanceof ArtronCapacitorItem)) continue;
                ArtronCapacitorItem item = (ArtronCapacitorItem)stack.func_77973_b();
                newMax += item.getMaxStorage();
                rate += item.getRechargeModifier();
                ++numCap;
            }
            this.max_artron = newMax;
            this.rechargeMod = rate / (float)numCap;
            if (this.artron > this.max_artron) {
                this.artron = this.max_artron;
            }
        });
    }

    public boolean areAdminFunctionsLocked() {
        for (UUID id : this.getEmotionHandler().getLoyaltyTrackingCrew()) {
            if (this.getEmotionHandler().getLoyalty(id) <= 50) continue;
            return true;
        }
        return false;
    }

    public boolean canDoAdminFunction(PlayerEntity entity) {
        if (!this.areAdminFunctionsLocked()) {
            return true;
        }
        return this.getEmotionHandler().getLoyalty(entity.func_110124_au()) > 50;
    }

    public int calcFlightTicks(boolean usePositionInFlight) {
        float dist = (float)Math.sqrt(this.destination.func_177951_i((Vector3i)this.location));
        float mod = this.calcSpeed();
        int time = (int)(dist / mod);
        if (this.destinationDimension != this.dimension) {
            time += 600;
        }
        int offset = 0;
        return time <= 0 ? offset : time + offset;
    }

    public void updateFlightTime() {
        this.reachDestinationTick = 0 + this.flightTicks + this.calcFlightTicks(true);
        this.landTime = 0;
        this.func_70296_d();
        this.updateClient();
    }

    public void setCustomName(String name) {
        this.customName = name;
        this.func_70296_d();
    }

    public String getCustomName() {
        return this.customName;
    }

    public void addDistressSignal(DistressSignal coord) {
        this.getSubsystem(AntennaSubsystem.class).ifPresent(sys -> {
            if (sys.canBeUsed()) {
                this.distressSignal.add(coord);
                this.func_70296_d();
                this.updateClient();
            }
        });
    }

    public SpaceTimeCoord getReturnLocation() {
        return this.returnLocation;
    }

    public FlightEvent getFlightEvent() {
        return this.currentEvent;
    }

    public void setFlightEvent(@Nullable FlightEvent event) {
        FlightEvent flightEvent = this.currentEvent = this.isBeingTowed ? (event = null) : event;
        if (!this.field_145850_b.field_72995_K) {
            if (event != null) {
                event.warnPlayers(this.field_145850_b, this.func_174877_v());
            }
            this.updateClient();
        }
        this.func_70296_d();
    }

    public List<DistressSignal> getDistressSignals() {
        return this.distressSignal;
    }

    public void setPilot(PlayerEntity player) {
        this.pilot = player;
    }

    public PlayerEntity getPilot() {
        return this.pilot;
    }

    public TexVariant[] getTextureVariants() {
        return this.variants;
    }

    @Nullable
    public TexVariant getVariant() {
        if (this.variant < this.variants.length) {
            return this.variants[this.variant];
        }
        return null;
    }

    public void setVariant(int index) {
        if (index < this.variants.length) {
            this.variant = index;
        }
        this.func_70296_d();
    }

    private void findNewMission() {
        ServerWorld otherWorld;
        if (!this.field_145850_b.field_72995_K && (otherWorld = this.field_145850_b.func_73046_m().func_71218_a(this.dimension)).getCapability(Capabilities.MISSION).isPresent()) {
            this.startMission(MissionRegistry.getRandomMissionType(this.field_145850_b.field_73012_v));
        }
    }

    public void startMission(MiniMissionType type) {
        if (!this.field_145850_b.func_201670_d() && type != null) {
            int searchRadiusBlocks = 48;
            int searchRadiusChunks = (int)((double)searchRadiusBlocks / 16.0);
            ServerWorld sWorld = this.field_145850_b.func_73046_m().func_71218_a(this.dimension);
            Structure missionStructure = ((StructureFeature)sWorld.func_73046_m().func_244267_aX().func_243612_b((RegistryKey)Registry.field_243553_av).func_243576_d(type.getStructureKey())).field_236268_b_;
            BlockPos mission = type.spawnAndFindNearestMission(sWorld, sWorld.func_241112_a_(), this.getCurrentLocation(), searchRadiusChunks, false, sWorld.func_72905_C(), sWorld.func_72863_F().func_201711_g().func_235957_b_().func_236197_a_(missionStructure));
            if (mission != null) {
                BlockPos landSpot;
                List<BlockPos> possibleLandSpots = BlockPosHelper.getFilteredBlockPositionsInStructure(mission, sWorld, sWorld.func_241112_a_(), missionStructure, (Block)TBlocks.landing_pad.get());
                if (!possibleLandSpots.isEmpty()) {
                    int index = sWorld.field_73012_v.nextInt(possibleLandSpots.size());
                    landSpot = possibleLandSpots.get(index);
                } else {
                    landSpot = mission;
                }
                sWorld.getCapability(Capabilities.MISSION).ifPresent(mCap -> {
                    boolean isNewMission = false;
                    BlockPos possibleMission = landSpot;
                    if (possibleMission.func_177956_o() == 0) {
                        possibleMission = LandingSystem.getLandSpotUp((World)sWorld, mission, this.exterior, this);
                    }
                    if (mCap.getMissionForPos(possibleMission) != null) {
                        if (!mCap.getMissionForPos(possibleMission).isMissionComplete()) {
                            isNewMission = true;
                        }
                    } else {
                        isNewMission = true;
                    }
                    if (isNewMission && !possibleMission.equals((Object)BlockPos.field_177992_a)) {
                        this.addDistressSignal(new DistressSignal(new TranslationTextComponent("mission.tardis.generic_distress_message").getString(), new SpaceTimeCoord(this.dimension, possibleMission), type));
                    }
                });
            }
        }
    }

    public List<Subsystem> getSubSystems() {
        return this.subsystems;
    }

    public List<Upgrade> getUpgrades() {
        return this.upgrades;
    }

    public Optional<Subsystem> getSubsystem(ResourceLocation key) {
        for (Subsystem s : this.getSubSystems()) {
            if (!s.getEntry().getRegistryName().equals((Object)key)) continue;
            return Optional.of(s);
        }
        return Optional.empty();
    }

    public <T extends Subsystem> LazyOptional<T> getSubsystem(Class<T> clazz) {
        for (Subsystem sys : this.getSubSystems()) {
            if (sys.getClass() != clazz) continue;
            return LazyOptional.of(() -> sys);
        }
        return LazyOptional.empty();
    }

    public <T extends Upgrade> LazyOptional<T> getUpgrade(Class<T> clazz) {
        for (Upgrade upgrade : this.upgrades) {
            if (upgrade.getClass() != clazz) continue;
            return LazyOptional.of(() -> upgrade);
        }
        return LazyOptional.empty();
    }

    public Optional<Upgrade> getUpgrade(ResourceLocation loc) {
        for (Upgrade upgrade : this.upgrades) {
            if (!upgrade.getEntry().getRegistryName().equals((Object)loc)) continue;
            return Optional.of(upgrade);
        }
        return Optional.empty();
    }

    public void setLandingCode(String code) {
        this.landingCode = code;
        this.func_70296_d();
    }

    public String getLandingCode() {
        return this.landingCode;
    }

    public boolean getAntiGrav() {
        return this.antiGravs;
    }

    public void setAntiGrav(boolean enabled) {
        this.antiGravs = enabled;
        if (!this.field_145850_b.field_72995_K) {
            TardisEntity ent;
            ExteriorTile tile = this.getExteriorType().getExteriorTile(this);
            if (tile != null) {
                tile.setAntiGravs(enabled);
            }
            if ((ent = this.getEntity()) != null) {
                ent.func_70106_y();
            }
        }
        this.func_70296_d();
    }

    @Nullable
    public TardisEntity getEntity() {
        if (this.tardisEntityID == null) {
            return this.tardisEntity;
        }
        if (this.tardisEntity != null && !this.tardisEntity.func_70089_S()) {
            return this.tardisEntity;
        }
        if (!this.field_145850_b.field_72995_K) {
            ServerWorld sw = this.field_145850_b.func_73046_m().func_71218_a(this.getCurrentDimension());
            this.tardisEntity = (TardisEntity)sw.func_217461_a(this.tardisEntityID);
            return this.tardisEntity;
        }
        return null;
    }

    public void setEntity(@Nullable TardisEntity ent) {
        this.tardisEntity = ent;
        this.tardisEntityID = ent != null ? ent.func_110124_au() : null;
    }

    public void onPowerDown(boolean shutDown) {
        this.hasPoweredDown = shutDown;
        if (!this.field_145850_b.field_72995_K) {
            this.getInteriorManager().setLight(shutDown ? 0 : 15);
            if (shutDown) {
                this.field_145850_b.func_184133_a(null, this.func_174877_v(), (SoundEvent)TSounds.POWER_DOWN.get(), SoundCategory.BLOCKS, 20.0f, 1.0f);
            }
        }
    }

    public boolean hasNavCom() {
        return this.hasNavCom;
    }

    public void setNavCom(boolean hasCom) {
        this.hasNavCom = hasCom;
        this.func_70296_d();
    }

    public boolean isBeingTowed() {
        return this.isBeingTowed;
    }

    public boolean doesConsoleWorldHaveNoPlayers() {
        if (this.field_145850_b.field_72995_K) {
            return false;
        }
        return this.field_145850_b.func_217369_A().isEmpty();
    }

    public boolean shouldStartChangingInterior() {
        return this.shouldStartChangingInterior;
    }

    public void setStartChangingInterior(boolean startChangingInterior) {
        this.shouldStartChangingInterior = startChangingInterior;
        this.func_70296_d();
        this.updateClient();
    }

    public boolean canStartToChangeInterior() {
        return this.shouldStartChangingInterior && this.doesConsoleWorldHaveNoPlayers();
    }

    public ConsoleRoom getNextConsoleRoom() {
        return this.nextRoomToChange;
    }

    public void setNextConsoleRoomToChange(ConsoleRoom room) {
        this.nextRoomToChange = room;
        this.func_70296_d();
        this.updateClient();
    }

    public void setupInteriorChangeProperties(ConsoleRoom roomToSpawn, boolean cancelProcess, boolean isInstantChange) {
        int processingTicks = (Integer)TConfig.SERVER.interiorChangeProcessTime.get() * 20;
        this.getInteriorManager().setInteriorProcessingTime(cancelProcess ? 0 : (isInstantChange ? 60 : processingTicks));
        this.setNextConsoleRoomToChange(cancelProcess ? this.consoleRoom : roomToSpawn);
        this.setStartChangingInterior(!cancelProcess);
        this.onPowerDown(!cancelProcess);
        if (cancelProcess) {
            ArtronUse use = this.getOrCreateArtronUse(ArtronUse.ArtronType.INTERIOR_CHANGE);
            use.setArtronUsePerTick(0.0f);
            use.setTicksToDrain(0);
            this.getDoor().ifPresent(door -> {
                door.setAdditionalLockLevel(0);
                door.setLocked(false);
            });
            this.getOrFindExteriorTile().ifPresent(ext -> {
                ext.setAdditionalLockLevel(0);
                ext.setLocked(false);
                ext.setInteriorRegenerating(false);
            });
        } else {
            int fuelUsage = (Integer)TConfig.SERVER.interiorChangeArtronUse.get();
            ArtronUse artronUse = this.getOrCreateArtronUse(ArtronUse.ArtronType.INTERIOR_CHANGE);
            artronUse.setArtronUsePerTick((float)fuelUsage / (float)processingTicks);
        }
        AxisAlignedBB radius = new AxisAlignedBB(this.func_174877_v()).func_186662_g(30.0);
        for (PlayerEntity player : this.func_145831_w().func_217357_a(PlayerEntity.class, radius)) {
            if (player == null) continue;
            if (cancelProcess) {
                player.func_146105_b((ITextComponent)TardisConstants.Translations.CANCEL_INTERIOR_CHANGE, false);
                continue;
            }
            player.func_146105_b((ITextComponent)new TranslationTextComponent("message.tardis.change_interior.started", new Object[]{this.nextRoomToChange.getRegistryName().toString()}), false);
            player.func_213823_a((SoundEvent)TSounds.TARDIS_SHUT_DOWN.get(), SoundCategory.PLAYERS, 0.6f, 1.0f);
        }
    }

    public void startInteriorChangeProcess(ServerWorld destWorld) {
        destWorld.func_73046_m().func_212871_a_((Runnable)new TickDelayedTask(20, () -> {
            if (!WorldHelper.areDimensionTypesSame((World)destWorld, TDimensions.DimensionTypes.TARDIS_TYPE) && this.getInteriorManager().isInteriorStillRegenerating()) {
                int processingTime = this.getInteriorManager().getInteriorProcessingTime();
                ArtronUse use = this.getOrCreateArtronUse(ArtronUse.ArtronType.INTERIOR_CHANGE);
                use.setTicksToDrain(processingTime);
                this.artronUses.put(ArtronUse.ArtronType.INTERIOR_CHANGE, use);
                List players = this.func_145831_w().func_217369_A();
                for (PlayerEntity player : players) {
                    this.relocatePlayerToExterior(player, destWorld);
                }
                this.onPowerDown(false);
                if (this.nextRoomToChange != null) {
                    ServerWorld consoleWorld = this.func_145831_w().func_73046_m().func_71218_a(this.func_145831_w().func_234923_W_());
                    this.setConsoleRoom(this.nextRoomToChange);
                    this.consoleRoom.spawnConsoleRoom(consoleWorld, false);
                }
                this.getOrFindExteriorTile().ifPresent(ext -> {
                    ext.setInteriorRegenerating(true);
                    ext.setDoorState(EnumDoorState.CLOSED);
                    ext.setLocked(true);
                    ext.setAdditionalLockLevel(1);
                    ext.copyDoorStateToInteriorDoor();
                    ext.updateSpecific(DoorData.create(ext));
                    ext.func_145831_w().func_184133_a(null, this.func_174877_v(), this.exterior.getDoorSounds().getClosedSound(), SoundCategory.BLOCKS, 0.5f, 1.0f);
                    ext.func_145831_w().func_184133_a(null, this.func_174877_v(), (SoundEvent)TSounds.DOOR_LOCK.get(), SoundCategory.BLOCKS, 0.5f, 1.0f);
                });
            }
        }));
    }

    public void handleInteriorChangeComplete() {
        this.setStartChangingInterior(false);
        this.getOrFindExteriorTile().ifPresent(ext -> {
            ext.setInteriorRegenerating(false);
            ext.setLocked(false);
            ext.setAdditionalLockLevel(0);
            ext.copyDoorStateToInteriorDoor();
            ext.updateSpecific(DoorData.create(ext));
            ext.func_145831_w().func_184133_a(null, this.func_174877_v(), (SoundEvent)TSounds.DOOR_UNLOCK.get(), SoundCategory.BLOCKS, 0.5f, 1.0f);
        });
        ServerWorld consoleWorld = this.func_145831_w().func_73046_m().func_71218_a(this.func_145831_w().func_234923_W_());
        TextComponent tardisDim = TextHelper.getTardisDimObject(consoleWorld);
        for (UUID id : this.getEmotionHandler().getLoyaltyTrackingCrew()) {
            ServerPlayerEntity player = this.func_145831_w().func_73046_m().func_184103_al().func_177451_a(id);
            if (player == null) continue;
            player.func_146105_b((ITextComponent)new TranslationTextComponent("message.tardis.change_interior.complete", new Object[]{tardisDim}), false);
            player.func_213823_a((SoundEvent)TSounds.TARDIS_LAND_NOTIFICATION.get(), SoundCategory.PLAYERS, 0.6f, 1.0f);
        }
        int ticks = (Integer)TConfig.SERVER.interiorChangeCooldownTime.get() * 20;
        this.getInteriorManager().setInteriorCooldownTime(ticks);
        this.getInteriorManager().setInteriorProcessingTime(0);
        ArtronUse use = this.getOrCreateArtronUse(ArtronUse.ArtronType.INTERIOR_CHANGE);
        use.setArtronUsePerTick(0.0f);
        use.setTicksToDrain(0);
        this.artronUses.put(ArtronUse.ArtronType.INTERIOR_CHANGE, use);
    }

    public boolean relocatePlayerToExterior(PlayerEntity player, ServerWorld destWorld) {
        if (player != null && destWorld != null) {
            Direction dir = this.getTrueExteriorFacingDirection();
            float realFacing = WorldHelper.getAngleFromFacing(dir.func_176734_d()) + player.field_70177_z;
            BlockPos pos = this.getCurrentLocation().func_177972_a(dir).func_177972_a(dir);
            player.field_70177_z = WorldHelper.getAngleFromFacing(dir.func_176734_d());
            WorldHelper.teleportEntities((Entity)player, destWorld, (double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, realFacing, player.field_70125_A);
            return true;
        }
        return false;
    }

    public boolean relocatePlayerIfExteriorDeadlocked(ServerPlayerEntity player, World world) {
        ExteriorTile ext = this.getExteriorType().getExteriorTile(this);
        ServerWorld destWorld = world.func_73046_m().func_71218_a(this.getCurrentDimension());
        boolean shouldEjectPlayer = true;
        if (ext != null && ext.isExteriorDeadLocked()) {
            if (player.func_184812_l_() || player.func_175149_v()) {
                shouldEjectPlayer = false;
            }
            if (shouldEjectPlayer) {
                world.func_73046_m().func_212871_a_((Runnable)new TickDelayedTask(1, () -> {
                    this.relocatePlayerToExterior((PlayerEntity)player, destWorld);
                    player.func_146105_b((ITextComponent)ExteriorBlock.DEADLOCKED, false);
                }));
            }
        }
        return shouldEjectPlayer;
    }

    public void updateTrackingClients(ConsoleData data) {
        if (!this.field_145850_b.field_72995_K) {
            Network.sendToTrackingTE(new ConsoleUpdateMessage(data.getDataType(), data), this);
        }
    }

    public boolean forceLoadInteriorChunk(boolean forceLoad, boolean clearForcedChunksBeforeReforce) {
        if (!this.field_145850_b.func_201670_d()) {
            ServerWorld sWorld = this.field_145850_b.func_73046_m().func_71218_a(this.field_145850_b.func_234923_W_());
            BlockPos tardisPos = new BlockPos((Vector3i)TardisHelper.TARDIS_POS);
            ChunkPos cPos = new ChunkPos(tardisPos);
            if (clearForcedChunksBeforeReforce) {
                WorldHelper.preLoadTardisInteriorChunks(sWorld, false);
            }
            if (forceLoad) {
                return WorldHelper.forceChunkIfNotLoaded(sWorld, cPos, tardisPos);
            }
            return WorldHelper.unForceChunkIfLoaded(sWorld, cPos, tardisPos);
        }
        return false;
    }

    private void handleAutoLoadOrUnloadChunks() {
        if (!this.field_145850_b.func_201670_d() && this.field_145850_b.func_82737_E() % 60L == 0L) {
            if (this.doesConsoleWorldHaveNoPlayers() && !this.isInFlight() && this.hasForcedChunksToRemove && !this.interiorManager.isInteriorStillRegenerating()) {
                this.forceLoadInteriorChunk(true, true);
                this.hasForcedChunksToRemove = false;
            } else if (!this.doesConsoleWorldHaveNoPlayers() && !this.hasForcedChunksToRemove) {
                this.hasForcedChunksToRemove = true;
            }
        }
    }

    public boolean forceLoadExteriorChunk(boolean forceLoad) {
        if (!this.field_145850_b.func_201670_d()) {
            if (this.getOrFindExteriorTile().isPresent()) {
                ExteriorTile exterior = (ExteriorTile)this.getOrFindExteriorTile().orElseThrow(() -> new IllegalStateException("Cannot find exterior to chunkload for " + this.field_145850_b.func_234923_W_().func_240901_a_().toString()));
                ServerWorld sWorld = this.field_145850_b.func_73046_m().func_71218_a(exterior.func_145831_w().func_234923_W_());
                BlockPos extPos = exterior.func_174877_v();
                ChunkPos cPos = new ChunkPos(extPos);
                if (forceLoad) {
                    return WorldHelper.forceChunkIfNotLoaded(sWorld, cPos, extPos);
                }
                return WorldHelper.unForceChunkIfLoaded(sWorld, cPos, extPos);
            }
            return false;
        }
        return false;
    }

    private void debugForcedChunksInDim(RegistryKey<World> worldKey) {
        ServerWorld otherWorld = this.field_145850_b.func_73046_m().func_71218_a(worldKey);
        Tardis.LOGGER.debug("Does {} have forced chunks? Counted: {}", (Object)otherWorld.func_234923_W_().func_240901_a_(), WorldHelper.getTickingBlockForcedChunks(otherWorld) != null ? Integer.valueOf(WorldHelper.getTickingBlockForcedChunks(otherWorld).size()) : "None");
    }
}

