/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.tileentities;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.tardis.mod.misc.BrokenExteriorType;
import net.tardis.mod.misc.TardisLike;
import net.tardis.mod.network.Network;
import net.tardis.mod.network.packets.BrokenTardisParticleSpawn;
import net.tardis.mod.registries.BrokenExteriors;
import net.tardis.mod.tileentities.TTiles;

public class BrokenExteriorTile
extends TileEntity
implements ITickableTileEntity {
    public static final AxisAlignedBB RENDER_BOX = new AxisAlignedBB(-2.0, -2.0, -2.0, 2.0, 5.0, 2.0);
    private BrokenExteriorType brokenType = null;
    private HashMap<UUID, Integer> playerLoyalty = Maps.newHashMap();
    private boolean forcedEntryTameStarted = false;
    private boolean forcedEntryTameFinished = false;
    private PlayerEntity forcedEntryPlayer = null;
    private int forcedEntryTickTimer = 0;

    public BrokenExteriorTile(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public BrokenExteriorTile() {
        this((TileEntityType)TTiles.BROKEN_TARDIS.get());
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return RENDER_BOX.func_186670_a(this.func_174877_v());
    }

    public BrokenExteriorType getBrokenType() {
        if (this.brokenType == null) {
            this.randomizeType();
        }
        return this.brokenType;
    }

    public boolean onPlayerRightClick(PlayerEntity player, ItemStack stack) {
        for (TardisLike like : TardisLike.getValues()) {
            if (!like.matches(stack)) continue;
            if (this.addLoyalty(player, like.getLoyaltyMod())) {
                this.tameTardis(player);
            }
            return true;
        }
        return false;
    }

    public HashMap<UUID, Integer> getLoyalties() {
        return this.playerLoyalty;
    }

    public boolean addLoyalty(PlayerEntity player, int amt) {
        int initialLoyaltyValue = -100;
        int old = this.playerLoyalty.getOrDefault(player.func_110124_au(), initialLoyaltyValue);
        this.playerLoyalty.put(player.func_110124_au(), old + amt);
        int requiredLoyaltyThreshold = 0;
        Network.sendToAllAround(new BrokenTardisParticleSpawn(this.field_174879_c), (RegistryKey<World>)player.func_130014_f_().func_234923_W_(), this.field_174879_c, 24);
        return old + amt >= requiredLoyaltyThreshold;
    }

    public void tameTardis(PlayerEntity player) {
        ServerWorld interior;
        if (!this.field_145850_b.field_72995_K && (interior = this.getBrokenType().setup((ServerWorld)this.field_145850_b, (ServerPlayerEntity)player, this)) != null) {
            this.getBrokenType().swapWithReal((ServerWorld)this.field_145850_b, this.field_174879_c, (World)interior, (Direction)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208157_J));
        }
    }

    public void startForceTame(PlayerEntity player) {
        if (this.forcedEntryTameStarted) {
            return;
        }
        this.addLoyalty(player, -100);
        this.forcedEntryPlayer = player;
        this.forcedEntryTameStarted = true;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        if (nbt.func_74764_b("type")) {
            this.brokenType = (BrokenExteriorType)BrokenExteriors.BROKEN_EXTERIOR_TYPE_REGISTRY.get().getValue(new ResourceLocation(nbt.func_74779_i("type")));
        } else {
            this.randomizeType();
        }
        ListNBT loyalty = nbt.func_150295_c("loyalties", 10);
        this.playerLoyalty.clear();
        for (INBT base : loyalty) {
            CompoundNBT data = (CompoundNBT)base;
            this.playerLoyalty.put(data.func_186857_a("id"), data.func_74762_e("loyalty"));
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        if (this.brokenType == null) {
            this.randomizeType();
        }
        compound.func_74778_a("type", this.brokenType.getRegistryName().toString());
        ListNBT loyaltyList = new ListNBT();
        for (Map.Entry<UUID, Integer> entry : this.playerLoyalty.entrySet()) {
            CompoundNBT loyalty = new CompoundNBT();
            loyalty.func_186854_a("id", entry.getKey());
            loyalty.func_74768_a("loyalty", entry.getValue().intValue());
            loyaltyList.add((Object)loyalty);
        }
        compound.func_218657_a("loyalties", (INBT)loyaltyList);
        return super.func_189515_b(compound);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.deserializeNBT(pkt.func_148857_g());
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return Network.createTEUpdatePacket(this);
    }

    public CompoundNBT func_189517_E_() {
        return this.serializeNBT();
    }

    public void func_73660_a() {
        if (this.forcedEntryTameStarted && !this.forcedEntryTameFinished && this.forcedEntryTickTimer++ >= 100) {
            this.forcedEntryTameFinished = true;
            this.forcedEntryTickTimer = 0;
            this.tameTardis(this.forcedEntryPlayer);
        }
    }

    public void randomizeType() {
        if (!this.field_145850_b.field_72995_K) {
            this.brokenType = BrokenExteriors.getRandomBrokenType(this.field_145850_b.field_73012_v);
            this.field_145850_b.func_225319_b(this.func_174877_v(), this.func_195044_w(), this.func_195044_w());
        }
    }
}

