/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.tileentities;

import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.INameable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.tardis.mod.blocks.AntiGravBlock;
import net.tardis.mod.entity.TardisEntity;
import net.tardis.mod.tileentities.TTiles;

public class AntiGravityTile
extends TileEntity
implements ITickableTileEntity,
INameable {
    private int range = 1;

    public AntiGravityTile() {
        super((TileEntityType)TTiles.ANTI_GRAV.get());
    }

    public static boolean isInAntiGrav(AxisAlignedBB box, World world) {
        Iterator iterator = BlockPos.func_218281_b((BlockPos)new BlockPos(box.field_72336_d, box.field_72337_e, box.field_72334_f), (BlockPos)new BlockPos(box.field_72340_a, box.field_72338_b, box.field_72339_c)).iterator();
        while (iterator.hasNext()) {
            AntiGravityTile gravityTile;
            BlockPos pos = (BlockPos)iterator.next();
            BlockState blockState = world.func_180495_p(pos);
            if (!(blockState.func_177230_c() instanceof AntiGravBlock) || !((Boolean)blockState.func_177229_b((Property)AntiGravBlock.ACTIVATED)).booleanValue() || world.func_180495_p(pos.func_177984_a()).func_215686_e((IBlockReader)world, pos.func_177984_a()) || (gravityTile = (AntiGravityTile)world.func_175625_s(pos)) == null || !gravityTile.getUppyDownyBox().func_72326_a(box)) continue;
            return true;
        }
        return false;
    }

    public int getRange() {
        return this.range;
    }

    public void setRange(int range) {
        this.range = range;
    }

    public AxisAlignedBB getUppyDownyBox() {
        if (this.field_145850_b != null) {
            return new AxisAlignedBB(this.field_174879_c).func_186662_g((double)this.getRange()).func_72321_a(0.0, (double)this.field_145850_b.func_217301_I(), 0.0);
        }
        return null;
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a()).func_215686_e((IBlockReader)this.field_145850_b, this.field_174879_c.func_177984_a())) {
            return;
        }
        if (this.getRange() > 5 || this.getRange() <= 0) {
            this.setRange(0);
        }
        if (this.field_145850_b != null && ((Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((Property)AntiGravBlock.ACTIVATED)).booleanValue() && this.field_145850_b.func_175640_z(this.field_174879_c)) {
            List list = this.field_145850_b.func_217357_a(Entity.class, this.getUppyDownyBox());
            for (Entity living : list) {
                Vector3d motion = living.func_213322_ci();
                if (this.field_145850_b.field_72995_K) {
                    for (int particleRotation = 0; particleRotation < 20; ++particleRotation) {
                        int an = (int)this.field_145850_b.func_82737_E() % 36;
                        double partAng = Math.toRadians(an * 10);
                        double x = Math.sin(partAng) * (double)this.getRange();
                        double z = Math.cos(partAng) * (double)this.getRange();
                        double y = (double)an / 36.0;
                        this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197629_v, (double)this.field_174879_c.func_177958_n() + x + 0.5, (double)this.field_174879_c.func_177956_o() + y + 1.0 + (double)particleRotation, (double)this.field_174879_c.func_177952_p() + z + 0.5, 0.0, 0.0, 0.0);
                    }
                }
                if (living.field_70125_A < 0.0f || living instanceof ItemEntity || living instanceof ArmorStandEntity || living instanceof BoatEntity || living instanceof TardisEntity) {
                    living.func_213317_d(motion.func_72441_c(0.0, 0.1, 0.0));
                }
                if (!(living instanceof ItemEntity) && (living.field_70125_A > 0.0f || living.func_225608_bj_())) {
                    living.func_213317_d(motion.func_216372_d(1.0, 1.0, 1.0));
                }
                living.field_70143_R = 0.0f;
            }
        }
    }

    public ITextComponent func_200200_C_() {
        return new TranslationTextComponent("display_name.tardis.anti_grav", new Object[]{this.getRange()});
    }

    public boolean func_145818_k_() {
        return true;
    }

    public ITextComponent func_145748_c_() {
        return this.func_200200_C_();
    }

    @Nullable
    public ITextComponent func_200201_e() {
        return this.func_200200_C_();
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a("range", this.range);
        return super.func_189515_b(compound);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        this.setRange(compound.func_74762_e("range"));
        super.func_230337_a_(state, compound);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.setRange(pkt.func_148857_g().func_74762_e("range"));
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), -1, this.func_189517_E_());
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        this.setRange(tag.func_74762_e("range"));
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT tag = this.func_189515_b(new CompoundNBT());
        tag.func_74768_a("range", this.range);
        return tag;
    }
}

