/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.subsystem;

import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.INBTSerializable;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.cap.ITardisWorldData;
import net.tardis.mod.helper.Helper;
import net.tardis.mod.network.Network;
import net.tardis.mod.network.packets.ConsoleUpdateMessage;
import net.tardis.mod.network.packets.console.DataTypes;
import net.tardis.mod.network.packets.console.SubsystemData;
import net.tardis.mod.registries.TardisStatistics;
import net.tardis.mod.subsystem.SubsystemEntry;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.tileentities.console.misc.SparkingLevel;
import net.tardis.mod.tileentities.inventory.PanelInventory;

public abstract class Subsystem
implements INBTSerializable<CompoundNBT> {
    private SubsystemEntry entry;
    private Item itemKey;
    protected ConsoleTile console;
    private boolean isActivated = false;
    protected boolean canBeUsed = false;

    public Subsystem(ConsoleTile console, Item item) {
        this.console = console;
        this.itemKey = item;
    }

    public Item getItemKey() {
        return this.itemKey;
    }

    public ItemStack getItem() {
        ITardisWorldData data;
        if (this.console != null && this.console.func_145830_o() && (data = (ITardisWorldData)this.console.func_145831_w().getCapability(Capabilities.TARDIS_DATA).orElse(null)) != null) {
            PanelInventory inv = data.getEngineInventoryForSide(Direction.NORTH);
            for (int i = 0; i < inv.getSlots(); ++i) {
                if (inv.getStackInSlot(i).func_77973_b() != this.itemKey) continue;
                return inv.getStackInSlot(i);
            }
        }
        return ItemStack.field_190927_a;
    }

    public void damage(@Nullable ServerPlayerEntity player, int amt) {
        if (this.console != null && this.console.isBeingTowed()) {
            return;
        }
        this.getItem().func_96631_a(amt, this.console.func_145831_w().field_73012_v, player);
        if (this.getItem().func_77952_i() >= this.getItem().func_77958_k()) {
            this.console.func_145831_w().getCapability(Capabilities.TARDIS_DATA).ifPresent(cap -> {
                PanelInventory inv = cap.getEngineInventoryForSide(Direction.NORTH);
                for (int i = 0; i < inv.getSlots(); ++i) {
                    if (inv.getStackInSlot(i).func_77973_b() != this.getItemKey()) continue;
                    inv.setStackInSlot(i, ItemStack.field_190927_a);
                    Helper.addTardisStatistic((PlayerEntity)player, TardisStatistics.SUBSYSTEMS_BROKEN);
                    break;
                }
            });
        }
        if (!this.canBeUsed()) {
            this.onBreak();
        }
        this.updateClientIfNeeded();
    }

    public boolean canBeUsed() {
        if (this.console.func_145831_w().field_72995_K) {
            return this.canBeUsed;
        }
        if (!this.isActivated) {
            return false;
        }
        if (this.getItem().func_190926_b()) {
            return false;
        }
        this.canBeUsed = this.getItem().func_77952_i() < this.getItem().func_77958_k();
        return this.canBeUsed;
    }

    public float getHealth() {
        return 1.0f - MathHelper.func_76131_a((float)((float)this.getItem().func_77952_i() / (float)this.getItem().func_77958_k()), (float)0.0f, (float)1.0f);
    }

    public boolean stopsFlight() {
        return !this.canBeUsed();
    }

    public abstract void onTakeoff();

    public abstract void onLand();

    public abstract void onFlightSecond();

    public void onBreak() {
    }

    public SparkingLevel getSparkState() {
        ItemStack stack = this.getItem();
        if (stack.func_77958_k() <= 0) {
            return SparkingLevel.NONE;
        }
        float health = this.getHealth();
        if ((double)this.getHealth() < 0.05) {
            return SparkingLevel.SPARKS;
        }
        if ((double)health < 0.1) {
            return SparkingLevel.SMOKE;
        }
        return SparkingLevel.NONE;
    }

    public void explode(boolean softCrash) {
        this.damage(null, softCrash ? 10 : 50);
    }

    public void setCanBeUsed(boolean used) {
        this.canBeUsed = used;
    }

    private void updateClientIfNeeded() {
        if (this.console.func_145831_w().field_72995_K) {
            return;
        }
        if (this.canBeUsed != this.canBeUsed()) {
            Network.sendToAllInWorld(new ConsoleUpdateMessage(DataTypes.SUBSYSTEM, new SubsystemData(this.getEntry().getRegistryName(), this.canBeUsed(), this.isActivated())), (ServerWorld)this.console.func_145831_w());
        }
    }

    public void setActivated(boolean active) {
        this.isActivated = active;
        this.updateClientIfNeeded();
    }

    public boolean isActivated() {
        return this.isActivated;
    }

    public SubsystemEntry getEntry() {
        return this.entry;
    }

    public Subsystem setEntry(SubsystemEntry s) {
        this.entry = s;
        return this;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74757_a("activated", this.isActivated);
        return tag;
    }

    public void deserializeNBT(CompoundNBT tag) {
        this.isActivated = tag.func_74767_n("activated");
    }
}

