/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.subsystem;

import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;
import net.tardis.mod.misc.SpaceTimeCoord;
import net.tardis.mod.subsystem.Subsystem;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.tileentities.ShipComputerTile;
import net.tardis.mod.tileentities.console.misc.DistressSignal;
import net.tardis.mod.tileentities.console.misc.SparkingLevel;
import net.tardis.mod.tileentities.exteriors.ExteriorTile;
import net.tardis.mod.world.structures.TStructures;

public class AntennaSubsystem
extends Subsystem {
    public AntennaSubsystem(ConsoleTile console, Item item) {
        super(console, item);
    }

    @Override
    public CompoundNBT serializeNBT() {
        return super.serializeNBT();
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        super.deserializeNBT(nbt);
    }

    @Override
    public boolean stopsFlight() {
        return false;
    }

    @Override
    public void onTakeoff() {
    }

    @Override
    public void onLand() {
        ExteriorTile ext;
        if (this.console.func_145831_w().func_201670_d()) {
            return;
        }
        ServerWorld world = (ServerWorld)this.console.func_145831_w();
        this.damage(null, 1);
        if (this.console != null && this.canBeUsed() && (ext = this.console.getExteriorType().getExteriorTile(this.console)) != null && ext.func_145831_w() != null) {
            ChunkPos startCP = ext.func_145831_w().func_217349_x(ext.func_174877_v()).func_76632_l();
            int chunkRad = 3;
            for (int x = -chunkRad; x < chunkRad; ++x) {
                block1: for (int z = -chunkRad; z < chunkRad; ++z) {
                    Chunk c = ext.func_145831_w().func_212866_a_(startCP.field_77276_a + x, startCP.field_77275_b + z);
                    BlockPos pos = c.func_76632_l().func_206849_h();
                    boolean isCrashedStructure = world.func_241112_a_().func_235010_a_(pos, true, (Structure)TStructures.Structures.CRASHED_STRUCTURE.get()).func_75069_d();
                    if (!isCrashedStructure) continue;
                    for (TileEntity te : c.func_177434_r().values()) {
                        ShipComputerTile comp;
                        if (!(te instanceof ShipComputerTile) || (comp = (ShipComputerTile)te).getSchematic() == null) continue;
                        this.console.addDistressSignal(new DistressSignal(new TranslationTextComponent("message.tardis.automated_distress_message").getString(), new SpaceTimeCoord((RegistryKey<World>)ext.func_145831_w().func_234923_W_(), te.func_174877_v())));
                        this.damage((ServerPlayerEntity)this.console.getPilot(), 2);
                        continue block1;
                    }
                }
            }
        }
    }

    @Override
    public void onFlightSecond() {
    }

    @Override
    public void explode(boolean softCrash) {
    }

    @Override
    public SparkingLevel getSparkState() {
        return SparkingLevel.NONE;
    }
}

