/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.sounds;

import java.util.function.Supplier;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.server.ServerWorld;
import net.tardis.mod.sounds.AbstractSoundScheme;
import net.tardis.mod.sounds.TSounds;
import net.tardis.mod.tileentities.ConsoleTile;

public class SoundSchemeBase
extends AbstractSoundScheme {
    private Supplier<SoundEvent> land = () -> (SoundEvent)TSounds.TARDIS_LAND.get();
    private Supplier<SoundEvent> takeoff = () -> (SoundEvent)TSounds.TARDIS_TAKEOFF.get();
    private Supplier<SoundEvent> fly = () -> (SoundEvent)TSounds.TARDIS_FLY_LOOP.get();

    public SoundSchemeBase(Supplier<SoundEvent> takeoff, Supplier<SoundEvent> land, Supplier<SoundEvent> fly) {
        this.land = land;
        this.takeoff = takeoff;
        this.fly = fly;
    }

    public SoundSchemeBase() {
    }

    @Override
    public void playFlightLoop(ConsoleTile console) {
        console.func_145831_w().func_184133_a(null, console.func_174877_v(), this.fly.get(), SoundCategory.BLOCKS, 0.25f, 1.0f);
    }

    @Override
    public void playInteriorTakeOff(ConsoleTile console) {
        console.func_145831_w().func_184133_a(null, console.func_174877_v(), this.takeoff.get(), SoundCategory.BLOCKS, 0.5f, 1.0f);
    }

    @Override
    public void playExteriorTakeOff(ConsoleTile console) {
        ServerWorld world = console.func_145831_w().func_73046_m().func_71218_a(console.getCurrentDimension());
        if (world != null) {
            world.func_184133_a(null, console.getCurrentLocation(), this.takeoff.get(), SoundCategory.BLOCKS, 0.5f, 1.0f);
        }
    }

    @Override
    public void playInteriorLand(ConsoleTile console) {
        console.func_145831_w().func_184133_a(null, console.func_174877_v(), this.land.get(), SoundCategory.BLOCKS, 0.5f, 1.0f);
    }

    @Override
    public void playExteriorLand(ConsoleTile console) {
        ServerWorld world = console.func_145831_w().func_73046_m().func_71218_a(console.getDestinationDimension());
        if (world != null) {
            world.func_184133_a(null, console.getDestinationPosition(), this.land.get(), SoundCategory.BLOCKS, 0.5f, 1.0f);
        }
    }

    @Override
    public int getLoopTime() {
        return 32;
    }

    @Override
    public int getLandTime() {
        return 200;
    }

    @Override
    public int getTakeoffTime() {
        return 200;
    }

    @Override
    public void playTakeoffSounds(ConsoleTile console) {
        this.playInteriorTakeOff(console);
        this.playExteriorTakeOff(console);
    }

    @Override
    public void playLandSounds(ConsoleTile console) {
        this.playExteriorLand(console);
        this.playInteriorLand(console);
    }

    @Override
    public void playInteriorLandAfter(ConsoleTile console) {
        console.func_145831_w().func_184133_a(null, console.func_174877_v(), (SoundEvent)TSounds.REACHED_DESTINATION.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
    }
}

