/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.sonic.interactions;

import java.util.ArrayList;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.tardis.mod.config.TConfig;
import net.tardis.mod.constants.TardisConstants;
import net.tardis.mod.helper.PlayerHelper;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.helper.TextHelper;
import net.tardis.mod.helper.WorldHelper;
import net.tardis.mod.items.SonicItem;
import net.tardis.mod.items.TItems;
import net.tardis.mod.sonic.AbstractSonicMode;
import net.tardis.mod.tileentities.ConsoleTile;

public class SonicTardisDestinationInteraction
extends AbstractSonicMode {
    @Override
    public boolean processBlock(PlayerEntity player, BlockState blockState, ItemStack sonic, BlockPos pos) {
        if (!((Boolean)TConfig.SERVER.coordinateTardis.get()).booleanValue()) {
            return false;
        }
        if (!player.field_70170_p.field_72995_K && WorldHelper.canTravelToDimension(player.field_70170_p) && sonic.func_77973_b() instanceof SonicItem) {
            SonicItem sonicItem = (SonicItem)sonic.func_77973_b();
            if (sonicItem.getTardis(sonic) != null) {
                ConsoleTile console = TardisHelper.getConsole(player.func_184102_h(), sonicItem.getTardis(sonic)).orElse(null);
                if (console != null) {
                    if (!console.isLanding()) {
                        if (this.handleDischarge((Entity)player, sonic, 25.0f)) {
                            console.setDestination((RegistryKey<World>)player.field_70170_p.func_234923_W_(), pos);
                            console.setExteriorFacingDirection(player.func_174811_aO());
                            PlayerHelper.sendMessageToPlayer(player, new TranslationTextComponent("message.sonic.tardis_dest_set", new Object[]{TextHelper.getBlockPosObject(pos)}), false);
                            return true;
                        }
                        return false;
                    }
                    return false;
                }
            } else {
                PlayerHelper.sendMessageToPlayer(player, TardisConstants.Translations.ITEM_NOT_ATTUNED, true);
                return false;
            }
        }
        PlayerHelper.sendMessageToPlayer(player, new TranslationTextComponent("message.sonic.tardis_dest_fail"), true);
        return false;
    }

    @Override
    public boolean processEntity(PlayerEntity user, Entity targeted, ItemStack sonic) {
        return false;
    }

    @Override
    public ArrayList<TranslationTextComponent> getAdditionalInfo() {
        ArrayList<TranslationTextComponent> list = new ArrayList<TranslationTextComponent>();
        list.add(new TranslationTextComponent("sonic.modes.info.set_coords"));
        return list;
    }

    @Override
    public boolean hasAdditionalInfo() {
        return true;
    }

    @Override
    public void updateHeld(PlayerEntity playerEntity, ItemStack stack) {
    }

    @Override
    public ItemStack getItemDisplayIcon() {
        return new ItemStack((IItemProvider)TItems.BROKEN_EXTERIOR.get());
    }
}

