/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.sonic.interactions;

import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.tardis.mod.cap.items.sonic.SonicCapability;
import net.tardis.mod.damagesources.TDamageSources;
import net.tardis.mod.helper.PlayerHelper;
import net.tardis.mod.items.SonicItem;
import net.tardis.mod.sonic.AbstractSonicMode;

public class SonicLaserInteraction
extends AbstractSonicMode {
    @Override
    public boolean processBlock(PlayerEntity player, BlockState blockState, ItemStack sonic, BlockPos pos) {
        if (player.field_70170_p.field_72995_K) {
            return false;
        }
        return false;
    }

    @Override
    public boolean processEntity(PlayerEntity user, Entity targeted, ItemStack sonic) {
        if (user.field_70170_p.field_72995_K) {
            return false;
        }
        SonicCapability.getForStack(sonic).ifPresent(data -> {
            if (data.getCharge() > 0.0f) {
                targeted.func_70097_a(TDamageSources.LASER_SONIC, 5.0f);
            }
        });
        return false;
    }

    @Override
    public boolean hasAdditionalInfo() {
        return false;
    }

    @Override
    public void updateHeld(PlayerEntity playerEntity, ItemStack stack) {
        RayTraceResult raytraceresult = PlayerHelper.getPosLookingAt((Entity)playerEntity, SonicItem.getCurrentMode(stack).getReachDistance());
        if (raytraceresult != null) {
            if (raytraceresult.func_216346_c() == RayTraceResult.Type.ENTITY) {
                EntityRayTraceResult entityRayTraceResult = (EntityRayTraceResult)raytraceresult;
                this.processEntity(playerEntity, entityRayTraceResult.func_216348_a(), stack);
                SonicCapability.getForStack(stack).ifPresent(cap -> cap.sync(playerEntity, Hand.MAIN_HAND));
            }
            if (raytraceresult.func_216346_c() == RayTraceResult.Type.BLOCK) {
                BlockRayTraceResult blockRayTraceResult = (BlockRayTraceResult)raytraceresult;
                this.processBlock(playerEntity, playerEntity.field_70170_p.func_180495_p(blockRayTraceResult.func_216350_a()), stack, blockRayTraceResult.func_216350_a());
                SonicCapability.getForStack(stack).ifPresent(cap -> cap.sync(playerEntity, Hand.MAIN_HAND));
            }
        }
    }
}

