/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.sonic.interactions;

import java.util.ArrayList;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.monster.WitherSkeletonEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.passive.SquidEntity;
import net.minecraft.entity.passive.horse.SkeletonHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.tardis.mod.config.TConfig;
import net.tardis.mod.constants.TardisConstants;
import net.tardis.mod.helper.PlayerHelper;
import net.tardis.mod.helper.TInventoryHelper;
import net.tardis.mod.sonic.AbstractSonicMode;

public class SonicEntityInteraction
extends AbstractSonicMode {
    @Override
    public boolean processBlock(PlayerEntity player, BlockState blockState, ItemStack sonic, BlockPos pos) {
        PlayerHelper.sendMessageToPlayer(player, TardisConstants.Translations.INVALID_SONIC_RESULT, true);
        return false;
    }

    @Override
    public boolean processEntity(PlayerEntity user, Entity targeted, ItemStack sonic) {
        if (user.field_70170_p.field_72995_K) {
            return false;
        }
        if (user.func_184587_cr()) {
            if (targeted instanceof CreeperEntity && ((Boolean)TConfig.SERVER.detonateCreeper.get()).booleanValue()) {
                if (this.handleDischarge((Entity)user, sonic, 15.0f)) {
                    CreeperEntity creeper = (CreeperEntity)targeted;
                    creeper.func_146079_cb();
                    return true;
                }
                return false;
            }
            if (targeted instanceof TNTEntity) {
                targeted.func_70106_y();
                InventoryHelper.func_180173_a((World)targeted.field_70170_p, (double)targeted.func_226277_ct_(), (double)targeted.func_226278_cu_(), (double)targeted.func_226281_cx_(), (ItemStack)new ItemStack((IItemProvider)Items.field_151016_H, 3));
                return true;
            }
            if (targeted instanceof SheepEntity && ((Boolean)TConfig.SERVER.shearSheep.get()).booleanValue()) {
                if (this.handleDischarge((Entity)user, sonic, 15.0f)) {
                    SheepEntity sheep = (SheepEntity)targeted;
                    if (!sheep.func_70892_o()) {
                        sheep.func_230263_a_(SoundCategory.PLAYERS);
                        return true;
                    }
                } else {
                    return false;
                }
            }
            if ((targeted instanceof SkeletonEntity || targeted instanceof SkeletonHorseEntity || targeted instanceof WitherSkeletonEntity) && ((Boolean)TConfig.SERVER.dismantleSkeleton.get()).booleanValue()) {
                if (this.handleDischarge((Entity)user, sonic, 50.0f)) {
                    TInventoryHelper.dropEntityLoot(targeted, user);
                    targeted.func_70106_y();
                    return true;
                }
                return false;
            }
            if (targeted instanceof SquidEntity && ((Boolean)TConfig.SERVER.inkSquid.get()).booleanValue()) {
                if (this.handleDischarge((Entity)user, sonic, 15.0f)) {
                    SquidEntity squid = (SquidEntity)targeted;
                    squid.func_70097_a(DamageSource.field_76377_j, 1.0f);
                    squid.func_203039_dq();
                    return true;
                }
                return false;
            }
            if (targeted instanceof ArmorStandEntity) {
                if (this.handleDischarge((Entity)user, sonic, 5.0f)) {
                    ArmorStandEntity standEntity;
                    standEntity.func_175413_k(!(standEntity = (ArmorStandEntity)targeted).func_175402_q());
                    return true;
                }
                return false;
            }
            PlayerHelper.sendMessageToPlayer(user, TardisConstants.Translations.INVALID_SONIC_RESULT, true);
            return false;
        }
        return false;
    }

    @Override
    public boolean hasAdditionalInfo() {
        return true;
    }

    @Override
    public void updateHeld(PlayerEntity playerEntity, ItemStack stack) {
    }

    @Override
    public ArrayList<TranslationTextComponent> getAdditionalInfo() {
        EntityType[] useableOn;
        ArrayList<TranslationTextComponent> list = new ArrayList<TranslationTextComponent>();
        list.add(new TranslationTextComponent("sonic.modes.info.interactable_entities"));
        for (EntityType entityType : useableOn = new EntityType[]{EntityType.field_200737_ac, EntityType.field_200797_k, EntityType.field_200749_ao, EntityType.field_200741_ag, EntityType.field_200722_aA, EntityType.field_200742_ah, EntityType.field_200789_c}) {
            list.add((TranslationTextComponent)new TranslationTextComponent("- ").func_230529_a_((ITextComponent)new TranslationTextComponent(entityType.func_210760_d()).func_240699_a_(TextFormatting.GRAY)));
        }
        return list;
    }

    @Override
    public void processSpecialEntity(PlayerInteractEvent.EntityInteract event) {
        if (event.getEntityLiving() instanceof ArmorStandEntity) {
            event.setCanceled(true);
        }
        this.processEntity(event.getPlayer(), event.getTarget(), event.getItemStack());
    }

    @Override
    public ItemStack getItemDisplayIcon() {
        return new ItemStack((IItemProvider)Items.field_196185_dy);
    }
}

