/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.sonic.interactions;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DispenserBlock;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.RedstoneLampBlock;
import net.minecraft.block.TNTBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.tardis.mod.blocks.TBlocks;
import net.tardis.mod.client.ClientHelper;
import net.tardis.mod.config.TConfig;
import net.tardis.mod.constants.TardisConstants;
import net.tardis.mod.contexts.gui.GuiContextBlock;
import net.tardis.mod.helper.PlayerHelper;
import net.tardis.mod.sonic.AbstractSonicMode;
import net.tardis.mod.tileentities.machines.TransductionBarrierTile;

public class SonicBlockInteraction
extends AbstractSonicMode {
    private final Method dispenseMethod = ObfuscationReflectionHelper.findMethod(DispenserBlock.class, (String)"func_176439_d", (Class[])new Class[]{ServerWorld.class, BlockPos.class});

    @Override
    public boolean processBlock(PlayerEntity player, BlockState blockState, ItemStack sonic, BlockPos pos) {
        World world = player.field_70170_p;
        Block block = blockState.func_177230_c();
        if (!world.func_201670_d() && player.func_184587_cr()) {
            if (this.isWood(blockState)) {
                PlayerHelper.sendMessageToPlayer(player, new TranslationTextComponent("message.tardis.wood_fail"), true);
                return false;
            }
            if (block instanceof DispenserBlock) {
                try {
                    if (this.handleDischarge((Entity)player, sonic, 5.0f)) {
                        this.dispenseMethod.invoke((Object)world, pos);
                        return true;
                    }
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            if (block instanceof TNTBlock && ((Boolean)TConfig.SERVER.detonateTnt.get()).booleanValue() && this.handleDischarge((Entity)player, sonic, 20.0f)) {
                PlayerHelper.sendMessageToPlayer(player, new TranslationTextComponent("message.tardis.detonate_tnt"), true);
                player.field_70170_p.func_217377_a(pos, true);
                TNTEntity tnt = new TNTEntity(world, (double)((float)pos.func_177958_n() + 0.5f), (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() + 0.5f), (LivingEntity)player);
                world.func_217376_c((Entity)tnt);
                world.func_184148_a(null, tnt.func_226277_ct_(), tnt.func_226278_cu_(), tnt.func_226281_cx_(), SoundEvents.field_187904_gd, SoundCategory.BLOCKS, 1.0f, 1.0f);
                return true;
            }
            if (block instanceof RedstoneLampBlock && ((Boolean)TConfig.SERVER.redstoneLamps.get()).booleanValue() && block == Blocks.field_150379_bu && this.handleDischarge((Entity)player, sonic, 5.0f)) {
                world.func_180501_a(pos, (BlockState)blockState.func_206870_a((Property)RedstoneLampBlock.field_196502_a, (Comparable)Boolean.valueOf((Boolean)blockState.func_177229_b((Property)RedstoneLampBlock.field_196502_a) == false)), 2);
                return true;
            }
            if (block instanceof DoorBlock && ((Boolean)TConfig.SERVER.openDoors.get()).booleanValue() && this.handleDischarge((Entity)player, sonic, 5.0f)) {
                world.func_180501_a(pos, (BlockState)blockState.func_206870_a((Property)DoorBlock.field_176519_b, (Comparable)Boolean.valueOf((Boolean)blockState.func_177229_b((Property)DoorBlock.field_176519_b) == false)), 10);
                world.func_217378_a(player, ((Boolean)blockState.func_177229_b((Property)DoorBlock.field_176519_b)).booleanValue() ? (blockState.func_185904_a() == Material.field_151573_f ? 1005 : 1006) : (blockState.func_185904_a() == Material.field_151573_f ? 1011 : 1012), pos, 0);
                return true;
            }
            if (block instanceof TrapDoorBlock && ((Boolean)TConfig.SERVER.openTrapDoors.get()).booleanValue()) {
                if (this.handleDischarge((Entity)player, sonic, 5.0f)) {
                    world.func_175656_a(pos, (BlockState)blockState.func_206870_a((Property)DoorBlock.field_176519_b, (Comparable)Boolean.valueOf((Boolean)blockState.func_177229_b((Property)DoorBlock.field_176519_b) == false)));
                    return true;
                }
            } else {
                PlayerHelper.sendMessageToPlayer(player, TardisConstants.Translations.INVALID_SONIC_RESULT, true);
            }
        }
        if (world.field_72995_K) {
            if (world.func_175625_s(pos) instanceof TransductionBarrierTile) {
                if (this.handleDischarge((Entity)player, sonic, 0.0f)) {
                    ClientHelper.openGUI(16, new GuiContextBlock(world, pos));
                    return true;
                }
            } else {
                PlayerHelper.sendMessageToPlayer(player, TardisConstants.Translations.INVALID_SONIC_RESULT, true);
            }
        }
        return false;
    }

    @Override
    public boolean processEntity(PlayerEntity user, Entity targeted, ItemStack sonic) {
        return false;
    }

    @Override
    public ArrayList<TranslationTextComponent> getAdditionalInfo() {
        ArrayList<TranslationTextComponent> list = new ArrayList<TranslationTextComponent>();
        list.add(new TranslationTextComponent("sonic.modes.info.interactable_blocks"));
        for (Block interactableBlock : this.getInteractableBlocks()) {
            list.add((TranslationTextComponent)new TranslationTextComponent("- ").func_230529_a_((ITextComponent)new TranslationTextComponent(interactableBlock.func_149739_a()).func_240699_a_(TextFormatting.GRAY)));
        }
        return list;
    }

    public ArrayList<Block> getInteractableBlocks() {
        ArrayList<Block> list = new ArrayList<Block>();
        for (Block block : ForgeRegistries.BLOCKS) {
            if (!(block instanceof TrapDoorBlock) && !(block instanceof DoorBlock) && !(block instanceof RedstoneLampBlock) && !(block instanceof TNTBlock) && block != TBlocks.transduction_barrier.get() || this.isWood(block.func_176223_P())) continue;
            list.add(block);
        }
        return list;
    }

    @Override
    public boolean hasAdditionalInfo() {
        return true;
    }

    @Override
    public void updateHeld(PlayerEntity playerEntity, ItemStack stack) {
    }

    public boolean isWood(BlockState blockState) {
        return blockState.func_185904_a() == Material.field_151575_d || blockState.func_185904_a() == Material.field_215713_z || blockState.func_185904_a() == Material.field_215712_y;
    }

    @Override
    public void processSpecialBlocks(PlayerInteractEvent.RightClickBlock event) {
        World world = event.getWorld();
        BlockState blockState = world.func_180495_p(event.getPos());
        if (blockState.func_177230_c() instanceof DispenserBlock) {
            event.setCanceled(true);
        }
        this.processBlock(event.getPlayer(), blockState, event.getItemStack(), event.getPos());
    }
}

