/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.sonic.interactions;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.chunk.Chunk;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.config.TConfig;
import net.tardis.mod.items.TItems;
import net.tardis.mod.sonic.AbstractSonicMode;
import net.tardis.mod.sounds.TSounds;

public class RiftProbeInteraction
extends AbstractSonicMode {
    public static final String RIFT = "message.tardis.found_rift";

    @Override
    public void inventoryTick(PlayerEntity player, ItemStack sonic) {
        if (player.field_70173_aa % 20 == 0) {
            Chunk c = player.field_70170_p.func_175726_f(player.func_233580_cy_());
            c.getCapability(Capabilities.RIFT).ifPresent(rift -> {
                if (rift.isRift()) {
                    this.onFoundRift(player, rift.getRiftEnergy());
                }
            });
        }
    }

    public void onFoundRift(PlayerEntity player, float riftEnergy) {
        if (!player.field_70170_p.field_72995_K) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent(RIFT, new Object[]{Float.valueOf(riftEnergy)}).func_240699_a_(TextFormatting.LIGHT_PURPLE), true);
        }
        if (((Boolean)TConfig.CLIENT.playToolNotificationSounds.get()).booleanValue()) {
            player.func_213823_a((SoundEvent)TSounds.REMOTE_ACCEPT.get(), SoundCategory.PLAYERS, 0.5f, 1.0f);
        }
    }

    @Override
    public ItemStack getItemDisplayIcon() {
        return new ItemStack((IItemProvider)TItems.DIAGNOSTIC_TOOL.get());
    }
}

