/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.schematics.types;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.tardis.mod.schematics.Schematic;

public abstract class SchematicType
extends ForgeRegistryEntry<SchematicType> {
    public abstract Schematic deserialize(JsonObject var1);

    public abstract Schematic deserialize(PacketBuffer var1);

    public abstract Schematic serialize(Schematic var1, PacketBuffer var2);

    public abstract JsonObject serialize(Schematic var1);

    public static void setTranslationOrDisplayName(JsonObject root, Schematic schematic) {
        String name = root.get("display_name").getAsString();
        boolean translate = root.has("translated") && root.get("translated").getAsBoolean();
        schematic.setDisplayName(name);
        if (translate) {
            schematic.setTranslation(name);
        }
    }

    public JsonObject createBaseJson(String displayName, boolean translated) {
        JsonObject root = new JsonObject();
        root.add("type", (JsonElement)new JsonPrimitive(this.getRegistryName().toString()));
        root.add("display_name", (JsonElement)new JsonPrimitive(displayName));
        root.add("translated", (JsonElement)new JsonPrimitive(Boolean.valueOf(translated)));
        return root;
    }

    public <T extends Schematic> T getSchematicAs(Class<T> type, Schematic schematic) {
        return (T)schematic;
    }
}

