/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.schematics;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.RegistryObject;
import net.tardis.mod.ars.ConsoleRoom;
import net.tardis.mod.exterior.AbstractExterior;
import net.tardis.mod.helper.Helper;
import net.tardis.mod.misc.Console;
import net.tardis.mod.registries.ConsoleRegistry;
import net.tardis.mod.registries.ExteriorRegistry;
import net.tardis.mod.schematics.ConsoleUnlockSchematic;
import net.tardis.mod.schematics.ExteriorUnlockSchematic;
import net.tardis.mod.schematics.InteriorUnlockSchematic;
import net.tardis.mod.schematics.Schematic;
import net.tardis.mod.schematics.types.SchematicType;

public class Schematics {
    public static Map<ResourceLocation, Schematic> SCHEMATIC_REGISTRY = new HashMap<ResourceLocation, Schematic>();

    private static ConsoleUnlockSchematic registerConsoleSchematic(String key, String consoleKey, String displayName) {
        ConsoleUnlockSchematic schematic = Schematics.createConsoleSchematic(key, consoleKey, displayName);
        SCHEMATIC_REGISTRY.put(schematic.getId(), schematic);
        return schematic;
    }

    private static ExteriorUnlockSchematic registerExteriorSchematic(String key, String exteriorKey, String displayName) {
        ExteriorUnlockSchematic schematic = Schematics.createExteriorSchematic(key, exteriorKey, displayName);
        SCHEMATIC_REGISTRY.put(schematic.getId(), schematic);
        return schematic;
    }

    private static InteriorUnlockSchematic registerInteriorSchematic(String key, String consoleRoomKey, String displayName) {
        InteriorUnlockSchematic schematic = Schematics.createInteriorSchematic(key, consoleRoomKey, displayName);
        SCHEMATIC_REGISTRY.put(schematic.getId(), schematic);
        return schematic;
    }

    private static ConsoleUnlockSchematic createConsoleSchematic(String key, String consoleKey, String displayName) {
        ConsoleUnlockSchematic schematic = new ConsoleUnlockSchematic();
        ResourceLocation registryName = new ResourceLocation("tardis", key);
        ResourceLocation consoleID = new ResourceLocation("tardis", consoleKey);
        schematic.setId(registryName).setDisplayName(displayName);
        schematic.setConsole(consoleID);
        return schematic;
    }

    private static ConsoleUnlockSchematic createConsoleSchematicWithTranslation(String key, Console console) {
        ConsoleUnlockSchematic consoleSchematic = Schematics.createConsoleSchematicWithTranslation(Helper.createRL(key), console);
        return consoleSchematic;
    }

    public static ConsoleUnlockSchematic createConsoleSchematicWithTranslation(ResourceLocation key, Console console) {
        ConsoleUnlockSchematic consoleSchematic = new ConsoleUnlockSchematic();
        consoleSchematic.setConsole(console.getRegistryName());
        consoleSchematic.setId(key);
        consoleSchematic.setTranslation(console.getDisplayName().getString());
        return consoleSchematic;
    }

    public static ConsoleUnlockSchematic createConsoleSchematic(ResourceLocation registryName, ResourceLocation consoleID, String displayName, RegistryObject<SchematicType> type) {
        ConsoleUnlockSchematic schematic = new ConsoleUnlockSchematic((SchematicType)type.get());
        schematic.setId(registryName).setDisplayName(displayName);
        schematic.setConsole(consoleID);
        return schematic;
    }

    private static ExteriorUnlockSchematic createExteriorSchematic(String key, String exteriorKey, String displayName) {
        ExteriorUnlockSchematic schematic = new ExteriorUnlockSchematic();
        ResourceLocation registryName = new ResourceLocation("tardis", key);
        ResourceLocation exteriorID = new ResourceLocation("tardis", exteriorKey);
        schematic.setId(registryName).setDisplayName(displayName);
        schematic.setExterior(exteriorID);
        return schematic;
    }

    public static ExteriorUnlockSchematic createExteriorSchematic(ResourceLocation registryName, ResourceLocation exteriorID, String displayName) {
        ExteriorUnlockSchematic schematic = new ExteriorUnlockSchematic();
        schematic.setId(registryName).setDisplayName(displayName);
        schematic.setExterior(exteriorID);
        return schematic;
    }

    public static ExteriorUnlockSchematic createExteriorSchematicWithTranslation(ResourceLocation key, AbstractExterior exterior) {
        ExteriorUnlockSchematic schematic = new ExteriorUnlockSchematic();
        schematic.setExterior(exterior.getRegistryName());
        schematic.setId(key);
        schematic.setTranslation(exterior.getTranslationKey());
        return schematic;
    }

    private static ExteriorUnlockSchematic createExteriorSchematicWithTranslation(String key, AbstractExterior exterior) {
        ExteriorUnlockSchematic schematic = Schematics.createExteriorSchematicWithTranslation(Helper.createRL(key), exterior);
        return schematic;
    }

    private static InteriorUnlockSchematic createInteriorSchematic(String key, String consoleRoomKey, String displayName) {
        InteriorUnlockSchematic schematic = new InteriorUnlockSchematic();
        ResourceLocation registryName = new ResourceLocation("tardis", key);
        ResourceLocation consoleRoomID = new ResourceLocation("tardis", consoleRoomKey);
        schematic.setId(registryName).setDisplayName(displayName);
        schematic.setConsoleRoom(consoleRoomID);
        return schematic;
    }

    public static InteriorUnlockSchematic createInteriorSchematic(ResourceLocation registryName, ResourceLocation consoleRoomID, String displayName) {
        InteriorUnlockSchematic schematic = new InteriorUnlockSchematic();
        schematic.setId(registryName).setDisplayName(displayName);
        schematic.setConsoleRoom(consoleRoomID);
        return schematic;
    }

    public static InteriorUnlockSchematic createInteriorSchematicWithTranslation(ResourceLocation registryName, Supplier<ConsoleRoom> room) {
        InteriorUnlockSchematic schematic = new InteriorUnlockSchematic();
        ConsoleRoom interior = room.get();
        schematic.setConsoleRoom(interior.getRegistryName());
        schematic.setTranslation(interior.getTranslationKey());
        schematic.setId(registryName);
        return schematic;
    }

    private static InteriorUnlockSchematic createInteriorSchematicWithTranslation(String key, Supplier<ConsoleRoom> room) {
        InteriorUnlockSchematic schematic = Schematics.createInteriorSchematicWithTranslation(Helper.createRL(key), room);
        return schematic;
    }

    static /* synthetic */ ConsoleUnlockSchematic access$000(String x0, Console x1) {
        return Schematics.createConsoleSchematicWithTranslation(x0, x1);
    }

    static /* synthetic */ ExteriorUnlockSchematic access$100(String x0, AbstractExterior x1) {
        return Schematics.createExteriorSchematicWithTranslation(x0, x1);
    }

    static /* synthetic */ InteriorUnlockSchematic access$200(String x0, Supplier x1) {
        return Schematics.createInteriorSchematicWithTranslation(x0, (Supplier<ConsoleRoom>)x1);
    }

    public static class Interiors {
        public static final InteriorUnlockSchematic STEAM = Schematics.access$200("interiors/steam", () -> ConsoleRoom.STEAM);
        public static final InteriorUnlockSchematic JADE = Schematics.access$200("interiors/bokkusu", () -> ConsoleRoom.JADE);
        public static final InteriorUnlockSchematic NAUTILUS = Schematics.access$200("interiors/nautilus", () -> ConsoleRoom.NAUTILUS);
        public static final InteriorUnlockSchematic OMEGA = Schematics.access$200("interiors/omega", () -> ConsoleRoom.OMEGA);
        public static final InteriorUnlockSchematic ALABASTER = Schematics.access$200("interiors/alabaster", () -> ConsoleRoom.ALABASTER);
        public static final InteriorUnlockSchematic ARCHITECT = Schematics.access$200("interiors/architect", () -> ConsoleRoom.ARCHITECT);
        public static final InteriorUnlockSchematic CORAL = Schematics.access$200("interiors/coral", () -> ConsoleRoom.CORAL);
        public static final InteriorUnlockSchematic PANAMAX = Schematics.access$200("interiors/panamax", () -> ConsoleRoom.PANAMAX);
        public static final InteriorUnlockSchematic TOYOTA = Schematics.access$200("interiors/toyota", () -> ConsoleRoom.TOYOTA);
        public static final InteriorUnlockSchematic TRAVELER = Schematics.access$200("interiors/traveler", () -> ConsoleRoom.TRAVELER);
        public static final InteriorUnlockSchematic ENVOY = Schematics.access$200("interiors/envoy", () -> ConsoleRoom.ENVOY);
        public static final InteriorUnlockSchematic AMETHYST = Schematics.access$200("interiors/amethyst", () -> ConsoleRoom.AMETHYST);
        public static final InteriorUnlockSchematic IMPERIAL = Schematics.access$200("interiors/imperial", () -> ConsoleRoom.IMPERIAL);
    }

    public static class Exteriors {
        public static final ExteriorUnlockSchematic STEAMPUNK = Schematics.access$100("exteriors/steampunk", (AbstractExterior)ExteriorRegistry.STEAMPUNK.get());
        public static final ExteriorUnlockSchematic TRUNK = Schematics.access$100("exteriors/trunk", (AbstractExterior)ExteriorRegistry.TRUNK.get());
        public static final ExteriorUnlockSchematic TELEPHONE = Schematics.access$100("exteriors/telephone", (AbstractExterior)ExteriorRegistry.TELEPHONE.get());
        public static final ExteriorUnlockSchematic FORTUNE = Schematics.access$100("exteriors/fortune", (AbstractExterior)ExteriorRegistry.FORTUNE.get());
        public static final ExteriorUnlockSchematic SAFE = Schematics.access$100("exteriors/safe", (AbstractExterior)ExteriorRegistry.SAFE.get());
        public static final ExteriorUnlockSchematic TT_CAPSULE = Schematics.access$100("exteriors/tt_capsule", (AbstractExterior)ExteriorRegistry.TT_CAPSULE.get());
        public static final ExteriorUnlockSchematic CLOCK = Schematics.access$100("exteriors/clock", (AbstractExterior)ExteriorRegistry.CLOCK.get());
        public static final ExteriorUnlockSchematic TT_2020 = Schematics.access$100("exteriors/tt_2020", (AbstractExterior)ExteriorRegistry.TT_2020.get());
        public static final ExteriorUnlockSchematic BOKKUSU = Schematics.access$100("exteriors/bokkusu", (AbstractExterior)ExteriorRegistry.BOKKUSU.get());
        public static final ExteriorUnlockSchematic APERTURE = Schematics.access$100("exteriors/aperture", (AbstractExterior)ExteriorRegistry.APERTURE.get());
        public static final ExteriorUnlockSchematic POLICE_BOX = Schematics.access$100("exteriors/police_box", (AbstractExterior)ExteriorRegistry.POLICE_BOX.get());
        public static final ExteriorUnlockSchematic POLICE_BOX_MODERN = Schematics.access$100("exteriors/modern_police_box", (AbstractExterior)ExteriorRegistry.MODERN_POLICE_BOX.get());
        public static final ExteriorUnlockSchematic DISGUISE = Schematics.access$100("exteriors/disguise", (AbstractExterior)ExteriorRegistry.DISGUISE.get());
    }

    public static class Consoles {
        public static final ConsoleUnlockSchematic NEMO = Schematics.access$000("consoles/nemo", (Console)ConsoleRegistry.NEMO.get());
        public static final ConsoleUnlockSchematic STEAM = Schematics.access$000("consoles/steam", (Console)ConsoleRegistry.STEAM.get());
        public static final ConsoleUnlockSchematic GALVANIC = Schematics.access$000("consoles/galvanic", (Console)ConsoleRegistry.GALVANIC.get());
        public static final ConsoleUnlockSchematic CORAL = Schematics.access$000("consoles/coral", (Console)ConsoleRegistry.CORAL.get());
        public static final ConsoleUnlockSchematic HARTNELL = Schematics.access$000("consoles/hartnell", (Console)ConsoleRegistry.HARTNELL.get());
        public static final ConsoleUnlockSchematic TOYOTA = Schematics.access$000("consoles/toyota", (Console)ConsoleRegistry.TOYOTA.get());
        public static final ConsoleUnlockSchematic XION = Schematics.access$000("consoles/xion", (Console)ConsoleRegistry.XION.get());
        public static final ConsoleUnlockSchematic NEUTRON = Schematics.access$000("consoles/neutron", (Console)ConsoleRegistry.NEUTRON.get());
        public static final ConsoleUnlockSchematic POLYMEDICAL = Schematics.access$000("consoles/polymedical", (Console)ConsoleRegistry.POLYMEDICAL.get());
    }
}

