/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.schematics;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.resources.ReloadListener;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.tardis.mod.Tardis;
import net.tardis.mod.registries.SchematicTypes;
import net.tardis.mod.schematics.Schematic;
import net.tardis.mod.schematics.Schematics;
import net.tardis.mod.schematics.types.SchematicType;
import org.apache.logging.log4j.Level;

public class SchematicDataListener
extends ReloadListener<Map<ResourceLocation, Schematic>> {
    public static final SchematicDataListener INSTANCE = new SchematicDataListener();
    protected static final String folderName = "unlock_schematics";
    protected Optional<Runnable> syncDataOnReload = Optional.empty();

    public static void read(IResourceManager manager) {
        Schematics.SCHEMATIC_REGISTRY.clear();
        Tardis.LOGGER.info("Beginning loading of data for data loader: {}", (Object)folderName);
        for (ResourceLocation loc : manager.func_199003_a(folderName, str -> str.endsWith(".json"))) {
            try {
                JsonObject root = new JsonParser().parse((Reader)new InputStreamReader(manager.func_199002_a(loc).func_199027_b())).getAsJsonObject();
                ResourceLocation type = new ResourceLocation(root.get("type").getAsString());
                SchematicType schematicType = (SchematicType)SchematicTypes.REGISTRY.get().getValue(type);
                if (schematicType != null) {
                    ResourceLocation key = SchematicDataListener.stripResourceLocation(loc);
                    Schematic schematic = schematicType.deserialize(root);
                    schematic.setId(key);
                    Schematics.SCHEMATIC_REGISTRY.put(key, schematic);
                    Tardis.LOGGER.info("Added schematic: {}", (Object)key);
                    continue;
                }
                Tardis.LOGGER.log(Level.ERROR, String.format("No SchematicType called %s!", type));
            }
            catch (Exception e) {
                Tardis.LOGGER.log(Level.ERROR, String.format("Invalid json for schematic %s!", loc));
                Tardis.LOGGER.catching(Level.ERROR, (Throwable)e);
            }
        }
        Tardis.LOGGER.info("Data loader for {} loaded {} entries", (Object)folderName, (Object)Schematics.SCHEMATIC_REGISTRY.size());
    }

    public static ResourceLocation stripResourceLocation(ResourceLocation loc) {
        return new ResourceLocation(loc.func_110624_b(), loc.func_110623_a().replace("unlock_schematics/", "").replace(".json", ""));
    }

    protected Map<ResourceLocation, Schematic> prepare(IResourceManager resourceManager, IProfiler profilerIn) {
        SchematicDataListener.read(resourceManager);
        Map<ResourceLocation, Schematic> map = Schematics.SCHEMATIC_REGISTRY;
        return map;
    }

    protected void apply(Map<ResourceLocation, Schematic> objects, IResourceManager resourceManagerIn, IProfiler profilerIn) {
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            this.syncDataOnReload.ifPresent(Runnable::run);
        }
    }

    public <PACKET> IFutureReloadListener subscribeAsSyncable(SimpleChannel channel, Function<Map<ResourceLocation, Schematic>, PACKET> packetFactory) {
        MinecraftForge.EVENT_BUS.addListener(this.getLoginListener(channel, packetFactory));
        this.syncDataOnReload = Optional.of(() -> channel.send(PacketDistributor.ALL.noArg(), packetFactory.apply(Schematics.SCHEMATIC_REGISTRY)));
        return this;
    }

    private <PACKET> Consumer<PlayerEvent.PlayerLoggedInEvent> getLoginListener(SimpleChannel channel, Function<Map<ResourceLocation, Schematic>, PACKET> packetFactory) {
        return event -> {
            PlayerEntity player = event.getPlayer();
            if (player instanceof ServerPlayerEntity) {
                channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), packetFactory.apply(Schematics.SCHEMATIC_REGISTRY));
            }
        };
    }
}

