/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.schematics;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;
import net.tardis.mod.registries.SchematicTypes;
import net.tardis.mod.schematics.types.SchematicType;
import net.tardis.mod.tileentities.ConsoleTile;

public abstract class Schematic {
    protected ResourceLocation key;
    private SchematicType type;
    private String displayName = "";
    private TranslationTextComponent translatedName = null;
    private boolean usesTranslatedName = false;

    public Schematic(SchematicType type) {
        this.type = type;
    }

    public abstract boolean onConsumedByTARDIS(ConsoleTile var1, PlayerEntity var2);

    public ResourceLocation getId() {
        return this.key;
    }

    public Schematic setId(ResourceLocation key) {
        this.key = key;
        return this;
    }

    public SchematicType getType() {
        return this.type;
    }

    public String getDisplayName() {
        if (this.translatedName != null && this.usesTranslatedName) {
            return this.translatedName.getString();
        }
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
        this.usesTranslatedName = false;
    }

    public void setTranslation(String translationKey) {
        this.translatedName = new TranslationTextComponent(translationKey);
        this.usesTranslatedName = true;
    }

    public boolean isUsingTranslatedName() {
        return this.usesTranslatedName;
    }

    public void setUseTranslatedName(boolean isTranslated) {
        this.usesTranslatedName = isTranslated;
    }

    public static void encodeToPacket(Map<ResourceLocation, Schematic> inputData, PacketBuffer buffer) {
        buffer.writeInt(inputData.size());
        for (Schematic schematic : inputData.values()) {
            buffer.func_192572_a(schematic.getType().getRegistryName());
            schematic = schematic.getType().serialize(schematic, buffer);
            buffer.func_192572_a(schematic.getId());
            buffer.writeBoolean(schematic.isUsingTranslatedName());
            buffer.func_180714_a(schematic.getDisplayName());
        }
    }

    public static Map<ResourceLocation, Schematic> decodeFromPacket(PacketBuffer buffer) {
        HashMap<ResourceLocation, Schematic> schematics = new HashMap<ResourceLocation, Schematic>();
        int schematicSize = buffer.readInt();
        for (int i = 0; i < schematicSize; ++i) {
            SchematicType type = (SchematicType)SchematicTypes.REGISTRY.get().getValue(buffer.func_192575_l());
            Schematic schematic = type.deserialize(buffer);
            ResourceLocation schematicID = buffer.func_192575_l();
            schematic.setId(schematicID);
            schematic.setUseTranslatedName(buffer.readBoolean());
            if (schematic.isUsingTranslatedName()) {
                schematic.setDisplayName(buffer.func_150789_c(Short.MAX_VALUE));
            } else {
                schematic.setTranslation(buffer.func_150789_c(Short.MAX_VALUE));
            }
            schematics.put(schematicID, schematic);
        }
        return schematics;
    }
}

