/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.schematics;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.tardis.mod.Tardis;
import net.tardis.mod.ars.ConsoleRoom;
import net.tardis.mod.registries.SchematicTypes;
import net.tardis.mod.schematics.Schematic;
import net.tardis.mod.schematics.types.SchematicType;
import net.tardis.mod.tileentities.ConsoleTile;
import org.apache.logging.log4j.Level;

public class InteriorUnlockSchematic
extends Schematic {
    private ResourceLocation consoleRoom;

    public InteriorUnlockSchematic() {
        super((SchematicType)SchematicTypes.INTERIOR.get());
    }

    public InteriorUnlockSchematic(SchematicType type) {
        super(type);
    }

    public void setConsoleRoom(ResourceLocation loc) {
        this.consoleRoom = loc;
    }

    public ResourceLocation getConsoleRoom() {
        return this.consoleRoom;
    }

    @Override
    public boolean onConsumedByTARDIS(ConsoleTile tile, PlayerEntity entity) {
        ConsoleRoom interior = this.getRoomObject();
        if (interior != null) {
            if (!tile.getUnlockManager().getUnlockedConsoleRooms().contains(interior)) {
                tile.getUnlockManager().addConsoleRoom(interior);
                entity.func_146105_b((ITextComponent)new TranslationTextComponent("message.tardis.interior.unlock", new Object[]{interior.getDisplayName().getString()}), true);
                return true;
            }
            entity.func_146105_b((ITextComponent)new TranslationTextComponent("message.tardis.existing_unlock", new Object[]{this.getDisplayName()}), true);
            return false;
        }
        Tardis.LOGGER.log(Level.ERROR, String.format("Error in interior schematic %s! %s is not a valid interior!", new Object[0]), (Object)this.getId().toString(), (Object)this.consoleRoom.toString());
        return false;
    }

    public ConsoleRoom getRoomObject() {
        return ConsoleRoom.getRegistry().get(this.consoleRoom);
    }
}

