/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.schematics;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.tardis.mod.Tardis;
import net.tardis.mod.exterior.AbstractExterior;
import net.tardis.mod.registries.ExteriorRegistry;
import net.tardis.mod.registries.SchematicTypes;
import net.tardis.mod.schematics.Schematic;
import net.tardis.mod.schematics.types.SchematicType;
import net.tardis.mod.tileentities.ConsoleTile;
import org.apache.logging.log4j.Level;

public class ExteriorUnlockSchematic
extends Schematic {
    private ResourceLocation exterior;

    public ExteriorUnlockSchematic() {
        super((SchematicType)SchematicTypes.EXTERIOR.get());
    }

    public ExteriorUnlockSchematic(SchematicType type) {
        super(type);
    }

    public void setExterior(ResourceLocation loc) {
        this.exterior = loc;
    }

    public ResourceLocation getExterior() {
        return this.exterior;
    }

    @Override
    public boolean onConsumedByTARDIS(ConsoleTile tile, PlayerEntity entity) {
        AbstractExterior ext = ExteriorRegistry.getExterior(this.exterior);
        if (ext != null) {
            if (!tile.getUnlockManager().getUnlockedExteriors().contains((Object)ext)) {
                tile.getUnlockManager().addExterior(ext);
                entity.func_146105_b((ITextComponent)new TranslationTextComponent("message.tardis.exterior.unlock", new Object[]{ext.getDisplayName().getString()}), true);
                return true;
            }
            entity.func_146105_b((ITextComponent)new TranslationTextComponent("message.tardis.existing_unlock", new Object[]{this.getDisplayName()}), true);
            return false;
        }
        Tardis.LOGGER.log(Level.ERROR, String.format("Error in exterior schematic %s! %s is not a valid exterior!", new Object[0]), (Object)this.getId().toString(), (Object)this.exterior.toString());
        return false;
    }
}

