/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.schematics;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.tardis.mod.Tardis;
import net.tardis.mod.misc.Console;
import net.tardis.mod.registries.ConsoleRegistry;
import net.tardis.mod.registries.SchematicTypes;
import net.tardis.mod.schematics.Schematic;
import net.tardis.mod.schematics.types.SchematicType;
import net.tardis.mod.tileentities.ConsoleTile;
import org.apache.logging.log4j.Level;

public class ConsoleUnlockSchematic
extends Schematic {
    private ResourceLocation console;

    public ConsoleUnlockSchematic() {
        super((SchematicType)SchematicTypes.CONSOLE.get());
    }

    public ConsoleUnlockSchematic(SchematicType type) {
        super(type);
    }

    public void setConsole(ResourceLocation console) {
        this.console = console;
    }

    public ResourceLocation getConsole() {
        return this.console;
    }

    @Override
    public boolean onConsumedByTARDIS(ConsoleTile tile, PlayerEntity player) {
        Console console = (Console)ConsoleRegistry.CONSOLE_REGISTRY.get().getValue(this.console);
        if (console != null) {
            if (!tile.getUnlockManager().getUnlockedConsoles().contains((Object)console)) {
                tile.getUnlockManager().addConsole(console);
                player.func_146105_b((ITextComponent)new TranslationTextComponent("message.tardis.console.unlock", new Object[]{this.getDisplayName()}), true);
                return true;
            }
            player.func_146105_b((ITextComponent)new TranslationTextComponent("message.tardis.existing_unlock", new Object[]{this.getDisplayName()}), true);
            return false;
        }
        Tardis.LOGGER.log(Level.ERROR, String.format("Error in console schematic %s! %s is not a valid console!", new Object[0]), (Object)this.getId().toString(), (Object)this.console.toString());
        return false;
    }
}

