/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.registries;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.item.Item;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;
import net.tardis.mod.items.TItems;
import net.tardis.mod.subsystem.FlightSubsystem;
import net.tardis.mod.subsystem.ShieldGeneratorSubsystem;
import net.tardis.mod.subsystem.Subsystem;
import net.tardis.mod.subsystem.TemporalGraceSubsystem;
import net.tardis.mod.upgrades.AtriumUpgrade;
import net.tardis.mod.upgrades.ElectrolyticConvertersUpgrade;
import net.tardis.mod.upgrades.KeyFobUpgrade;
import net.tardis.mod.upgrades.StructureLocatorUpgrade;
import net.tardis.mod.upgrades.TimeLinkUpgrade;
import net.tardis.mod.upgrades.Upgrade;
import net.tardis.mod.upgrades.UpgradeEntry;
import net.tardis.mod.upgrades.ZeroRoomUpgrade;

public class UpgradeRegistry {
    public static final DeferredRegister<UpgradeEntry> UPGRADES = DeferredRegister.create(UpgradeEntry.class, (String)"tardis");
    public static Supplier<IForgeRegistry<UpgradeEntry>> UPGRADE_REGISTRY = UPGRADES.makeRegistry("upgrade", () -> new RegistryBuilder().setMaxID(0x7FFFFFFE));
    public static final RegistryObject<UpgradeEntry> ATRIUM = UPGRADES.register("atrium", () -> UpgradeRegistry.setupUpgrade(AtriumUpgrade::new, (Item)TItems.ATRIUM_UPGRADE.get(), FlightSubsystem.class));
    public static final RegistryObject<UpgradeEntry> ELECTRO_CONVERT = UPGRADES.register("electro_converters", () -> UpgradeRegistry.setupUpgrade(ElectrolyticConvertersUpgrade::new, (Item)TItems.ELECTRO_CONVERT_UPGRADE.get(), TemporalGraceSubsystem.class));
    public static final RegistryObject<UpgradeEntry> KEY_FOB = UPGRADES.register("key_fob", () -> UpgradeRegistry.setupUpgrade(KeyFobUpgrade::new, (Item)TItems.KEY_FOB_UPGRADE.get(), ShieldGeneratorSubsystem.class));
    public static final RegistryObject<UpgradeEntry> TIME_LINK = UPGRADES.register("time_link", () -> UpgradeRegistry.setupUpgrade(TimeLinkUpgrade::new, (Item)TItems.TIME_LINK_UPGRADE.get(), FlightSubsystem.class));
    public static final RegistryObject<UpgradeEntry> ZERO_ROOM = UPGRADES.register("zero_room", () -> UpgradeRegistry.setupUpgrade(ZeroRoomUpgrade::new, (Item)TItems.ZERO_ROOM_UPGRADE.get(), TemporalGraceSubsystem.class));
    public static final RegistryObject<UpgradeEntry> STRUCTURE = UPGRADES.register("structure", () -> UpgradeRegistry.setupUpgrade(StructureLocatorUpgrade::new, (Item)TItems.TELE_STRUCTURE_UPGRADE.get(), FlightSubsystem.class));

    public static UpgradeEntry setupUpgrade(UpgradeEntry.IConsoleSpawner<Upgrade> spawn, Item item, Class<? extends Subsystem> sys) {
        UpgradeEntry entry = new UpgradeEntry(spawn, item, sys);
        return entry;
    }

    public static UpgradeEntry getUpgradeFromItem(Item item) {
        UpgradeEntry foundEntry = null;
        ArrayList upgrades = Lists.newArrayList((Iterable)UPGRADE_REGISTRY.get().getValues());
        for (UpgradeEntry entry : upgrades) {
            if (item == null || entry.getItem() != item) continue;
            foundEntry = entry;
        }
        return foundEntry;
    }
}

