/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.registries;

import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;
import net.tardis.mod.misc.rng.RarityPool;
import net.tardis.mod.traits.AgoraphobicTrait;
import net.tardis.mod.traits.ArachnophobiaTrait;
import net.tardis.mod.traits.ClaustrophobicTrait;
import net.tardis.mod.traits.ColdBloodedTrait;
import net.tardis.mod.traits.JealousTrait;
import net.tardis.mod.traits.MurderousTrait;
import net.tardis.mod.traits.PeaceTrait;
import net.tardis.mod.traits.PyroTrait;
import net.tardis.mod.traits.TardisTrait;
import net.tardis.mod.traits.TardisTraitType;
import net.tardis.mod.traits.WetTrait;

public class TraitRegistry {
    public static final RarityPool<TardisTraitType> RARITIES = new RarityPool();
    public static final DeferredRegister<TardisTraitType> TRAITS = DeferredRegister.create(TardisTraitType.class, (String)"tardis");
    public static Supplier<IForgeRegistry<TardisTraitType>> TRAIT_REGISTRY = TRAITS.makeRegistry("trait", () -> new RegistryBuilder().setMaxID(0x7FFFFFFE));
    public static final RegistryObject<TardisTraitType> MURDEROUS = TRAITS.register("murderous", () -> TraitRegistry.setupTrait(MurderousTrait::new, test -> test.getTraitClass() == PeaceTrait.class));
    public static final RegistryObject<TardisTraitType> PEACEFUL = TRAITS.register("peaceful", () -> TraitRegistry.setupTrait(PeaceTrait::new, test -> test.getTraitClass() == MurderousTrait.class));
    public static final RegistryObject<TardisTraitType> WET = TRAITS.register("wet", () -> TraitRegistry.setupTrait(WetTrait::new));
    public static final RegistryObject<TardisTraitType> ARACHOPHOBIA = TRAITS.register("arachnophobia", () -> TraitRegistry.setupTrait(ArachnophobiaTrait::new));
    public static final RegistryObject<TardisTraitType> PYRO = TRAITS.register("pyro", () -> TraitRegistry.setupTrait(PyroTrait::new));
    public static final RegistryObject<TardisTraitType> COLDBLOODED = TRAITS.register("cold_blood", () -> TraitRegistry.setupTrait(ColdBloodedTrait::new));
    public static final RegistryObject<TardisTraitType> JEALOUS = TRAITS.register("jealous", () -> TraitRegistry.setupTrait(JealousTrait::new));
    public static final RegistryObject<TardisTraitType> CLAUSTROPHOBIC = TRAITS.register("claustrophobic", () -> TraitRegistry.setupTrait(ClaustrophobicTrait::new, test -> test.getTraitClass() == AgoraphobicTrait.class));
    public static final RegistryObject<TardisTraitType> AGORAPHOBIC = TRAITS.register("agoraphobic", () -> TraitRegistry.setupTrait(AgoraphobicTrait::new, test -> test.getTraitClass() == ClaustrophobicTrait.class));

    public static TardisTraitType setupTrait(Function<TardisTraitType, TardisTrait> supplier, Predicate<TardisTraitType> test) {
        TardisTraitType type = new TardisTraitType(supplier, test);
        return type;
    }

    public static TardisTraitType setupTrait(Function<TardisTraitType, TardisTrait> supplier) {
        return TraitRegistry.setupTrait(supplier, test -> false);
    }

    public static void registerRarities() {
        RARITIES.addChance(50, (TardisTraitType)MURDEROUS.get());
    }
}

