/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.registries;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;
import net.tardis.mod.missions.DroneStationMission;
import net.tardis.mod.missions.MiniMission;
import net.tardis.mod.missions.MiniMissionType;
import net.tardis.mod.world.structures.TStructures;

public class MissionRegistry {
    public static final DeferredRegister<MiniMissionType> MISSIONS = DeferredRegister.create(MiniMissionType.class, (String)"tardis");
    public static Supplier<IForgeRegistry<MiniMissionType>> MISSION_REGISTRY = MISSIONS.makeRegistry("mission", () -> new RegistryBuilder().setMaxID(0x7FFFFFFE));
    public static final RegistryObject<MiniMissionType> STATION_DRONE = MISSIONS.register("drone_station", () -> MissionRegistry.registerMission(DroneStationMission::new, TStructures.ConfiguredStructures.SPACE_STATION_KEY));

    public static MiniMissionType registerMission(MiniMissionType.IMissionBuilder<MiniMission> builder, BiFunction<ServerWorld, BlockPos, BlockPos> spawner) {
        MiniMissionType type = new MiniMissionType(builder, spawner);
        return type;
    }

    public static MiniMissionType registerMission(MiniMissionType.IMissionBuilder<MiniMission> builder, RegistryKey<StructureFeature<?, ?>> structure) {
        MiniMissionType type = new MiniMissionType(builder, structure);
        return type;
    }

    public static MiniMissionType getRandomMissionType(Random rand) {
        ArrayList types = Lists.newArrayList((Iterable)MISSION_REGISTRY.get().getValues());
        return (MiniMissionType)((Object)types.get(rand.nextInt(types.size())));
    }
}

