/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.registries;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;
import net.tardis.mod.flight.BulkheadFlightEvent;
import net.tardis.mod.flight.CrashEvent;
import net.tardis.mod.flight.DimensionFlightEvent;
import net.tardis.mod.flight.DirectionalFlightEvent;
import net.tardis.mod.flight.FlightEvent;
import net.tardis.mod.flight.FlightEventFactory;
import net.tardis.mod.flight.RefuelerFlightEvent;
import net.tardis.mod.flight.ResidualArtronEvent;
import net.tardis.mod.flight.ScrapFlightEvent;
import net.tardis.mod.flight.TardisCollideInstigate;
import net.tardis.mod.flight.TardisCollideRecieve;
import net.tardis.mod.flight.TimeWindFlightEvent;
import net.tardis.mod.flight.VerticalFlightEvent;
import net.tardis.mod.misc.rng.RarityPool;
import net.tardis.mod.registries.ControlRegistry;

public class FlightEventRegistry {
    public static final RarityPool<FlightEventFactory> RANDOM_EVENTS = new RarityPool();
    public static final DeferredRegister<FlightEventFactory> FLIGHT_EVENTS = DeferredRegister.create(FlightEventFactory.class, (String)"tardis");
    public static Supplier<IForgeRegistry<FlightEventFactory>> FLIGHT_EVENT_REGISTRY = FLIGHT_EVENTS.makeRegistry("flight_event", () -> new RegistryBuilder().setMaxID(0x7FFFFFFE));
    public static final RegistryObject<FlightEventFactory> SCRAP = FLIGHT_EVENTS.register("scrap", () -> FlightEventRegistry.setupFlightEvent(ScrapFlightEvent::new, () -> Lists.newArrayList((Object[])new ResourceLocation[]{((ControlRegistry.ControlEntry)ControlRegistry.RANDOM.get()).getRegistryName(), ((ControlRegistry.ControlEntry)ControlRegistry.FACING.get()).getRegistryName()})));
    public static final RegistryObject<FlightEventFactory> X = FLIGHT_EVENTS.register("x", () -> FlightEventRegistry.setupFlightEvent((entry, keys) -> new DirectionalFlightEvent(entry, Direction.Axis.X, keys), () -> Lists.newArrayList((Object[])new ResourceLocation[]{((ControlRegistry.ControlEntry)ControlRegistry.X.get()).getRegistryName()})));
    public static final RegistryObject<FlightEventFactory> Y = FLIGHT_EVENTS.register("y", () -> FlightEventRegistry.setupFlightEvent((entry, keys) -> new DirectionalFlightEvent(entry, Direction.Axis.Y, keys), () -> Lists.newArrayList((Object[])new ResourceLocation[]{((ControlRegistry.ControlEntry)ControlRegistry.Y.get()).getRegistryName()})));
    public static final RegistryObject<FlightEventFactory> Z = FLIGHT_EVENTS.register("z", () -> FlightEventRegistry.setupFlightEvent((entry, keys) -> new DirectionalFlightEvent(entry, Direction.Axis.Z, keys), () -> Lists.newArrayList((Object[])new ResourceLocation[]{((ControlRegistry.ControlEntry)ControlRegistry.Z.get()).getRegistryName()})));
    public static final RegistryObject<FlightEventFactory> TIMEWIND = FLIGHT_EVENTS.register("time_wind", () -> FlightEventRegistry.setupFlightEvent(TimeWindFlightEvent::new, () -> Lists.newArrayList((Object[])new ResourceLocation[]{((ControlRegistry.ControlEntry)ControlRegistry.THROTTLE.get()).getRegistryName()})));
    public static final RegistryObject<FlightEventFactory> BULKHEAD = FLIGHT_EVENTS.register("bulkhead", () -> FlightEventRegistry.setupFlightEvent(BulkheadFlightEvent::new, () -> Lists.newArrayList((Object[])new ResourceLocation[]{((ControlRegistry.ControlEntry)ControlRegistry.DOOR.get()).getRegistryName()})));
    public static final RegistryObject<FlightEventFactory> REFUELER = FLIGHT_EVENTS.register("refueler", () -> FlightEventRegistry.setupFlightEvent(RefuelerFlightEvent::new, () -> Lists.newArrayList((Object[])new ResourceLocation[]{((ControlRegistry.ControlEntry)ControlRegistry.REFUELER.get()).getRegistryName()})));
    public static final RegistryObject<FlightEventFactory> DIMENSION = FLIGHT_EVENTS.register("dimension", () -> FlightEventRegistry.setupFlightEvent(DimensionFlightEvent::new, () -> Lists.newArrayList((Object[])new ResourceLocation[]{((ControlRegistry.ControlEntry)ControlRegistry.DIMENSION.get()).getRegistryName()})));
    public static final RegistryObject<FlightEventFactory> VERTICAL = FLIGHT_EVENTS.register("vertical", () -> FlightEventRegistry.setupFlightEvent(VerticalFlightEvent::new, () -> Lists.newArrayList((Object[])new ResourceLocation[]{((ControlRegistry.ControlEntry)ControlRegistry.LAND_TYPE.get()).getRegistryName()})));
    public static final RegistryObject<FlightEventFactory> COLLIDE_INSTIGATE = FLIGHT_EVENTS.register("collide_instigate", () -> FlightEventRegistry.setupFlightEvent(TardisCollideInstigate::new, TardisCollideInstigate.CONTROLS, false));
    public static final RegistryObject<FlightEventFactory> COLLIDE_RECIEVE = FLIGHT_EVENTS.register("collide_recieve", () -> FlightEventRegistry.setupFlightEvent(TardisCollideRecieve::new, TardisCollideRecieve.CONTROLS, false));
    public static final RegistryObject<FlightEventFactory> CRASH_EVENT = FLIGHT_EVENTS.register("crash", () -> FlightEventRegistry.setupFlightEvent(CrashEvent::new, CrashEvent.CONTROLS, false));
    public static final RegistryObject<FlightEventFactory> RESIDUAL_ARTRON = FLIGHT_EVENTS.register("residual_artron", () -> FlightEventRegistry.setupFlightEvent(ResidualArtronEvent::new, () -> Lists.newArrayList((Object[])new ResourceLocation[]{((ControlRegistry.ControlEntry)ControlRegistry.REFUELER.get()).getRegistryName(), ((ControlRegistry.ControlEntry)ControlRegistry.FACING.get()).getRegistryName()})));

    @Nullable
    public static FlightEventFactory getRandomEvent(Random r) {
        return RANDOM_EVENTS.chooseRandom(r);
    }

    public static FlightEventFactory setupFlightEvent(FlightEventFactory.IFlightEventFactory<FlightEvent> event, Supplier<ArrayList<ResourceLocation>> sequence) {
        FlightEventFactory fact = new FlightEventFactory(event, sequence);
        return fact;
    }

    public static FlightEventFactory setupFlightEvent(FlightEventFactory.IFlightEventFactory<FlightEvent> event, Supplier<ArrayList<ResourceLocation>> sequence, boolean normal) {
        FlightEventFactory fact = FlightEventRegistry.setupFlightEvent(event, sequence);
        fact.setNormal(false);
        return fact;
    }

    public static void addRandomEvent(int weight, FlightEventFactory event) {
        RANDOM_EVENTS.addChance(weight, event);
    }

    public static void registerRandomEntries() {
        FlightEventRegistry.addRandomEvent(25, (FlightEventFactory)X.get());
        FlightEventRegistry.addRandomEvent(25, (FlightEventFactory)Y.get());
        FlightEventRegistry.addRandomEvent(25, (FlightEventFactory)Z.get());
        FlightEventRegistry.addRandomEvent(20, (FlightEventFactory)VERTICAL.get());
        FlightEventRegistry.addRandomEvent(20, (FlightEventFactory)TIMEWIND.get());
        FlightEventRegistry.addRandomEvent(10, (FlightEventFactory)REFUELER.get());
        FlightEventRegistry.addRandomEvent(10, (FlightEventFactory)BULKHEAD.get());
        FlightEventRegistry.addRandomEvent(10, (FlightEventFactory)SCRAP.get());
        FlightEventRegistry.addRandomEvent(10, (FlightEventFactory)DIMENSION.get());
        FlightEventRegistry.addRandomEvent(5, (FlightEventFactory)RESIDUAL_ARTRON.get());
    }
}

