/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.registries;

import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;
import net.tardis.mod.blocks.TBlocks;
import net.tardis.mod.exterior.AbstractExterior;
import net.tardis.mod.exterior.DisguiseExterior;
import net.tardis.mod.exterior.TwoBlockBasicExterior;
import net.tardis.mod.misc.DoorSounds;
import net.tardis.mod.misc.IDoorType;
import net.tardis.mod.texturevariants.TextureVariants;

public class ExteriorRegistry {
    public static final DeferredRegister<AbstractExterior> EXTERIORS = DeferredRegister.create(AbstractExterior.class, (String)"tardis");
    public static Supplier<IForgeRegistry<AbstractExterior>> EXTERIOR_REGISTRY = EXTERIORS.makeRegistry("exterior", () -> new RegistryBuilder().setMaxID(0x7FFFFFFE));
    public static final RegistryObject<AbstractExterior> STEAMPUNK = EXTERIORS.register("steampunk", () -> new TwoBlockBasicExterior(() -> ((Block)TBlocks.exterior_steampunk.get()).func_176223_P(), false, IDoorType.EnumDoorType.STEAM, DoorSounds.BASE, new ResourceLocation("tardis", "textures/gui/exteriors/steam.png"), TextureVariants.STEAM));
    public static final RegistryObject<AbstractExterior> TRUNK = EXTERIORS.register("trunk", () -> new TwoBlockBasicExterior(() -> ((Block)TBlocks.exterior_trunk.get()).func_176223_P(), false, IDoorType.EnumDoorType.TRUNK, DoorSounds.WOOD, new ResourceLocation("tardis", "textures/gui/exteriors/trunk.png"), TextureVariants.TRUNK));
    public static final RegistryObject<AbstractExterior> TELEPHONE = EXTERIORS.register("telephone", () -> new TwoBlockBasicExterior(() -> ((Block)TBlocks.exterior_telephone.get()).func_176223_P(), false, IDoorType.EnumDoorType.TELEPHONE, DoorSounds.BASE, new ResourceLocation("tardis", "textures/gui/exteriors/telephone_red.png"), TextureVariants.TELEPHONE));
    public static final RegistryObject<AbstractExterior> FORTUNE = EXTERIORS.register("fortune", () -> new TwoBlockBasicExterior(() -> ((Block)TBlocks.exterior_fortune.get()).func_176223_P(), false, IDoorType.EnumDoorType.FORTUNE, DoorSounds.WOOD, new ResourceLocation("tardis", "textures/gui/exteriors/fortune.png"), TextureVariants.FORTUNE));
    public static final RegistryObject<AbstractExterior> SAFE = EXTERIORS.register("safe", () -> new TwoBlockBasicExterior(() -> ((Block)TBlocks.exterior_safe.get()).func_176223_P(), false, IDoorType.EnumDoorType.SAFE, DoorSounds.BASE, new ResourceLocation("tardis", "textures/gui/exteriors/safe.png")));
    public static final RegistryObject<AbstractExterior> TT_CAPSULE = EXTERIORS.register("tt_capsule", () -> new TwoBlockBasicExterior(() -> ((Block)TBlocks.exterior_tt_capsule.get()).func_176223_P(), false, IDoorType.EnumDoorType.TT_CAPSULE, DoorSounds.BASE, new ResourceLocation("tardis", "textures/gui/exteriors/tt_capsule.png")));
    public static final RegistryObject<AbstractExterior> CLOCK = EXTERIORS.register("clock", () -> new TwoBlockBasicExterior(() -> ((Block)TBlocks.exterior_clock.get()).func_176223_P(), false, IDoorType.EnumDoorType.CLOCK, DoorSounds.WOOD, new ResourceLocation("tardis", "textures/gui/exteriors/clock.png")));
    public static final RegistryObject<AbstractExterior> TT_2020 = EXTERIORS.register("tt_2020", () -> new TwoBlockBasicExterior(() -> ((Block)TBlocks.exterior_tt2020.get()).func_176223_P(), false, IDoorType.EnumDoorType.TT_2020_CAPSULE, DoorSounds.BASE, new ResourceLocation("tardis", "textures/gui/exteriors/tt_2020.png")));
    public static final RegistryObject<AbstractExterior> BOKKUSU = EXTERIORS.register("bokkusu", () -> new TwoBlockBasicExterior(() -> ((Block)TBlocks.exterior_japan.get()).func_176223_P(), false, IDoorType.EnumDoorType.JAPAN, DoorSounds.BASE, new ResourceLocation("tardis", "textures/gui/exteriors/bokkusu.png")));
    public static final RegistryObject<AbstractExterior> APERTURE = EXTERIORS.register("aperture", () -> new TwoBlockBasicExterior(() -> ((Block)TBlocks.exterior_aperture.get()).func_176223_P(), false, IDoorType.EnumDoorType.APERTURE, DoorSounds.BASE, new ResourceLocation("tardis", "textures/gui/exteriors/aperture.png")));
    public static final RegistryObject<AbstractExterior> POLICE_BOX = EXTERIORS.register("police_box", () -> new TwoBlockBasicExterior(() -> ((Block)TBlocks.exterior_police_box.get()).func_176223_P(), false, IDoorType.EnumDoorType.POLICE_BOX, DoorSounds.BASE, new ResourceLocation("tardis", "textures/gui/exteriors/police_box.png")));
    public static final RegistryObject<AbstractExterior> MODERN_POLICE_BOX = EXTERIORS.register("modern_police_box", () -> new TwoBlockBasicExterior(() -> ((Block)TBlocks.exterior_modern_police_box.get()).func_176223_P(), false, IDoorType.EnumDoorType.MODERN_POLICE_BOX, DoorSounds.BASE, new ResourceLocation("tardis", "textures/gui/exteriors/new_who.png")));
    public static final RegistryObject<AbstractExterior> DISGUISE = EXTERIORS.register("disguise", () -> new DisguiseExterior(() -> ((Block)TBlocks.exterior_disguise.get()).func_176223_P(), true, IDoorType.EnumDoorType.TT_CAPSULE, new ResourceLocation("tardis", "textures/gui/disguise.png")));

    public static AbstractExterior getExterior(ResourceLocation key) {
        return (AbstractExterior)EXTERIOR_REGISTRY.get().getValue(key);
    }

    public static ArrayList<AbstractExterior> getDefaultExteriors() {
        ArrayList<AbstractExterior> list = new ArrayList<AbstractExterior>();
        for (AbstractExterior ext : EXTERIOR_REGISTRY.get().getValues()) {
            if (!ext.isUnlockedByDefault()) continue;
            list.add(ext);
        }
        return list;
    }
}

