/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.registries;

import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.SixWayBlock;
import net.minecraft.state.Property;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;
import net.tardis.mod.blocks.TBlocks;
import net.tardis.mod.misc.Disguise;
import net.tardis.mod.world.dimensions.TDimensions;

public class DisguiseRegistry {
    public static final DeferredRegister<Disguise> DISGUISES = DeferredRegister.create(Disguise.class, (String)"tardis");
    public static Supplier<IForgeRegistry<Disguise>> DISGUISE_REGISTRY = DISGUISES.makeRegistry("disguise", () -> new RegistryBuilder().setMaxID(0x7FFFFFFE));
    public static BiFunction<World, BlockPos, Boolean> DEFAULT_TREE_CRITERON = (world, pos) -> world.func_175710_j(pos);
    public static BiFunction<World, BlockPos, Boolean> coral_criteron = (world, pos) -> world.func_242406_i(pos) == Optional.of(Biomes.field_203614_T);
    public static BiFunction<World, BlockPos, Boolean> nether = (world, pos) -> world.func_234923_W_() == World.field_234919_h_;
    public static BiFunction<World, BlockPos, Boolean> END = (world, pos) -> world.func_234923_W_() == World.field_234920_i_;
    public static BiFunction<World, BlockPos, Boolean> MOON_CRITERON = (world, pos) -> world.func_234923_W_().func_240901_a_().equals((Object)TDimensions.MOON_DIM.getRegistryName());
    public static BiFunction<World, BlockPos, Boolean> DESERT_VILLAGE_CRITERION = (world, pos) -> {
        if (!world.func_201670_d()) {
            ServerWorld serverWorld = (ServerWorld)world;
            RegistryKey structureKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_243553_av, (ResourceLocation)new ResourceLocation("village_desert"));
            Structure structureToSearch = ((StructureFeature)serverWorld.func_73046_m().func_244267_aX().func_243612_b((RegistryKey)Registry.field_243553_av).func_243576_d((RegistryKey)structureKey)).field_236268_b_;
            BlockPos villagePos = serverWorld.func_241117_a_(structureToSearch, pos, 1, false);
            return world.func_226691_t_(pos).func_201856_r() == Biome.Category.DESERT && villagePos != null;
        }
        return false;
    };
    public static BiFunction<World, BlockPos, Boolean> PLAINS_VILLAGE_CRITERION = (world, pos) -> {
        if (!world.func_201670_d()) {
            ServerWorld serverWorld = (ServerWorld)world;
            RegistryKey structureKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_243553_av, (ResourceLocation)new ResourceLocation("village_plains"));
            Structure structureToSearch = ((StructureFeature)serverWorld.func_73046_m().func_244267_aX().func_243612_b((RegistryKey)Registry.field_243553_av).func_243576_d((RegistryKey)structureKey)).field_236268_b_;
            BlockPos villagePos = serverWorld.func_241117_a_(structureToSearch, pos, 1, false);
            return world.func_226691_t_(pos).func_201856_r() == Biome.Category.PLAINS && villagePos != null;
        }
        return false;
    };
    public static BiFunction<World, BlockPos, Boolean> SAVANNA_VILLAGE_CRITERION = (world, pos) -> {
        if (!world.func_201670_d()) {
            ServerWorld serverWorld = (ServerWorld)world;
            RegistryKey structureKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_243553_av, (ResourceLocation)new ResourceLocation("village_savanna"));
            Structure structureToSearch = ((StructureFeature)serverWorld.func_73046_m().func_244267_aX().func_243612_b((RegistryKey)Registry.field_243553_av).func_243576_d((RegistryKey)structureKey)).field_236268_b_;
            BlockPos villagePos = serverWorld.func_241117_a_(structureToSearch, pos, 1, false);
            return world.func_226691_t_(pos).func_201856_r() == Biome.Category.SAVANNA && villagePos != null;
        }
        return false;
    };
    public static BiFunction<World, BlockPos, Boolean> TAIGA_VILLAGE_CRITERION = (world, pos) -> {
        if (!world.func_201670_d()) {
            ServerWorld serverWorld = (ServerWorld)world;
            RegistryKey structureKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_243553_av, (ResourceLocation)new ResourceLocation("village_taiga"));
            Structure structureToSearch = ((StructureFeature)serverWorld.func_73046_m().func_244267_aX().func_243612_b((RegistryKey)Registry.field_243553_av).func_243576_d((RegistryKey)structureKey)).field_236268_b_;
            BlockPos villagePos = serverWorld.func_241117_a_(structureToSearch, pos, 1, false);
            return world.func_226691_t_(pos).func_201856_r() == Biome.Category.TAIGA && villagePos != null;
        }
        return false;
    };
    public static BiFunction<World, BlockPos, Boolean> SNOWY_VILLAGE_CRITERION = (world, pos) -> {
        if (!world.func_201670_d()) {
            ServerWorld serverWorld = (ServerWorld)world;
            RegistryKey structureKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_243553_av, (ResourceLocation)new ResourceLocation("village_snowy"));
            Structure structureToSearch = ((StructureFeature)serverWorld.func_73046_m().func_244267_aX().func_243612_b((RegistryKey)Registry.field_243553_av).func_243576_d((RegistryKey)structureKey)).field_236268_b_;
            BlockPos villagePos = serverWorld.func_241117_a_(structureToSearch, pos, 1, false);
            return world.func_226691_t_(pos).func_201856_r() == Biome.Category.ICY && villagePos != null;
        }
        return false;
    };
    public static final RegistryObject<Disguise> DESERT_LIBRARY_1 = DISGUISES.register("desert_library_1", () -> DisguiseRegistry.createDisguise(new Disguise(() -> ((Block)TBlocks.exterior_disguise.get()).func_176223_P(), () -> ((Block)TBlocks.bottom_exterior.get()).func_176223_P()), (world, pos) -> DESERT_VILLAGE_CRITERION.apply((World)world, (BlockPos)pos)));
    public static final RegistryObject<Disguise> DESERT_SMALL_HOUSE_3 = DISGUISES.register("desert_small_house_3", () -> DisguiseRegistry.createDisguise(new Disguise(() -> ((Block)TBlocks.exterior_disguise.get()).func_176223_P(), () -> ((Block)TBlocks.bottom_exterior.get()).func_176223_P()), (world, pos) -> DESERT_VILLAGE_CRITERION.apply((World)world, (BlockPos)pos)));
    public static final RegistryObject<Disguise> DESERT_MEDIUM_HOUSE_1 = DISGUISES.register("desert_medium_house_1", () -> DisguiseRegistry.createDisguise(new Disguise(() -> ((Block)TBlocks.exterior_disguise.get()).func_176223_P(), () -> ((Block)TBlocks.bottom_exterior.get()).func_176223_P()), (world, pos) -> DESERT_VILLAGE_CRITERION.apply((World)world, (BlockPos)pos)));
    public static final RegistryObject<Disguise> PLAINS_LIBRARY_1 = DISGUISES.register("plains_library_1", () -> DisguiseRegistry.createDisguise(new Disguise(() -> ((Block)TBlocks.exterior_disguise.get()).func_176223_P(), () -> ((Block)TBlocks.bottom_exterior.get()).func_176223_P()), (world, pos) -> PLAINS_VILLAGE_CRITERION.apply((World)world, (BlockPos)pos)));
    public static final RegistryObject<Disguise> PLAINS_SMALL_HOUSE_3 = DISGUISES.register("plains_small_house_3", () -> DisguiseRegistry.createDisguise(new Disguise(() -> (BlockState)Blocks.field_180413_ao.func_176223_P().func_206870_a((Property)DoorBlock.field_176523_O, (Comparable)DoubleBlockHalf.UPPER), () -> Blocks.field_180413_ao.func_176223_P()), (world, pos) -> PLAINS_VILLAGE_CRITERION.apply((World)world, (BlockPos)pos)));
    public static final RegistryObject<Disguise> PLAINS_MEDIUM_HOUSE_1 = DISGUISES.register("plains_medium_house_1", () -> DisguiseRegistry.createDisguise(new Disguise(() -> ((Block)TBlocks.exterior_disguise.get()).func_176223_P(), () -> ((Block)TBlocks.bottom_exterior.get()).func_176223_P()), (world, pos) -> PLAINS_VILLAGE_CRITERION.apply((World)world, (BlockPos)pos)));
    public static final RegistryObject<Disguise> SAVANNA_LARGE_FARM_1 = DISGUISES.register("savanna_large_farm_1", () -> DisguiseRegistry.createDisguise(new Disguise(() -> ((Block)TBlocks.exterior_disguise.get()).func_176223_P(), () -> ((Block)TBlocks.bottom_exterior.get()).func_176223_P()), (world, pos) -> SAVANNA_VILLAGE_CRITERION.apply((World)world, (BlockPos)pos)));
    public static final RegistryObject<Disguise> SAVANNA_SMALL_HOUSE_3 = DISGUISES.register("savanna_small_house_3", () -> DisguiseRegistry.createDisguise(new Disguise(() -> (BlockState)Blocks.field_180410_as.func_176223_P().func_206870_a((Property)DoorBlock.field_176523_O, (Comparable)DoubleBlockHalf.UPPER), () -> Blocks.field_180410_as.func_176223_P()), (world, pos) -> SAVANNA_VILLAGE_CRITERION.apply((World)world, (BlockPos)pos)));
    public static final RegistryObject<Disguise> SAVANNA_MEDIUM_HOUSE_1 = DISGUISES.register("savanna_medium_house_1", () -> DisguiseRegistry.createDisguise(new Disguise(() -> ((Block)TBlocks.exterior_disguise.get()).func_176223_P(), () -> ((Block)TBlocks.bottom_exterior.get()).func_176223_P()), (world, pos) -> SAVANNA_VILLAGE_CRITERION.apply((World)world, (BlockPos)pos)));
    public static final RegistryObject<Disguise> TAIGA_LIBRARY_1 = DISGUISES.register("taiga_library_1", () -> DisguiseRegistry.createDisguise(new Disguise(() -> Blocks.field_150347_e.func_176223_P(), () -> Blocks.field_150347_e.func_176223_P()), (world, pos) -> TAIGA_VILLAGE_CRITERION.apply((World)world, (BlockPos)pos)));
    public static final RegistryObject<Disguise> TAIGA_SMALL_HOUSE_3 = DISGUISES.register("taiga_small_house_3", () -> DisguiseRegistry.createDisguise(new Disguise(() -> (BlockState)Blocks.field_180414_ap.func_176223_P().func_206870_a((Property)DoorBlock.field_176523_O, (Comparable)DoubleBlockHalf.UPPER), () -> Blocks.field_180414_ap.func_176223_P()), (world, pos) -> TAIGA_VILLAGE_CRITERION.apply((World)world, (BlockPos)pos)));
    public static final RegistryObject<Disguise> TAIGA_WEAPONSMITH_1 = DISGUISES.register("taiga_weaponsmith_1", () -> DisguiseRegistry.createDisguise(new Disguise(() -> ((Block)TBlocks.exterior_disguise.get()).func_176223_P(), () -> ((Block)TBlocks.bottom_exterior.get()).func_176223_P()), (world, pos) -> TAIGA_VILLAGE_CRITERION.apply((World)world, (BlockPos)pos)));
    public static final RegistryObject<Disguise> SNOWY_MEETING_POINT_3 = DISGUISES.register("snowy_meeting_point_3", () -> DisguiseRegistry.createDisguise(new Disguise(() -> ((Block)TBlocks.exterior_disguise.get()).func_176223_P(), () -> ((Block)TBlocks.bottom_exterior.get()).func_176223_P()), (world, pos) -> SNOWY_VILLAGE_CRITERION.apply((World)world, (BlockPos)pos)));
    public static final RegistryObject<Disguise> SNOWY_SMALL_HOUSE_3 = DISGUISES.register("snowy_small_house_3", () -> DisguiseRegistry.createDisguise(new Disguise(() -> (BlockState)Blocks.field_180414_ap.func_176223_P().func_206870_a((Property)DoorBlock.field_176523_O, (Comparable)DoubleBlockHalf.UPPER), () -> Blocks.field_180414_ap.func_176223_P()), (world, pos) -> SNOWY_VILLAGE_CRITERION.apply((World)world, (BlockPos)pos)));
    public static final RegistryObject<Disguise> SNOWY_FARM_1 = DISGUISES.register("snowy_farm_1", () -> DisguiseRegistry.createDisguise(new Disguise(() -> ((Block)TBlocks.exterior_disguise.get()).func_176223_P(), () -> Blocks.field_222436_lZ.func_176223_P()), (world, pos) -> SNOWY_VILLAGE_CRITERION.apply((World)world, (BlockPos)pos)));
    public static final RegistryObject<Disguise> STONE_PILLAR = DISGUISES.register("stone", () -> DisguiseRegistry.createDisguise(new Disguise(() -> Blocks.field_150348_b.func_176223_P()), (world, pos) -> false));
    public static final RegistryObject<Disguise> OAK_TREE = DISGUISES.register("oak_tree", () -> DisguiseRegistry.createDisguise(new Disguise(() -> Blocks.field_196617_K.func_176223_P()), (world, pos) -> (world.func_226691_t_(pos).func_201856_r() == Biome.Category.FOREST || world.func_226691_t_(pos).func_201856_r() == Biome.Category.PLAINS) && DEFAULT_TREE_CRITERON.apply((World)world, (BlockPos)pos) != false));
    public static final RegistryObject<Disguise> CACTUS = DISGUISES.register("cactus", () -> DisguiseRegistry.createDisguise(new Disguise(() -> Blocks.field_150434_aF.func_176223_P()), (world, pos) -> world.func_226691_t_(pos).func_201856_r() == Biome.Category.DESERT && DEFAULT_TREE_CRITERON.apply((World)world, (BlockPos)pos) != false));
    public static final RegistryObject<Disguise> CACTUS_TALL = DISGUISES.register("cactus_tall", () -> DisguiseRegistry.createDisguise(new Disguise(() -> Blocks.field_150434_aF.func_176223_P()), (world, pos) -> world.func_226691_t_(pos).func_201856_r() == Biome.Category.DESERT && DEFAULT_TREE_CRITERON.apply((World)world, (BlockPos)pos) != false));
    public static final RegistryObject<Disguise> BROWN_MUSHROOM_SMALL = DISGUISES.register("brown_mushroom_small", () -> DisguiseRegistry.createDisguise(new Disguise(() -> Blocks.field_196706_do.func_176223_P()), (world, pos) -> world.func_226691_t_(pos).func_201856_r() == Biome.Category.MUSHROOM && DEFAULT_TREE_CRITERON.apply((World)world, (BlockPos)pos) != false));
    public static final RegistryObject<Disguise> BROWN_MUSHROOM_MEDIUM = DISGUISES.register("brown_mushroom_medium", () -> DisguiseRegistry.createDisguise(new Disguise(() -> Blocks.field_196706_do.func_176223_P()), (world, pos) -> world.func_226691_t_(pos).func_201856_r() == Biome.Category.MUSHROOM && DEFAULT_TREE_CRITERON.apply((World)world, (BlockPos)pos) != false));
    public static final RegistryObject<Disguise> BROWN_MUSHROOM_BIG = DISGUISES.register("brown_mushroom_big", () -> DisguiseRegistry.createDisguise(new Disguise(() -> Blocks.field_196706_do.func_176223_P()), (world, pos) -> world.func_226691_t_(pos).func_201856_r() == Biome.Category.MUSHROOM && DEFAULT_TREE_CRITERON.apply((World)world, (BlockPos)pos) != false));
    public static final RegistryObject<Disguise> SPRUCE_TREE = DISGUISES.register("spruce_tree", () -> DisguiseRegistry.createDisguise(new Disguise(() -> Blocks.field_196618_L.func_176223_P()), (world, pos) -> world.func_226691_t_(pos).func_201856_r() == Biome.Category.TAIGA && DEFAULT_TREE_CRITERON.apply((World)world, (BlockPos)pos) != false));
    public static final RegistryObject<Disguise> SPRUCE_TREE_A = DISGUISES.register("spruce_tree_a", () -> DisguiseRegistry.createDisguise(new Disguise(() -> Blocks.field_196618_L.func_176223_P()), (world, pos) -> world.func_226691_t_(pos).func_201856_r() == Biome.Category.TAIGA && DEFAULT_TREE_CRITERON.apply((World)world, (BlockPos)pos) != false));
    public static final RegistryObject<Disguise> SPRUCE_TREE_B = DISGUISES.register("spruce_tree_b", () -> DisguiseRegistry.createDisguise(new Disguise(() -> Blocks.field_196618_L.func_176223_P()), (world, pos) -> world.func_226691_t_(pos).func_201856_r() == Biome.Category.TAIGA && DEFAULT_TREE_CRITERON.apply((World)world, (BlockPos)pos) != false));
    public static final RegistryObject<Disguise> SPRUCE_TREE_C = DISGUISES.register("spruce_tree_c", () -> DisguiseRegistry.createDisguise(new Disguise(() -> Blocks.field_196618_L.func_176223_P()), (world, pos) -> world.func_226691_t_(pos).func_201856_r() == Biome.Category.TAIGA && DEFAULT_TREE_CRITERON.apply((World)world, (BlockPos)pos) != false));
    public static final RegistryObject<Disguise> SPRUCE_TREE_D = DISGUISES.register("spruce_tree_d", () -> DisguiseRegistry.createDisguise(new Disguise(() -> Blocks.field_196618_L.func_176223_P()), (world, pos) -> world.func_226691_t_(pos).func_201856_r() == Biome.Category.TAIGA && DEFAULT_TREE_CRITERON.apply((World)world, (BlockPos)pos) != false));
    public static final RegistryObject<Disguise> SPRUCE_TREE_E = DISGUISES.register("spruce_tree_e", () -> DisguiseRegistry.createDisguise(new Disguise(() -> Blocks.field_196618_L.func_176223_P()), (world, pos) -> world.func_226691_t_(pos).func_201856_r() == Biome.Category.TAIGA && DEFAULT_TREE_CRITERON.apply((World)world, (BlockPos)pos) != false));
    public static final RegistryObject<Disguise> BIRCH_TREE = DISGUISES.register("birch_tree", () -> DisguiseRegistry.createDisguise(new Disguise(() -> Blocks.field_196619_M.func_176223_P()), (world, pos) -> (world.func_226691_t_(pos).func_201856_r() == Biome.Category.PLAINS || world.func_226691_t_(pos).getRegistryName().func_110623_a().contains("birch")) && DEFAULT_TREE_CRITERON.apply((World)world, (BlockPos)pos) != false));
    public static final RegistryObject<Disguise> BIRCH_TREE_A = DISGUISES.register("birch_tree_a", () -> DisguiseRegistry.createDisguise(new Disguise(() -> Blocks.field_196619_M.func_176223_P()), (world, pos) -> (world.func_226691_t_(pos).func_201856_r() == Biome.Category.PLAINS || world.func_226691_t_(pos).getRegistryName().func_110623_a().contains("birch")) && DEFAULT_TREE_CRITERON.apply((World)world, (BlockPos)pos) != false));
    public static final RegistryObject<Disguise> BIRCH_TREE_B = DISGUISES.register("birch_tree_b", () -> DisguiseRegistry.createDisguise(new Disguise(() -> Blocks.field_196619_M.func_176223_P()), (world, pos) -> (world.func_226691_t_(pos).func_201856_r() == Biome.Category.PLAINS || world.func_226691_t_(pos).getRegistryName().func_110623_a().contains("birch")) && DEFAULT_TREE_CRITERON.apply((World)world, (BlockPos)pos) != false));
    public static final RegistryObject<Disguise> BIRCH_TREE_C = DISGUISES.register("birch_tree_c", () -> DisguiseRegistry.createDisguise(new Disguise(() -> Blocks.field_196619_M.func_176223_P()), (world, pos) -> (world.func_226691_t_(pos).func_201856_r() == Biome.Category.PLAINS || world.func_226691_t_(pos).getRegistryName().func_110623_a().contains("birch")) && DEFAULT_TREE_CRITERON.apply((World)world, (BlockPos)pos) != false));
    public static final RegistryObject<Disguise> BIRCH_TREE_D = DISGUISES.register("birch_tree_d", () -> DisguiseRegistry.createDisguise(new Disguise(() -> Blocks.field_196619_M.func_176223_P()), (world, pos) -> (world.func_226691_t_(pos).func_201856_r() == Biome.Category.PLAINS || world.func_226691_t_(pos).getRegistryName().func_110623_a().contains("birch")) && DEFAULT_TREE_CRITERON.apply((World)world, (BlockPos)pos) != false));
    public static final RegistryObject<Disguise> BIRCH_TREE_E = DISGUISES.register("birch_tree_e", () -> DisguiseRegistry.createDisguise(new Disguise(() -> Blocks.field_196619_M.func_176223_P()), (world, pos) -> (world.func_226691_t_(pos).func_201856_r() == Biome.Category.PLAINS || world.func_226691_t_(pos).getRegistryName().func_110623_a().contains("birch")) && DEFAULT_TREE_CRITERON.apply((World)world, (BlockPos)pos) != false));
    public static final RegistryObject<Disguise> BIRCH_TREE_F = DISGUISES.register("birch_tree_f", () -> DisguiseRegistry.createDisguise(new Disguise(() -> Blocks.field_196619_M.func_176223_P()), (world, pos) -> (world.func_226691_t_(pos).func_201856_r() == Biome.Category.PLAINS || world.func_226691_t_(pos).getRegistryName().func_110623_a().contains("birch")) && DEFAULT_TREE_CRITERON.apply((World)world, (BlockPos)pos) != false));
    public static final RegistryObject<Disguise> ACACIA_TREE = DISGUISES.register("acacia_tree", () -> DisguiseRegistry.createDisguise(new Disguise(() -> Blocks.field_196621_O.func_176223_P()), (world, pos) -> world.func_226691_t_(pos).func_201856_r() == Biome.Category.SAVANNA && DEFAULT_TREE_CRITERON.apply((World)world, (BlockPos)pos) != false));
    public static final RegistryObject<Disguise> ACACIA_TREE_A = DISGUISES.register("acacia_tree_a", () -> DisguiseRegistry.createDisguise(new Disguise(() -> Blocks.field_196621_O.func_176223_P()), (world, pos) -> world.func_226691_t_(pos).func_201856_r() == Biome.Category.SAVANNA && DEFAULT_TREE_CRITERON.apply((World)world, (BlockPos)pos) != false));
    public static final RegistryObject<Disguise> ACACIA_TREE_B = DISGUISES.register("acacia_tree_b", () -> DisguiseRegistry.createDisguise(new Disguise(() -> Blocks.field_196621_O.func_176223_P()), (world, pos) -> world.func_226691_t_(pos).func_201856_r() == Biome.Category.SAVANNA && DEFAULT_TREE_CRITERON.apply((World)world, (BlockPos)pos) != false));
    public static final RegistryObject<Disguise> ACACIA_TREE_C = DISGUISES.register("acacia_tree_c", () -> DisguiseRegistry.createDisguise(new Disguise(() -> Blocks.field_196621_O.func_176223_P()), (world, pos) -> world.func_226691_t_(pos).func_201856_r() == Biome.Category.SAVANNA && DEFAULT_TREE_CRITERON.apply((World)world, (BlockPos)pos) != false));
    public static final RegistryObject<Disguise> ACACIA_TREE_D = DISGUISES.register("acacia_tree_d", () -> DisguiseRegistry.createDisguise(new Disguise(() -> Blocks.field_196621_O.func_176223_P()), (world, pos) -> world.func_226691_t_(pos).func_201856_r() == Biome.Category.SAVANNA && DEFAULT_TREE_CRITERON.apply((World)world, (BlockPos)pos) != false));
    public static final RegistryObject<Disguise> ACACIA_TREE_E = DISGUISES.register("acacia_tree_e", () -> DisguiseRegistry.createDisguise(new Disguise(() -> Blocks.field_196621_O.func_176223_P()), (world, pos) -> world.func_226691_t_(pos).func_201856_r() == Biome.Category.SAVANNA && DEFAULT_TREE_CRITERON.apply((World)world, (BlockPos)pos) != false));
    public static final RegistryObject<Disguise> CORAL_RED = DISGUISES.register("coral_fire", () -> DisguiseRegistry.createDisguise(new Disguise(() -> Blocks.field_203966_jH.func_176223_P()), coral_criteron));
    public static final RegistryObject<Disguise> CORAL_TUBE = DISGUISES.register("coral_tube", () -> DisguiseRegistry.createDisguise(new Disguise(() -> Blocks.field_203963_jE.func_176223_P()), coral_criteron));
    public static final RegistryObject<Disguise> CORAL_BRAIN = DISGUISES.register("coral_brain", () -> DisguiseRegistry.createDisguise(new Disguise(() -> Blocks.field_203964_jF.func_176223_P()), coral_criteron));
    public static final RegistryObject<Disguise> CORAL_BUBBLE = DISGUISES.register("coral_bubble", () -> DisguiseRegistry.createDisguise(new Disguise(() -> Blocks.field_203965_jG.func_176223_P()), coral_criteron));
    public static final RegistryObject<Disguise> DEFAULT_OCEAN = DISGUISES.register("default_ocean", () -> DisguiseRegistry.createDisguise(new Disguise(() -> Blocks.field_150354_m.func_176223_P()), coral_criteron));
    public static final RegistryObject<Disguise> NETHERRACK_PILLAR = DISGUISES.register("netherrack_pillar", () -> DisguiseRegistry.createDisguise(new Disguise(() -> Blocks.field_150424_aL.func_176223_P()), nether));
    public static final RegistryObject<Disguise> CRIMSON_TREE_A = DISGUISES.register("crimson_tree_a", () -> DisguiseRegistry.createDisguise(new Disguise(() -> Blocks.field_235377_mq_.func_176223_P()), (world, pos) -> DisguiseRegistry.getCriterionForBiome(world, (RegistryKey<World>)World.field_234919_h_, pos, (RegistryKey<Biome>)Biomes.field_235253_az_)));
    public static final RegistryObject<Disguise> CRIMSON_TREE_B = DISGUISES.register("crimson_tree_b", () -> DisguiseRegistry.createDisguise(new Disguise(() -> Blocks.field_235377_mq_.func_176223_P()), (world, pos) -> DisguiseRegistry.getCriterionForBiome(world, (RegistryKey<World>)World.field_234919_h_, pos, (RegistryKey<Biome>)Biomes.field_235253_az_)));
    public static final RegistryObject<Disguise> WARPED_TREE_A = DISGUISES.register("warped_tree_a", () -> DisguiseRegistry.createDisguise(new Disguise(() -> Blocks.field_235368_mh_.func_176223_P()), (world, pos) -> DisguiseRegistry.getCriterionForBiome(world, (RegistryKey<World>)World.field_234919_h_, pos, (RegistryKey<Biome>)Biomes.field_235250_aA_)));
    public static final RegistryObject<Disguise> WARPED_TREE_B = DISGUISES.register("warped_tree_b", () -> DisguiseRegistry.createDisguise(new Disguise(() -> Blocks.field_235368_mh_.func_176223_P()), (world, pos) -> DisguiseRegistry.getCriterionForBiome(world, (RegistryKey<World>)World.field_234919_h_, pos, (RegistryKey<Biome>)Biomes.field_235250_aA_)));
    public static final RegistryObject<Disguise> BONE_PILLAR = DISGUISES.register("bone_pillar", () -> DisguiseRegistry.createDisguise(new Disguise(() -> Blocks.field_189880_di.func_176223_P()), (world, pos) -> DisguiseRegistry.getCriterionForBiome(world, (RegistryKey<World>)World.field_234919_h_, pos, (RegistryKey<Biome>)Biomes.field_235252_ay_)));
    public static final RegistryObject<Disguise> BASALT_PILLAR = DISGUISES.register("basalt_pillar", () -> DisguiseRegistry.createDisguise(new Disguise(() -> Blocks.field_235337_cO_.func_176223_P()), (world, pos) -> DisguiseRegistry.getCriterionForBiome(world, (RegistryKey<World>)World.field_234919_h_, pos, (RegistryKey<Biome>)Biomes.field_235251_aB_)));
    public static final RegistryObject<Disguise> SMALL_ROCKET = DISGUISES.register("rocket_small", () -> DisguiseRegistry.createDisguise(new Disguise(() -> ((Block)((Block)TBlocks.alabaster.get())).func_176223_P()), MOON_CRITERON));
    public static final RegistryObject<Disguise> END_STONE = DISGUISES.register("end_stone", () -> DisguiseRegistry.createDisguise(new Disguise(() -> ((Block)Blocks.field_150377_bs).func_176223_P()), END));
    public static final RegistryObject<Disguise> CHORUS_TREE_SMALL = DISGUISES.register("chorus_tree_small", () -> DisguiseRegistry.createDisguise(new Disguise(() -> (BlockState)((BlockState)Blocks.field_185765_cR.func_176223_P().func_206870_a((Property)SixWayBlock.field_196489_A, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)SixWayBlock.field_196492_c, (Comparable)Boolean.valueOf(true)), () -> (BlockState)((BlockState)Blocks.field_185765_cR.func_176223_P().func_206870_a((Property)SixWayBlock.field_196489_A, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)SixWayBlock.field_196496_z, (Comparable)Boolean.valueOf(true))), (world, pos) -> DisguiseRegistry.getCriterionForBiome(world, (RegistryKey<World>)World.field_234920_i_, pos, (RegistryKey<Biome>)Biomes.field_201938_R)));
    public static final RegistryObject<Disguise> CHORUS_TREE_LARGE = DISGUISES.register("chorus_tree_large", () -> DisguiseRegistry.createDisguise(new Disguise(() -> (BlockState)((BlockState)Blocks.field_185765_cR.func_176223_P().func_206870_a((Property)SixWayBlock.field_196489_A, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)SixWayBlock.field_196490_b, (Comparable)Boolean.valueOf(true)), () -> (BlockState)((BlockState)Blocks.field_185765_cR.func_176223_P().func_206870_a((Property)SixWayBlock.field_196489_A, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)SixWayBlock.field_196496_z, (Comparable)Boolean.valueOf(true))), (world, pos) -> DisguiseRegistry.getCriterionForBiome(world, (RegistryKey<World>)World.field_234920_i_, pos, (RegistryKey<Biome>)Biomes.field_201938_R)));

    public static <T extends Disguise> T createDisguise(T dis, BiFunction<World, BlockPos, Boolean> valid) {
        dis.setValidationFunction(valid);
        return dis;
    }

    public static boolean getCriterionForWorld(World world, RegistryKey<World> worldKey) {
        return world.func_234923_W_() == worldKey;
    }

    public static boolean getCriterionForBiome(World world, RegistryKey<World> worldKey, BlockPos pos, RegistryKey<Biome> biomeKey) {
        if (!world.func_201670_d()) {
            ResourceLocation biomeKeyLoc = world.func_73046_m().func_244267_aX().func_243612_b(Registry.field_239720_u_).func_177774_c((Object)world.func_226691_t_(pos));
            if (biomeKey != null) {
                return world.func_234923_W_() == worldKey && biomeKeyLoc == biomeKey.func_240901_a_();
            }
            return false;
        }
        return false;
    }
}

