/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.registries;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;
import net.tardis.mod.ars.ConsoleRoom;
import net.tardis.mod.exterior.AbstractExterior;
import net.tardis.mod.misc.BrokenExteriorType;
import net.tardis.mod.misc.Console;
import net.tardis.mod.registries.ConsoleRegistry;
import net.tardis.mod.registries.ExteriorRegistry;

public class BrokenExteriors {
    public static final DeferredRegister<BrokenExteriorType> BROKEN_EXTERIOR_TYPES = DeferredRegister.create(BrokenExteriorType.class, (String)"tardis");
    public static Supplier<IForgeRegistry<BrokenExteriorType>> BROKEN_EXTERIOR_TYPE_REGISTRY = BROKEN_EXTERIOR_TYPES.makeRegistry("broken_exterior_type", () -> new RegistryBuilder().setMaxID(0x7FFFFFFE));
    public static final RegistryObject<BrokenExteriorType> WATER = BROKEN_EXTERIOR_TYPES.register("water", () -> new BrokenExteriorType(() -> (AbstractExterior)ExteriorRegistry.TRUNK.get(), () -> (Console)ConsoleRegistry.GALVANIC.get(), () -> ConsoleRoom.ABANDONED_PANAMAX, () -> new ConsoleRoom[]{ConsoleRoom.PANAMAX}));
    public static final RegistryObject<BrokenExteriorType> STEAM = BROKEN_EXTERIOR_TYPES.register("steam", () -> new BrokenExteriorType(() -> (AbstractExterior)ExteriorRegistry.STEAMPUNK.get(), () -> (Console)ConsoleRegistry.STEAM.get(), () -> ConsoleRoom.ABANDONED_STEAM, () -> new ConsoleRoom[]{ConsoleRoom.STEAM}));
    public static final RegistryObject<BrokenExteriorType> ALABASTER = BROKEN_EXTERIOR_TYPES.register("alabaster", () -> new BrokenExteriorType(() -> (AbstractExterior)ExteriorRegistry.TT_CAPSULE.get(), () -> (Console)ConsoleRegistry.HARTNELL.get(), () -> ConsoleRoom.ABANDONED_ALABASTER, () -> new ConsoleRoom[]{ConsoleRoom.ALABASTER}));
    public static final RegistryObject<BrokenExteriorType> JADE = BROKEN_EXTERIOR_TYPES.register("jade", () -> new BrokenExteriorType(() -> (AbstractExterior)ExteriorRegistry.BOKKUSU.get(), () -> (Console)ConsoleRegistry.XION.get(), () -> ConsoleRoom.ABANDONED_JADE, () -> new ConsoleRoom[]{ConsoleRoom.JADE}));
    public static final RegistryObject<BrokenExteriorType> NAUTILUS = BROKEN_EXTERIOR_TYPES.register("nautilus", () -> new BrokenExteriorType(() -> (AbstractExterior)ExteriorRegistry.FORTUNE.get(), () -> (Console)ConsoleRegistry.NEMO.get(), () -> ConsoleRoom.ABANDONED_NAUTILUS, () -> new ConsoleRoom[]{ConsoleRoom.NAUTILUS}));
    public static final RegistryObject<BrokenExteriorType> IMPERIAL = BROKEN_EXTERIOR_TYPES.register("imperial", () -> new BrokenExteriorType(() -> (AbstractExterior)ExteriorRegistry.TT_2020.get(), () -> (Console)ConsoleRegistry.POLYMEDICAL.get(), () -> ConsoleRoom.ABANDONED_IMPERIAL, () -> new ConsoleRoom[]{ConsoleRoom.IMPERIAL}));
    public static final RegistryObject<BrokenExteriorType> ENVOY = BROKEN_EXTERIOR_TYPES.register("envoy", () -> new BrokenExteriorType(() -> (AbstractExterior)ExteriorRegistry.SAFE.get(), () -> (Console)ConsoleRegistry.NEUTRON.get(), () -> ConsoleRoom.ENVOY, () -> new ConsoleRoom[0]));

    public static BrokenExteriorType getRandomBrokenType(Random rand) {
        ArrayList types = Lists.newArrayList((Iterable)BROKEN_EXTERIOR_TYPE_REGISTRY.get().getValues());
        return (BrokenExteriorType)((Object)types.get(rand.nextInt(types.size())));
    }
}

