/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Collection;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.tardis.mod.recipe.TardisRecipeSerialisers;
import net.tardis.mod.schematics.Schematic;
import net.tardis.mod.schematics.Schematics;

public class SpectrometerRecipe
implements IRecipe<RecipeWrapper> {
    private static final ItemStack DUMMY = new ItemStack((IItemProvider)Items.field_151034_e);
    public Ingredient input;
    public int ticks;
    public int downloadTicks = 200;
    private ResourceLocation registryName;
    private ResourceLocation schematic;
    public static final int DEFAULT_TICKS = 200;

    public static Collection<SpectrometerRecipe> getAllRecipes(World world) {
        return world.func_199532_z().func_241447_a_(TardisRecipeSerialisers.SPECTROMETER_TYPE);
    }

    public SpectrometerRecipe(int ticks, Ingredient input, ResourceLocation schematic) {
        this.input = input;
        this.schematic = schematic;
        this.ticks = ticks;
    }

    public boolean matches(RecipeWrapper inv, World worldIn) {
        ItemStack input = inv.func_70301_a(0);
        if (input.func_190926_b()) {
            return false;
        }
        return this.input.test(input);
    }

    public int getTicks() {
        return this.ticks;
    }

    public int getDownloadTicks() {
        return this.downloadTicks;
    }

    public SpectrometerRecipe setDownloadTicks(int downloadTicks) {
        this.downloadTicks = downloadTicks;
        return this;
    }

    public Ingredient getIngredient() {
        return this.input;
    }

    public ResourceLocation getSchematic() {
        return this.schematic;
    }

    public SpectrometerRecipe setRegistryName(ResourceLocation id) {
        this.registryName = id;
        return this;
    }

    public Schematic getSchematicObject() {
        return Schematics.SCHEMATIC_REGISTRY.get(this.schematic);
    }

    public ItemStack getCraftingResult(RecipeWrapper inv) {
        return DUMMY;
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_77571_b() {
        return DUMMY;
    }

    public ResourceLocation func_199560_c() {
        return this.registryName;
    }

    public NonNullList<Ingredient> func_192400_c() {
        NonNullList nonnulllist = NonNullList.func_191196_a();
        nonnulllist.add((Object)this.input);
        return nonnulllist;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)TardisRecipeSerialisers.SPECTROMETER_SERIALIZER.get();
    }

    public IRecipeType<?> func_222127_g() {
        return TardisRecipeSerialisers.SPECTROMETER_TYPE;
    }

    public JsonObject serialise() {
        JsonObject root = new JsonObject();
        root.add("type", (JsonElement)new JsonPrimitive(TardisRecipeSerialisers.SPECTROMETER_TYPE_LOC.toString()));
        root.add("processing_ticks", (JsonElement)new JsonPrimitive((Number)this.ticks));
        root.add("download_ticks", (JsonElement)new JsonPrimitive((Number)this.downloadTicks));
        root.add("ingredient", this.input.func_200304_c());
        root.add("result", (JsonElement)new JsonPrimitive(this.schematic.toString()));
        return root;
    }

    public static SpectrometerRecipe deserialiseFromJson(ResourceLocation recipeId, JsonObject inputJson) {
        int ticks = 200;
        if (inputJson.has("processing_ticks")) {
            ticks = inputJson.get("processing_ticks").getAsInt();
        }
        int downloadTicks = 200;
        if (inputJson.has("download_ticks")) {
            downloadTicks = inputJson.get("download_ticks").getAsInt();
        }
        SpectrometerRecipe recipe = new SpectrometerRecipe(ticks, Ingredient.func_199802_a((JsonElement)inputJson.get("ingredient")), new ResourceLocation(inputJson.get("result").getAsString()));
        recipe.setDownloadTicks(downloadTicks);
        recipe.setRegistryName(recipeId);
        return recipe;
    }

    public static SpectrometerRecipe deserialiseFromPacketBuffer(ResourceLocation recipeId, PacketBuffer buffer) {
        SpectrometerRecipe recipe = new SpectrometerRecipe(buffer.readInt(), Ingredient.func_199566_b((PacketBuffer)buffer), buffer.func_192575_l());
        int downloadTicks = buffer.readInt();
        recipe.setDownloadTicks(downloadTicks);
        recipe.setRegistryName(recipeId);
        return recipe;
    }

    public static void serialiseToPacketBuffer(PacketBuffer buffer, SpectrometerRecipe recipe) {
        buffer.writeInt(recipe.getTicks());
        recipe.getIngredient().func_199564_a(buffer);
        buffer.func_192572_a(recipe.getSchematic());
        buffer.writeInt(recipe.getDownloadTicks());
    }
}

