/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.recipe;

import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.tardis.mod.Tardis;
import net.tardis.mod.misc.IngredientCodec;
import net.tardis.mod.recipe.TardisRecipeSerialisers;
import net.tardis.mod.tileentities.inventory.PanelInventoryWrapper;
import org.apache.logging.log4j.Logger;

public class AttunableRecipe
implements IRecipe<PanelInventoryWrapper> {
    public static final AttunableRecipe EMPTY_RECIPE = new AttunableRecipe(false, 1, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ItemStack.field_190927_a}), new RecipeResult(Items.field_190931_a)).setRegistryId(new ResourceLocation("tardis", "empty_attunable_recipe"));
    private ResourceLocation id;
    private int ticksToAttunement;
    private Ingredient ingredients;
    private RecipeResult result;
    private boolean addNBTTag = false;
    private static final Codec<AttunableRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("add_attunement_tags").forGetter(AttunableRecipe::shouldAddNBTTags), (App)Codec.INT.fieldOf("attunement_ticks").forGetter(AttunableRecipe::getAttunementTicks), (App)IngredientCodec.INGREDIENT_CODEC.fieldOf("input").forGetter(AttunableRecipe::getInputIngredient), (App)RecipeResult.CODEC.fieldOf("result").forGetter(AttunableRecipe::getOutputResult)).apply((Applicative)instance, AttunableRecipe::new));

    public static Collection<AttunableRecipe> getAllRecipes(World world) {
        return world.func_199532_z().func_241447_a_(TardisRecipeSerialisers.ATTUNEABLE_RECIPE_TYPE);
    }

    public AttunableRecipe(boolean addNBTTag, int ticksToAttunement, Ingredient singleInput, RecipeResult singleOutput) {
        this.ticksToAttunement = ticksToAttunement;
        this.ingredients = singleInput;
        this.result = singleOutput;
        this.addNBTTag = addNBTTag;
    }

    public AttunableRecipe(int ticksToAttunement, Ingredient singleInput, RecipeResult singleOutput) {
        this(false, ticksToAttunement, singleInput, singleOutput);
    }

    public int getAttunementTicks() {
        return this.ticksToAttunement;
    }

    public Ingredient getInputIngredient() {
        return this.ingredients;
    }

    public RecipeResult getOutputResult() {
        return this.result;
    }

    public boolean shouldAddNBTTags() {
        return this.addNBTTag;
    }

    public Codec<AttunableRecipe> getCodec() {
        return CODEC;
    }

    public NonNullList<Ingredient> func_192400_c() {
        NonNullList nonnulllist = NonNullList.func_191196_a();
        nonnulllist.add((Object)this.ingredients);
        return nonnulllist;
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_77571_b() {
        ItemStack resultStack = new ItemStack((IItemProvider)this.result.getOutput());
        if (ItemStack.func_179545_c((ItemStack)resultStack, (ItemStack)this.ingredients.func_193365_a()[0])) {
            resultStack = this.ingredients.func_193365_a()[0].func_77946_l();
        }
        return resultStack;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public AttunableRecipe setRegistryId(ResourceLocation id) {
        this.id = id;
        return this;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)TardisRecipeSerialisers.ATTUNEABLE_SERIALISER.get();
    }

    public IRecipeType<?> func_222127_g() {
        return TardisRecipeSerialisers.ATTUNEABLE_RECIPE_TYPE;
    }

    public boolean matches(PanelInventoryWrapper inv, World worldIn) {
        if (inv.getPanelDirection() == Direction.EAST) {
            ItemStack stackInSlot = inv.func_70301_a(4);
            return this.ingredients.test(stackInSlot);
        }
        return false;
    }

    public ItemStack getCraftingResult(PanelInventoryWrapper inv) {
        return ItemStack.field_190927_a;
    }

    public static class AttunableRecipeSerializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<AttunableRecipe> {
        public AttunableRecipe read(ResourceLocation recipeId, JsonObject json) {
            AttunableRecipe recipe = (AttunableRecipe)CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).resultOrPartial(arg_0 -> ((Logger)Tardis.LOGGER).error(arg_0)).get();
            recipe.setRegistryId(recipeId);
            return recipe;
        }

        public AttunableRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            AttunableRecipe recipe = (AttunableRecipe)CODEC.parse((DynamicOps)NBTDynamicOps.field_210820_a, (Object)buffer.func_150793_b()).resultOrPartial(arg_0 -> ((Logger)Tardis.LOGGER).error(arg_0)).get();
            recipe.setRegistryId(recipeId);
            return recipe;
        }

        public void write(PacketBuffer buffer, AttunableRecipe recipe) {
            buffer.func_150786_a(CODEC.encodeStart((DynamicOps)NBTDynamicOps.field_210820_a, (Object)recipe).resultOrPartial(arg_0 -> ((Logger)Tardis.LOGGER).error(arg_0)).orElse(new CompoundNBT()));
        }
    }

    public static class RecipeResult {
        public static final Codec<RecipeResult> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Registry.field_212630_s.fieldOf("item").forGetter(RecipeResult::getOutput)).apply((Applicative)instance, RecipeResult::new));
        private Item output;

        public RecipeResult(Item output) {
            this.output = output;
        }

        public Item getOutput() {
            return this.output;
        }

        public void setOutput(Item input) {
            this.output = input;
        }
    }
}

