/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.tardis.mod.Tardis;
import net.tardis.mod.misc.AlembicJsonDataListener;
import net.tardis.mod.recipe.AlembicRecipeWrapper;
import net.tardis.mod.recipe.TardisRecipeSerialisers;
import net.tardis.mod.tileentities.machines.AlembicTile;

public class AlembicRecipe
implements IRecipe<AlembicRecipeWrapper> {
    private ResourceLocation id;
    private int requiredWaterAmount = 0;
    private int requiredNonWaterFluidAmount = 0;
    private int generatedFluidAmount = 0;
    private int progressTicks = 200;
    private Ingredient requiredBurnableIngredient = Ingredient.field_193370_a;
    private Ingredient fluidCollectionIngredient = Ingredient.field_193370_a;
    private int requiredIngredientCount = 1;
    private ResultType type = ResultType.ITEM;
    private ItemStack result;
    @Deprecated
    public static final AlembicJsonDataListener DATA_LOADER = new AlembicJsonDataListener("alembic", AlembicRecipe.class, Tardis.LOGGER, AlembicRecipe::fromJson);

    public static Collection<AlembicRecipe> getAllRecipes(World world) {
        return world.func_199532_z().func_241447_a_(TardisRecipeSerialisers.ALEMBIC_RECIPE_TYPE);
    }

    public AlembicRecipe(int requiredWater, int requiredIngredientCount, Ingredient requiredBurnableIngredient, ItemStack result) {
        this.requiredWaterAmount = requiredWater;
        this.requiredBurnableIngredient = requiredBurnableIngredient;
        this.requiredIngredientCount = requiredIngredientCount;
        this.result = result;
        this.type = ResultType.ITEM;
    }

    public AlembicRecipe(int requiredNonWaterFluidAmount, int requiredIngredientCount, ResultType type, Ingredient fluidCollectionIngredient, ItemStack result) {
        this.requiredWaterAmount = 0;
        this.requiredIngredientCount = requiredIngredientCount;
        this.requiredBurnableIngredient = Ingredient.field_193370_a;
        this.type = type;
        this.fluidCollectionIngredient = fluidCollectionIngredient;
        this.requiredNonWaterFluidAmount = requiredNonWaterFluidAmount;
        this.result = result;
    }

    public AlembicRecipe(int requiredWater, int requiredIngredientCount, Ingredient requiredBurnableIngredient) {
        this.requiredWaterAmount = requiredWater;
        this.requiredIngredientCount = requiredIngredientCount;
        this.requiredBurnableIngredient = requiredBurnableIngredient;
        this.type = ResultType.FLUID;
        this.result = ItemStack.field_190927_a;
        this.requiredNonWaterFluidAmount = 0;
    }

    public AlembicRecipe(PacketBuffer buf) {
        this.decode(buf);
    }

    public int getRequiredWater() {
        return this.requiredWaterAmount;
    }

    public int getGeneratedFluid() {
        return this.generatedFluidAmount;
    }

    public AlembicRecipe setGeneratedFluid(int generatedFluidAmount) {
        this.generatedFluidAmount = generatedFluidAmount;
        return this;
    }

    public int getRequiredNonWaterFluidAmount() {
        return this.requiredNonWaterFluidAmount;
    }

    public AlembicRecipe setRequiredNonWaterFluidAmount(int requiredNonWaterFluidAmount) {
        this.requiredNonWaterFluidAmount = requiredNonWaterFluidAmount;
        return this;
    }

    public Ingredient getRequiredBurnableIngredient() {
        return this.requiredBurnableIngredient;
    }

    public int getRequiredIngredientCount() {
        return this.requiredIngredientCount;
    }

    public Ingredient getFluidCollectionIngredient() {
        return this.fluidCollectionIngredient;
    }

    public int getRequiredProgressTicks() {
        return this.progressTicks;
    }

    public AlembicRecipe setProgressTicks(int ticks) {
        this.progressTicks = ticks;
        return this;
    }

    public ItemStack getResult() {
        return this.result.func_77946_l();
    }

    public AlembicRecipe setResult(ItemStack stack) {
        this.result = stack.func_77946_l();
        return this;
    }

    public ResultType getResultType() {
        return this.type;
    }

    public boolean matches(FluidStack fluid, ItemStack stack) {
        return fluid.getFluid().func_207185_a((ITag)FluidTags.field_206959_a) && fluid.getAmount() >= this.requiredWaterAmount && this.requiredBurnableIngredient.test(stack) && stack.func_190916_E() >= this.getRequiredIngredientCount();
    }

    public boolean matches(int nonWaterFluid, ItemStack input) {
        return nonWaterFluid >= this.requiredNonWaterFluidAmount && this.fluidCollectionIngredient.test(input);
    }

    public boolean matches(AlembicTile tile) {
        return this.type != ResultType.FLUID_COLLECTION ? this.matches(tile.getWaterTank().getFluid(), tile.getItemStackHandler().getStackInSlot(2)) : this.matches(tile.getNonWaterFluidAmount(), tile.getItemStackHandler().getStackInSlot(4));
    }

    public boolean matches(AlembicRecipeWrapper inv, World worldIn) {
        return this.matches(inv.getAlembicTile());
    }

    public void onCraft(AlembicTile tile) {
        boolean empty;
        if (this.type == ResultType.FLUID) {
            int amount = tile.getNonWaterFluidAmount() + this.generatedFluidAmount;
            tile.setNonWaterFluidAmount(amount);
            tile.func_70296_d();
        } else if (this.type == ResultType.ITEM && !(empty = this.getResult().func_190926_b())) {
            tile.getItemStackHandler().insertItem(5, this.getResult(), false);
        }
    }

    public void encode(PacketBuffer buf) {
        buf.func_192572_a(this.id);
        buf.writeInt(this.requiredIngredientCount);
        buf.writeInt(this.type.ordinal());
        buf.writeInt(this.requiredWaterAmount);
        buf.writeInt(this.generatedFluidAmount);
        buf.writeInt(this.requiredNonWaterFluidAmount);
        buf.writeInt(this.progressTicks);
        this.requiredBurnableIngredient.func_199564_a(buf);
        this.fluidCollectionIngredient.func_199564_a(buf);
        buf.func_150788_a(this.result);
    }

    public void decode(PacketBuffer buf) {
        this.id = buf.func_192575_l();
        this.requiredIngredientCount = buf.readInt();
        this.type = ResultType.values()[buf.readInt()];
        this.requiredWaterAmount = buf.readInt();
        this.generatedFluidAmount = buf.readInt();
        this.requiredNonWaterFluidAmount = buf.readInt();
        this.progressTicks = buf.readInt();
        this.requiredBurnableIngredient = Ingredient.func_199566_b((PacketBuffer)buf);
        this.fluidCollectionIngredient = Ingredient.func_199566_b((PacketBuffer)buf);
        this.result = buf.func_150791_c();
    }

    public JsonObject toJson() {
        JsonObject root = new JsonObject();
        JsonObject result = new JsonObject();
        JsonObject ingred = new JsonObject();
        if (this.requiredBurnableIngredient != Ingredient.field_193370_a) {
            ingred.add("item", this.requiredBurnableIngredient.func_200304_c());
        }
        if (this.fluidCollectionIngredient != Ingredient.field_193370_a) {
            ingred.add("item", this.fluidCollectionIngredient.func_200304_c());
        }
        ingred.addProperty("count", (Number)this.requiredIngredientCount);
        if (this.type != ResultType.ITEM) {
            result.addProperty("special", this.type.toString().toLowerCase());
            if (this.type == ResultType.FLUID) {
                result.addProperty("generated_fluid", (Number)this.generatedFluidAmount);
            } else {
                result.addProperty("fluid_collection_item", this.result.func_77973_b().getRegistryName().toString());
            }
        } else {
            result.addProperty("item", this.result.func_77973_b().getRegistryName().toString());
        }
        result.addProperty("count", (Number)this.result.func_190916_E());
        root.addProperty("type", TardisRecipeSerialisers.ALEMBIC_TYPE_LOC.toString());
        if (this.type != ResultType.FLUID_COLLECTION) {
            root.addProperty("required_water", (Number)this.requiredWaterAmount);
        } else {
            root.addProperty("required_fluid", (Number)this.requiredNonWaterFluidAmount);
        }
        root.add("ingredient", (JsonElement)ingred);
        root.add("result", (JsonElement)result);
        return root;
    }

    public static AlembicRecipe fromJson(JsonElement root) {
        try {
            int progressTicks;
            JsonObject object = root.getAsJsonObject();
            JsonObject result = object.get("result").getAsJsonObject();
            JsonObject ingred = object.get("ingredient").getAsJsonObject();
            Ingredient focalPoint = Ingredient.func_199802_a((JsonElement)ingred);
            int count = ingred.get("count").getAsInt();
            int requiredFluid = 1000;
            if (object.has("required_water")) {
                requiredFluid = object.get("required_water").getAsInt();
            }
            int n = progressTicks = object.has("progress_ticks") ? object.get("progress_ticks").getAsInt() : 200;
            if (result.has("item")) {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(result.get("item").getAsString()));
                ItemStack resultStack = new ItemStack((IItemProvider)item, result.get("count").getAsInt());
                return new AlembicRecipe(requiredFluid, count, focalPoint, resultStack).setProgressTicks(progressTicks);
            }
            if (result.has("special")) {
                if (result.get("special").getAsString().toLowerCase().equals(ResultType.FLUID.toString().toLowerCase())) {
                    int generatedFluid = 500;
                    if (result.has("generated_fluid")) {
                        generatedFluid = result.get("generated_fluid").getAsInt();
                    }
                    return new AlembicRecipe(requiredFluid, count, focalPoint).setGeneratedFluid(generatedFluid).setProgressTicks(progressTicks);
                }
                if (result.get("special").getAsString().toLowerCase().equals(ResultType.FLUID_COLLECTION.toString().toLowerCase())) {
                    String fluidCollectionKey = "fluid_collection_item";
                    if (object.has("required_fluid")) {
                        requiredFluid = object.get("required_fluid").getAsInt();
                    }
                    if (result.has(fluidCollectionKey)) {
                        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(result.get(fluidCollectionKey).getAsString()));
                        ItemStack resultStack = new ItemStack((IItemProvider)item, result.get("count").getAsInt());
                        return new AlembicRecipe(requiredFluid, count, ResultType.FLUID_COLLECTION, focalPoint, resultStack).setProgressTicks(progressTicks);
                    }
                    Tardis.LOGGER.warn("No Fluid Collection Item listed! Did you misspell or omit the JSON key name?");
                }
                return new AlembicRecipe(requiredFluid, count, focalPoint).setProgressTicks(progressTicks);
            }
            return null;
        }
        catch (Exception e) {
            Tardis.LOGGER.catching((Throwable)e);
            return null;
        }
    }

    public ItemStack getCraftingResult(AlembicRecipeWrapper inv) {
        return this.result;
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_77571_b() {
        return this.result;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public AlembicRecipe setRegistryId(ResourceLocation id) {
        this.id = id;
        return this;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)TardisRecipeSerialisers.ALEMBIC_SERIALISER.get();
    }

    public IRecipeType<?> func_222127_g() {
        return TardisRecipeSerialisers.ALEMBIC_RECIPE_TYPE;
    }

    public boolean func_192399_d() {
        return false;
    }

    public String func_193358_e() {
        return " ";
    }

    public static class AlembicRecipeSerializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<AlembicRecipe> {
        public AlembicRecipe read(ResourceLocation recipeId, JsonObject json) {
            AlembicRecipe recipe = AlembicRecipe.fromJson((JsonElement)json);
            recipe.setRegistryId(recipeId);
            return recipe;
        }

        public AlembicRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            ResourceLocation id = buffer.func_192575_l();
            int requiredCount = buffer.readInt();
            ResultType type = ResultType.values()[buffer.readInt()];
            int requiredWater = buffer.readInt();
            int generatedFluid = buffer.readInt();
            int requiredNonWaterFluid = buffer.readInt();
            int progressTicks = buffer.readInt();
            Ingredient focalPoint = Ingredient.func_199566_b((PacketBuffer)buffer);
            Ingredient fluidCollectionIngredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            ItemStack result = buffer.func_150791_c();
            AlembicRecipe recipe = null;
            if (type == ResultType.ITEM) {
                Item item = result.func_77973_b();
                ItemStack resultStack = new ItemStack((IItemProvider)item, result.func_190916_E());
                recipe = new AlembicRecipe(requiredWater, requiredCount, focalPoint, resultStack);
            } else if (type == ResultType.FLUID) {
                recipe = new AlembicRecipe(requiredWater, requiredCount, focalPoint).setGeneratedFluid(generatedFluid);
            } else if (type == ResultType.FLUID_COLLECTION) {
                Item item = result.func_77973_b();
                ItemStack resultStack = new ItemStack((IItemProvider)item, result.func_190916_E());
                recipe = new AlembicRecipe(requiredNonWaterFluid, requiredCount, type, fluidCollectionIngredient, resultStack);
            }
            recipe.setProgressTicks(progressTicks);
            recipe.setRegistryId(id);
            return recipe;
        }

        public void write(PacketBuffer buffer, AlembicRecipe recipe) {
            buffer.func_192572_a(recipe.id);
            buffer.writeInt(recipe.requiredIngredientCount);
            buffer.writeInt(recipe.type.ordinal());
            buffer.writeInt(recipe.requiredWaterAmount);
            buffer.writeInt(recipe.generatedFluidAmount);
            buffer.writeInt(recipe.requiredNonWaterFluidAmount);
            buffer.writeInt(recipe.progressTicks);
            recipe.requiredBurnableIngredient.func_199564_a(buffer);
            recipe.fluidCollectionIngredient.func_199564_a(buffer);
            buffer.func_150788_a(recipe.result);
        }
    }

    public static enum ResultType {
        ITEM,
        FLUID,
        FLUID_COLLECTION;

    }
}

