/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.protocols;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.tardis.mod.client.ClientHelper;
import net.tardis.mod.misc.GuiContext;
import net.tardis.mod.network.Network;
import net.tardis.mod.network.packets.ConsoleUpdateMessage;
import net.tardis.mod.network.packets.console.AntigravsData;
import net.tardis.mod.network.packets.console.DataTypes;
import net.tardis.mod.protocols.Protocol;
import net.tardis.mod.tileentities.ConsoleTile;

public class AntiGravProtocol
extends Protocol {
    public static final String TRANS = "message.tardis.anti_gravs.";
    public static final TranslationTextComponent TRANS_ON = new TranslationTextComponent("protocol.tardis.antigrav_on");
    public static final TranslationTextComponent TRANS_OFF = new TranslationTextComponent("protocol.tardis.antigrav_off");

    @Override
    public void call(World world, PlayerEntity playerIn, ConsoleTile console) {
        if (!world.field_72995_K) {
            console.setAntiGrav(!console.getAntiGrav());
            for (PlayerEntity player : world.func_217357_a(PlayerEntity.class, new AxisAlignedBB(console.func_174877_v()).func_186662_g(16.0))) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent(TRANS + console.getAntiGrav()), true);
            }
            Network.sendToAllAround(new ConsoleUpdateMessage(DataTypes.ANTIGRAVS, new AntigravsData(console.getAntiGrav())), (RegistryKey<World>)playerIn.field_70170_p.func_234923_W_(), playerIn.func_233580_cy_(), 64);
        } else {
            ClientHelper.openGUI(3, new GuiContext());
        }
    }

    @Override
    public TranslationTextComponent getDisplayName(ConsoleTile tile) {
        return tile.getAntiGrav() ? TRANS_ON : TRANS_OFF;
    }

    @Override
    public String getSubmenu() {
        return "exterior_prop";
    }
}

