/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.network.packets.exterior;

import net.minecraft.network.PacketBuffer;
import net.tardis.mod.enums.EnumDoorState;
import net.tardis.mod.network.packets.exterior.ExteriorData;
import net.tardis.mod.tileentities.exteriors.ExteriorTile;

public class DoorData
extends ExteriorData {
    EnumDoorState state;
    boolean locked;
    int deadlock;

    public DoorData(ExteriorData.Type type) {
        super(type);
    }

    public DoorData(EnumDoorState door, boolean locked, int deadLock) {
        super(ExteriorData.Type.DOOR);
        this.state = door;
        this.locked = locked;
        this.deadlock = deadLock;
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.func_179249_a((Enum)this.state);
        buf.writeBoolean(this.locked);
        buf.writeInt(this.deadlock);
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.state = (EnumDoorState)buf.func_179257_a(EnumDoorState.class);
        this.locked = buf.readBoolean();
        this.deadlock = buf.readInt();
    }

    @Override
    public void apply(ExteriorTile tile) {
        tile.setDoorState(this.state);
        tile.setLocked(this.locked);
        tile.setAdditionalLockLevel(this.deadlock);
    }

    public static DoorData create(ExteriorTile tile) {
        return new DoorData(tile.getOpen(), tile.getLocked(), tile.getAdditionalLockLevel());
    }
}

