/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.network.packets.data.Requestors;

import java.util.Optional;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.tileentity.TileEntity;

public abstract class Requestor<T extends TileEntity> {
    private Class<T> validClass;
    private int id;

    public Requestor(Class<T> validClass) {
        this.validClass = validClass;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public abstract void act(T var1, ServerPlayerEntity var2);

    public void tryToActOnTile(TileEntity tile, ServerPlayerEntity sender) {
        this.isValid(tile).ifPresent(te -> this.act(te, sender));
    }

    public Optional<T> isValid(TileEntity te) {
        if (this.validClass.isInstance(te)) {
            return Optional.of(this.cast(te));
        }
        return Optional.empty();
    }

    public T cast(TileEntity te) {
        return (T)((TileEntity)this.validClass.cast(te));
    }
}

