/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.network.packets.console;

import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;
import net.tardis.mod.network.packets.console.ConsoleData;
import net.tardis.mod.network.packets.console.DataType;
import net.tardis.mod.network.packets.console.DataTypes;
import net.tardis.mod.subsystem.Subsystem;
import net.tardis.mod.tileentities.ConsoleTile;

public class SubsystemData
implements ConsoleData {
    private boolean canBeUsed;
    private ResourceLocation key;
    private boolean activated;

    public SubsystemData(ResourceLocation key, boolean canBeUsed, boolean activated) {
        this.key = key;
        this.canBeUsed = canBeUsed;
        this.activated = activated;
    }

    @Override
    public void applyToConsole(ConsoleTile tile, Supplier<NetworkEvent.Context> context) {
        for (Subsystem s : tile.getSubSystems()) {
            if (!s.getEntry().getRegistryName().equals((Object)this.key)) continue;
            s.setCanBeUsed(this.canBeUsed);
            s.setActivated(this.activated);
            break;
        }
    }

    @Override
    public void serialize(PacketBuffer buff) {
        buff.func_192572_a(this.key);
        buff.writeBoolean(this.canBeUsed);
        buff.writeBoolean(this.activated);
    }

    @Override
    public void deserialize(PacketBuffer buff) {
        this.key = buff.func_192575_l();
        this.canBeUsed = buff.readBoolean();
        this.activated = buff.readBoolean();
    }

    @Override
    public DataType getDataType() {
        return DataTypes.SUBSYSTEM;
    }
}

