/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.network.packets.console;

import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.NetworkEvent;
import net.tardis.mod.network.packets.console.ConsoleData;
import net.tardis.mod.network.packets.console.DataType;
import net.tardis.mod.network.packets.console.DataTypes;
import net.tardis.mod.tileentities.ConsoleTile;

public class LandCode
implements ConsoleData {
    public static final String TRANSLATION_KEY = "message.tardis.transduction.set_code";
    String code;

    public LandCode(String code) {
        this.code = code;
        if (code.length() > 16) {
            this.code = code.substring(0, 16);
        }
    }

    @Override
    public void applyToConsole(ConsoleTile tile, Supplier<NetworkEvent.Context> context) {
        tile.setLandingCode(this.code);
        context.get().getSender().func_146105_b((ITextComponent)new TranslationTextComponent(TRANSLATION_KEY, new Object[]{this.code}), false);
    }

    @Override
    public void serialize(PacketBuffer buff) {
        buff.func_211400_a(this.code, 16);
    }

    @Override
    public void deserialize(PacketBuffer buff) {
        this.code = buff.func_150789_c(16);
    }

    @Override
    public DataType getDataType() {
        return DataTypes.LAND_CODE;
    }
}

