/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.network.packets.console;

import java.util.HashMap;
import java.util.Map;
import net.tardis.mod.helper.Helper;
import net.tardis.mod.network.packets.console.AntigravsData;
import net.tardis.mod.network.packets.console.CrashData;
import net.tardis.mod.network.packets.console.DataType;
import net.tardis.mod.network.packets.console.DimensionData;
import net.tardis.mod.network.packets.console.ForcefieldData;
import net.tardis.mod.network.packets.console.Fuel;
import net.tardis.mod.network.packets.console.LandCode;
import net.tardis.mod.network.packets.console.NavComData;
import net.tardis.mod.network.packets.console.SoundSchemeData;
import net.tardis.mod.network.packets.console.SubsystemData;
import net.tardis.mod.network.packets.console.UnlockData;
import net.tardis.mod.network.packets.console.UpgradeData;

public class DataTypes {
    public static Map<String, DataType> CONSOLE_DATA_TYPES = new HashMap<String, DataType>();
    public static final DataType LAND_CODE = DataTypes.addDataType("land_code", new DataType(() -> new LandCode("")));
    public static final DataType FUEL = DataTypes.addDataType("fuel", new DataType(() -> new Fuel(0.0f, 0.0f)));
    public static final DataType SOUND_SCHEME = DataTypes.addDataType("sound_scheme", new DataType(() -> new SoundSchemeData()));
    public static final DataType FORCEFIELD = DataTypes.addDataType("forcefield", new DataType(() -> new ForcefieldData(false)));
    public static final DataType ANTIGRAVS = DataTypes.addDataType("anti_gravs", new DataType(() -> new AntigravsData(false)));
    public static final DataType CRASH = DataTypes.addDataType("crash", new DataType(() -> new CrashData()));
    public static final DataType SUBSYSTEM = DataTypes.addDataType("subsystem", new DataType(() -> new SubsystemData(null, false, false)));
    public static final DataType NAV_COM = DataTypes.addDataType("nav_com", new DataType(() -> new NavComData(false)));
    public static final DataType DIMENSION_LIST = DataTypes.addDataType("dim_list", new DataType(() -> new DimensionData(0, 0)));
    public static final DataType UPGRADE = DataTypes.addDataType("upgrade", new DataType(() -> new UpgradeData(null, true)));
    public static final DataType UNLOCK = DataTypes.addDataType("unlock", new DataType(() -> new UnlockData(null)));

    private static DataType addDataType(String id, DataType type) {
        String regId = Helper.createRLString(id);
        DataType dataType = type.setRegistryId(regId);
        CONSOLE_DATA_TYPES.put(regId, dataType);
        return dataType;
    }
}

