/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.network.packets;

import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.helper.WorldHelper;
import net.tardis.mod.misc.SpaceTimeCoord;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.tileentities.WaypointBankTile;

public class WaypointSaveMessage {
    private static final String SUCCESS = "message.tardis.waypoint.saved";
    private static final String FAIL = "message.tardis.waypoint.save_fail";
    private static final String FAIL_DIM = "message.tardis.waypoint.save_fail_dimension";
    private String name;

    public WaypointSaveMessage(String name) {
        this.name = name;
    }

    public static void encode(WaypointSaveMessage mes, PacketBuffer buf) {
        buf.func_211400_a(mes.name, Short.MAX_VALUE);
    }

    public static WaypointSaveMessage decode(PacketBuffer buf) {
        return new WaypointSaveMessage(buf.func_150789_c(Short.MAX_VALUE));
    }

    public static void handle(WaypointSaveMessage mes, Supplier<NetworkEvent.Context> cont) {
        cont.get().enqueueWork(() -> TardisHelper.getConsoleInWorld((World)((NetworkEvent.Context)cont.get()).getSender().func_71121_q()).ifPresent(arg_0 -> WaypointSaveMessage.lambda$null$0((Supplier)cont, mes, arg_0)));
        cont.get().setPacketHandled(true);
    }

    private static /* synthetic */ void lambda$null$0(Supplier cont, WaypointSaveMessage mes, ConsoleTile console) {
        if (WorldHelper.canTravelToDimension((World)((NetworkEvent.Context)cont.get()).getSender().func_184102_h().func_71218_a(console.getCurrentDimension()))) {
            boolean success = false;
            for (TileEntity te : ((NetworkEvent.Context)cont.get()).getSender().func_71121_q().field_147482_g) {
                SpaceTimeCoord coord = new SpaceTimeCoord(console.getCurrentDimension(), console.getCurrentLocation(), console.getTrueExteriorFacingDirection());
                coord.setName(mes.name);
                if (!(te instanceof WaypointBankTile) || !(success = ((WaypointBankTile)te).addWaypoint(coord))) continue;
                ((NetworkEvent.Context)cont.get()).getSender().func_146105_b((ITextComponent)new TranslationTextComponent(SUCCESS, new Object[]{mes.name}), true);
                break;
            }
            if (!success) {
                ((NetworkEvent.Context)cont.get()).getSender().func_146105_b((ITextComponent)new TranslationTextComponent(FAIL, new Object[]{mes.name}), true);
            }
        } else {
            ((NetworkEvent.Context)cont.get()).getSender().func_146105_b((ITextComponent)new TranslationTextComponent(FAIL_DIM, new Object[]{mes.name}), true);
        }
    }
}

