/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.network.packets;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.tardis.mod.client.ClientPacketHandler;
import net.tardis.mod.misc.SpaceTimeCoord;
import net.tardis.mod.network.Network;
import net.tardis.mod.tileentities.WaypointBankTile;

public class WaypointOpenMessage {
    @Nullable
    Map<BlockPos, List<SpaceTimeCoord>> map;

    public WaypointOpenMessage(Map<BlockPos, List<SpaceTimeCoord>> map) {
        this.map = map;
    }

    @Nullable
    public Map<BlockPos, List<SpaceTimeCoord>> getWaypointMap() {
        return this.map;
    }

    public static void encode(WaypointOpenMessage mes, PacketBuffer buffer) {
        if (mes.map == null) {
            buffer.writeInt(0);
            return;
        }
        buffer.writeInt(mes.map.size());
        for (Map.Entry<BlockPos, List<SpaceTimeCoord>> entry : mes.map.entrySet()) {
            buffer.func_179255_a(entry.getKey());
            buffer.writeInt(entry.getValue().size());
            for (SpaceTimeCoord coord : entry.getValue()) {
                buffer.func_150786_a(coord.serialize());
            }
        }
    }

    public static WaypointOpenMessage decode(PacketBuffer buffer) {
        HashMap<BlockPos, List<SpaceTimeCoord>> coords = new HashMap<BlockPos, List<SpaceTimeCoord>>();
        int size = buffer.readInt();
        if (size == 0) {
            return new WaypointOpenMessage(null);
        }
        for (int i = 0; i < size; ++i) {
            BlockPos pos = buffer.func_179259_c();
            int size1 = buffer.readInt();
            ArrayList<SpaceTimeCoord> c = new ArrayList<SpaceTimeCoord>();
            for (int x = 0; x < size1; ++x) {
                c.add(SpaceTimeCoord.deserialize(buffer.func_150793_b()));
            }
            coords.put(pos, c);
        }
        return new WaypointOpenMessage(coords);
    }

    public static void handle(WaypointOpenMessage mes, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)context.get()).getDirection() == NetworkDirection.PLAY_TO_SERVER) {
                HashMap<BlockPos, List<SpaceTimeCoord>> map = new HashMap<BlockPos, List<SpaceTimeCoord>>();
                for (TileEntity te : ((NetworkEvent.Context)context.get()).getSender().field_70170_p.field_147482_g) {
                    if (!(te instanceof WaypointBankTile)) continue;
                    WaypointBankTile bank = (WaypointBankTile)te;
                    ArrayList coords = Lists.newArrayList(bank.getWaypoints());
                    map.put(bank.func_174877_v(), coords);
                }
                Network.sendTo(new WaypointOpenMessage(map), ((NetworkEvent.Context)context.get()).getSender());
            } else {
                ClientPacketHandler.handleWaypointOpenClient(mes);
            }
        });
        context.get().setPacketHandled(true);
    }
}

