/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.network.packets;

import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.misc.SpaceTimeCoord;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.tileentities.WaypointBankTile;

public class WaypointLoadMessage {
    public static final String TRANSLATION = "message.waypoint.loaded";
    BlockPos bank;
    int index = 0;

    public WaypointLoadMessage(BlockPos bank, int index) {
        this.index = index;
        this.bank = bank;
    }

    public static void encode(WaypointLoadMessage mes, PacketBuffer buf) {
        buf.func_179255_a(mes.bank);
        buf.writeInt(mes.index);
    }

    public static WaypointLoadMessage decode(PacketBuffer buf) {
        return new WaypointLoadMessage(buf.func_179259_c(), buf.readInt());
    }

    public static void handle(WaypointLoadMessage mes, Supplier<NetworkEvent.Context> cont) {
        cont.get().enqueueWork(() -> TardisHelper.getConsoleInWorld((World)((NetworkEvent.Context)cont.get()).getSender().func_71121_q()).ifPresent(arg_0 -> WaypointLoadMessage.lambda$null$0((Supplier)cont, mes, arg_0)));
        cont.get().setPacketHandled(true);
    }

    private static /* synthetic */ void lambda$null$0(Supplier cont, WaypointLoadMessage mes, ConsoleTile tile) {
        TileEntity te = ((NetworkEvent.Context)cont.get()).getSender().field_70170_p.func_175625_s(mes.bank);
        if (te instanceof WaypointBankTile) {
            SpaceTimeCoord coord = ((WaypointBankTile)te).getWaypoints().get(mes.index);
            tile.setDestination(coord);
            if (coord.getFacing() != null) {
                tile.setExteriorFacingDirection(coord.getFacing());
            }
        }
    }
}

