/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.network.packets;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;
import net.tardis.mod.client.ClientPacketHandler;
import net.tardis.mod.helper.WorldHelper;

public class VMGetWorldsMessage {
    private List<RegistryKey<World>> worlds = new ArrayList<RegistryKey<World>>();

    public VMGetWorldsMessage(List<RegistryKey<World>> worlds) {
        this.worlds.clear();
        this.worlds.addAll(worlds);
    }

    public static VMGetWorldsMessage create(MinecraftServer server) {
        ArrayList<RegistryKey<World>> worldsToAdd = new ArrayList<RegistryKey<World>>();
        for (ServerWorld world : server.func_212370_w()) {
            if (!WorldHelper.canVMTravelToDimension((World)world)) continue;
            worldsToAdd.add((RegistryKey<World>)world.func_234923_W_());
        }
        return new VMGetWorldsMessage(worldsToAdd);
    }

    public static void encode(VMGetWorldsMessage mes, PacketBuffer buf) {
        buf.writeInt(mes.worlds.size());
        for (RegistryKey<World> key : mes.worlds) {
            buf.func_180714_a(key.func_240901_a_().toString());
        }
    }

    public static VMGetWorldsMessage decode(PacketBuffer buf) {
        int size = buf.readInt();
        ArrayList<RegistryKey<World>> worlds = new ArrayList<RegistryKey<World>>();
        for (int i = 0; i < size; ++i) {
            String key = buf.func_150789_c(Short.MAX_VALUE);
            RegistryKey world = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(key));
            worlds.add((RegistryKey<World>)world);
        }
        return new VMGetWorldsMessage(worlds);
    }

    public static void handle(VMGetWorldsMessage mes, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> ClientPacketHandler.handleVMWorlds(mes));
        ctx.get().setPacketHandled(true);
    }

    public List<RegistryKey<World>> getWorlds() {
        return this.worlds;
    }
}

