/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.network.packets;

import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;
import net.tardis.mod.registries.VortexMFunctions;
import net.tardis.mod.vm.AbstractVortexMFunction;
import net.tardis.mod.vm.VortexMUseType;

public class VMFunctionMessage {
    public ResourceLocation function;
    public VortexMUseType useType;

    public VMFunctionMessage(ResourceLocation function, VortexMUseType useType) {
        this.function = function;
        this.useType = useType;
    }

    public static VMFunctionMessage decode(PacketBuffer buf) {
        return new VMFunctionMessage(buf.func_192575_l(), (VortexMUseType)buf.func_179257_a(VortexMUseType.class));
    }

    public static void encode(VMFunctionMessage mes, PacketBuffer buf) {
        buf.func_192572_a(mes.function);
        buf.func_179249_a((Enum)mes.useType);
    }

    public static void handle(VMFunctionMessage mes, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerWorld world = ((NetworkEvent.Context)ctx.get()).getSender().func_71121_q();
            AbstractVortexMFunction func = (AbstractVortexMFunction)VortexMFunctions.FUNCTIONS_REGISTRY.get().getValue(mes.function);
            if (mes.useType == VortexMUseType.SERVER || mes.useType == VortexMUseType.BOTH && func != null) {
                func.sendActionOnServer((World)world, ((NetworkEvent.Context)ctx.get()).getSender());
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

