/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.network.packets;

import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.config.TConfig;
import net.tardis.mod.helper.PlayerHelper;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.helper.TextHelper;
import net.tardis.mod.items.TItems;
import net.tardis.mod.misc.SpaceTimeCoord;
import net.tardis.mod.subsystem.AntennaSubsystem;
import net.tardis.mod.tileentities.console.misc.DistressSignal;

public class VMDistressMessage {
    private ResourceLocation id;
    private String message;
    private static final IFormattableTextComponent DISTRESS_MESSAGE = new TranslationTextComponent("message.vm.distress_signal_message");

    public VMDistressMessage(ResourceLocation id, String message) {
        this.id = id;
        this.message = message;
    }

    public static void encode(VMDistressMessage mes, PacketBuffer buf) {
        buf.func_192572_a(mes.id);
        buf.func_211400_a(mes.message, Short.MAX_VALUE);
    }

    public static VMDistressMessage decode(PacketBuffer buf) {
        return new VMDistressMessage(buf.func_192575_l(), buf.func_150789_c(Short.MAX_VALUE));
    }

    public static void handle(VMDistressMessage mes, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)context.get()).getSender();
            ServerWorld world = player.func_71121_q();
            TardisHelper.getConsole(player.func_184102_h(), mes.id).ifPresent(tile -> tile.getSubsystem(AntennaSubsystem.class).ifPresent(sys -> {
                if (sys.canBeUsed()) {
                    tile.addDistressSignal(new DistressSignal(mes.message.isEmpty() ? DISTRESS_MESSAGE.getString() : mes.message, new SpaceTimeCoord((RegistryKey<World>)world.func_234923_W_(), player.func_233580_cy_())));
                    tile.func_145831_w().getCapability(Capabilities.TARDIS_DATA).ifPresent(data -> PlayerHelper.sendMessageToPlayer((PlayerEntity)player, TextHelper.createVortexManipMessage((IFormattableTextComponent)new TranslationTextComponent("message.vm.distress_sent", new Object[]{data.getTARDISName()})), false));
                    player.func_184811_cZ().func_185145_a((Item)TItems.VORTEX_MANIP.get(), (Integer)TConfig.SERVER.vmCooldownTime.get() * 20);
                }
            }));
        });
        context.get().setPacketHandled(true);
    }
}

