/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.network.packets;

import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;
import net.tardis.mod.tileentities.machines.TransductionBarrierTile;

public class UpdateTransductionMessage {
    BlockPos pos;
    String code;

    public UpdateTransductionMessage(BlockPos pos, String code) {
        this.pos = pos;
        this.code = code;
    }

    public static void encode(UpdateTransductionMessage mes, PacketBuffer buff) {
        buff.func_179255_a(mes.pos);
        buff.writeInt(mes.code.length());
        buff.func_211400_a(mes.code, mes.code.length());
    }

    public static UpdateTransductionMessage decode(PacketBuffer buff) {
        BlockPos pos = buff.func_179259_c();
        int max = buff.readInt();
        return new UpdateTransductionMessage(pos, buff.func_150789_c(max));
    }

    public static void handle(UpdateTransductionMessage mes, Supplier<NetworkEvent.Context> cont) {
        cont.get().enqueueWork(() -> {
            World world = ((NetworkEvent.Context)cont.get()).getSender().field_70170_p;
            TileEntity te = world.func_175625_s(mes.pos);
            if (te instanceof TransductionBarrierTile) {
                ((TransductionBarrierTile)te).setCode(mes.code);
                ((NetworkEvent.Context)cont.get()).getSender().func_146105_b((ITextComponent)new TranslationTextComponent("message.tardis.transduction.set_code", new Object[]{mes.code}), false);
                ((NetworkEvent.Context)cont.get()).getSender().func_71121_q().func_184138_a(te.func_174877_v(), te.func_195044_w(), te.func_195044_w(), 3);
            }
        });
        cont.get().setPacketHandled(true);
    }
}

